/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.db.panels.sql.GroupByFromPicker;
import oracle.javatools.db.Column;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class GroupByToPicker
extends ReorderableListPicker {
    private SQLQueryBuilder m_builder;
    private JList m_list;
    private DefaultListModel m_model;
    private Map m_transferables = new HashMap();

    public GroupByToPicker() {
        super(new JList(new DefaultListModel()));
        this.m_list = super.getList();
        this.m_model = (DefaultListModel)this.m_list.getModel();
    }

    public void setBuilder(SQLQueryBuilder builder) {
        this.m_builder = builder;
        this.initList();
    }

    private void initList() {
        this.m_model.removeAllElements();
        GroupByObject gbo = this.m_builder.getSQLQuery().getGroupByObject();
        if (gbo != null) {
            SQLFragment[] cols = gbo.getExpressions();
            for (int i = 0; i < cols.length; ++i) {
                this.m_model.addElement(cols[i]);
            }
        }
    }

    public SQLFragment[] getExpressions() {
        int size = this.m_model.getSize();
        if (size > 0) {
            SQLFragment[] retval = new SQLFragment[size];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = (SQLFragment)this.m_model.get(i);
            }
            return retval;
        }
        return null;
    }

    protected Transferable createTransferable(Object obj) {
        if (this.m_transferables.containsKey(obj)) {
            return (GroupByFromPicker.GroupByTransferable)this.m_transferables.get(obj);
        }
        return null;
    }

    public boolean addSelectedItems(Transferable[] toAdd) {
        int[] selection = new int[toAdd.length];
        int addAt = this.m_model.getSize();
        for (int i = 0; i < toAdd.length; ++i) {
            Column obj = ((GroupByFromPicker.GroupByTransferable)toAdd[i]).getColumn();
            FromObject from = ((GroupByFromPicker.GroupByTransferable)toAdd[i]).getFromObject();
            ColumnUsage colu = new ColumnUsage(obj.getID(), from);
            int selIndex = addAt;
            if (!this.m_model.contains(colu)) {
                this.m_model.add(addAt++, colu);
                this.m_transferables.put(colu, toAdd[i]);
            } else {
                selIndex = this.m_model.indexOf(colu);
            }
            selection[i] = selIndex;
        }
        this.m_list.setSelectedIndices(selection);
        return true;
    }
}

