/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.JoinObjectEditDialog;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class FromJoinToPicker
extends AbstractTreePicker
implements DocumentListener {
    public static final String REMOVE_FROM_HELP_ID = "f1_offdbremovefromfromlist_html";
    private JPanel m_panel;
    private DefaultMutableTreeNode m_treeRoot = new DefaultMutableTreeNode("ROOT");
    private DefaultTreeModel m_treeModel = new DefaultTreeModel(this.m_treeRoot);
    private JTree m_tree = new JTree(this.m_treeModel);
    private DBObjectRenderer m_rend = new DBObjectRenderer();
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(true);
    private JLabel m_aliasLabel = new JLabel();
    private JTextField m_alias = new JTextField();
    private JButton m_joinButton = new JButton();
    private JButton m_editButton = new JButton();
    private boolean m_commitPending;
    private boolean m_ignoreTree;
    private DefaultMutableTreeNode m_current;
    private SQLQueryBuilder m_builder;
    private DBObjectProvider m_pro;
    private Schema m_schema;

    public FromJoinToPicker() {
        this.m_rend.setIncludeIcon(true);
        this.setTree(this.m_tree);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(this.m_rend);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("FromJoinToPicker");
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        int gridy = 0;
        this.m_panel.add((Component)new JScrollPane(this.m_tree), new GridBagConstraints(1, gridy, 4, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        reshelp.setName(this.m_tree, "Tree");
        reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIArb.getString(160), "Alias");
        this.m_panel.add((Component)this.m_aliasLabel, new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_alias.getDocument().addDocumentListener(this);
        this.m_panel.add((Component)this.m_alias, new GridBagConstraints(2, gridy, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, ++gridy, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        reshelp.resButton(this.m_joinButton, UIArb.getString(182), "Join");
        this.m_joinButton.addActionListener(this);
        this.m_panel.add((Component)this.m_joinButton, new GridBagConstraints(3, gridy, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        reshelp.resButton(this.m_editButton, UIArb.getString(181), "Edit");
        this.m_editButton.addActionListener(this);
        this.m_panel.add((Component)this.m_editButton, new GridBagConstraints(4, gridy, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void init(SQLQueryBuilder builder, DBObjectProvider provider, Schema defaultSchema) {
        this.m_builder = builder;
        this.m_pro = provider;
        this.m_schema = defaultSchema;
        this.m_aliasLabel.setEnabled(false);
        this.m_alias.setEnabled(false);
        this.m_joinButton.setEnabled(false);
        this.m_editButton.setEnabled(false);
        this.loadTree();
    }

    private void loadTree() {
        this.m_treeRoot.removeAllChildren();
        FromObject[] froms = this.m_builder.getSQLQuery().getFromObjects();
        for (int i = 0; i < froms.length; ++i) {
            this.m_treeRoot.add(this.m_nodeMaker.createTreeNode((SQLFragment)froms[i]));
        }
        this.reloadTreeUI();
    }

    private void reloadTreeUI() {
        this.m_treeModel.reload();
        IdeUtil.expandAllTreeRows((JTree)this.m_tree);
    }

    protected void setSelectedObject(FromObject from) {
        DefaultMutableTreeNode node;
        if (from != null && (node = this.findNode(from, this.m_treeRoot)) != null) {
            TreePath path = new TreePath(node.getPath());
            this.m_tree.setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode findNode(FromObject from, DefaultMutableTreeNode parent) {
        Enumeration<TreeNode> kids = parent.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)kids.nextElement();
            if (!from.equals(next.getUserObject())) continue;
            return next;
        }
        kids = parent.children();
        while (kids.hasMoreElements()) {
            this.findNode(from, (DefaultMutableTreeNode)kids.nextElement());
        }
        return null;
    }

    protected void commit() throws SQLQueryException {
        if (this.m_commitPending) {
            FromObject from = (FromObject)this.m_current.getUserObject();
            String alias = this.m_alias.getText();
            if (ModelUtil.areDifferent((Object)alias, (Object)from.getAlias())) {
                FromObject newFrom = (FromObject)from.copyTo(null);
                newFrom.setAlias(alias);
                this.m_builder.replaceFromObject(from, newFrom);
                this.m_treeModel.nodeChanged(this.m_current);
            }
            this.m_commitPending = false;
        }
    }

    protected void exit() throws TraversalException {
        try {
            this.commit();
            if (this.m_builder != null) {
                this.m_builder.syncViewColumns();
            }
        }
        catch (SQLQueryException sqe) {
            this.m_alias.requestFocus();
            throw new TraversalException(sqe.getMessage());
        }
    }

    private boolean isJoinNode(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof FromObject) {
            return ((FromObject)obj).getExpression() instanceof JoinObject;
        }
        return false;
    }

    private boolean isSubQueryNode(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof FromObject) {
            return ((FromObject)obj).getExpression() instanceof SQLQuery;
        }
        return false;
    }

    private void join(DefaultMutableTreeNode leftNode, DefaultMutableTreeNode rightNode) {
        JoinObject join = new JoinObject();
        FromObject newFrom = new FromObject((SQLFragment)join, null);
        FromObject left = (FromObject)leftNode.getUserObject();
        FromObject right = (FromObject)rightNode.getUserObject();
        join.setLeftExpression(left);
        join.setRightExpression(right);
        if (JoinObjectEditDialog.editJoin(newFrom, this.m_editButton, this.m_builder)) {
            DefaultMutableTreeNode joinNode = this.m_nodeMaker.createTreeNode((SQLFragment)newFrom);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)leftNode.getParent();
            parentNode.insert(joinNode, parentNode.getIndex(leftNode));
            parentNode.remove(leftNode);
            parentNode.remove(rightNode);
            this.reloadTreeUI();
            this.m_tree.scrollPathToVisible(new TreePath(joinNode.getPath()));
            AbstractSQLQuery query = this.m_builder.getSQLQuery();
            if (query instanceof DeclarativeSQLQuery) {
                query.removeFromObject(left);
                query.removeFromObject(right);
                try {
                    this.m_builder.addFromObject(newFrom);
                }
                catch (SQLQueryException sqe) {
                    Assert.printStackTrace((Throwable)sqe);
                    query.addFromObject(left);
                    query.addFromObject(right);
                }
            }
        }
    }

    private boolean edit(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof FromObject) {
            SQLFragment expression = ((FromObject)obj).getExpression();
            if (expression instanceof SQLQuery) {
                try {
                    SQLQueryEditDialog editor = new SQLQueryEditDialog();
                    SQLQuery newQuery = editor.editQuery((SQLQuery)expression, this.m_pro, this.m_schema);
                    if (ModelUtil.areDifferent((Object)newQuery, (Object)obj)) {
                        FromObject newFrom = new FromObject();
                        newFrom.setAlias(((FromObject)obj).getAlias());
                        newFrom.setExpression((SQLFragment)newQuery);
                        this.m_builder.replaceFromObject((FromObject)obj, newFrom);
                    }
                }
                catch (SQLQueryException sqe) {
                    DBExceptionDialog.showErrorDialog((Component)this.m_tree, UIArb.getString(180), (DBException)((Object)sqe));
                }
                return true;
            }
            if (expression instanceof JoinObject) {
                if (JoinObjectEditDialog.editJoin((FromObject)obj, this.m_editButton, this.m_builder)) {
                    expression = ((FromObject)obj).getExpression();
                    DefaultMutableTreeNode kid1 = (DefaultMutableTreeNode)node.getChildAt(0);
                    DefaultMutableTreeNode kid2 = (DefaultMutableTreeNode)node.getChildAt(1);
                    FromObject leftExpression = ((JoinObject)expression).getLeftExpression();
                    if (leftExpression == kid2.getUserObject()) {
                        kid1.removeFromParent();
                        node.add(kid1);
                        this.m_treeModel.reload(node);
                    } else {
                        this.m_treeModel.nodeStructureChanged(node);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void addJoinToSelection(DefaultMutableTreeNode joinNode, List selectionPath) {
        DefaultMutableTreeNode kid1 = (DefaultMutableTreeNode)joinNode.getChildAt(0);
        DefaultMutableTreeNode kid2 = (DefaultMutableTreeNode)joinNode.getChildAt(1);
        selectionPath.add(new TreePath(joinNode.getPath()));
        if (this.isJoinNode(kid1)) {
            this.addJoinToSelection(kid1, selectionPath);
        } else {
            selectionPath.add(new TreePath(kid1.getPath()));
        }
        if (this.isJoinNode(kid2)) {
            this.addJoinToSelection(kid2, selectionPath);
        } else {
            selectionPath.add(new TreePath(kid2.getPath()));
        }
    }

    private void addRelation(Relation rel, List selectionPath, DefaultMutableTreeNode parent) throws SQLQueryException {
        SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructFromObject(rel, false, false, null);
        FromObject from = (FromObject)set.getObject();
        DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode((SQLFragment)from);
        parent.add(node);
        selectionPath.add(new TreePath(node.getPath()));
    }

    private void addFKs(DBObject[] path, List selectionPath) throws SQLQueryException {
        ArrayList<DBObject> fkList = new ArrayList<DBObject>();
        for (int i = 0; i < path.length; ++i) {
            if (!(path[i] instanceof FKConstraint)) continue;
            fkList.add(path[i]);
        }
        FKConstraint[] fks = fkList.toArray(new FKConstraint[fkList.size()]);
        SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructFKJoins(fks, null);
        FromObject[] newFroms = set.getFromObjects();
        if (newFroms != null && newFroms.length > 0) {
            DefaultMutableTreeNode newNode = this.m_nodeMaker.createTreeNode((SQLFragment)newFroms[0], false);
            this.m_treeRoot.add(newNode);
            this.addJoinToSelection(newNode, selectionPath);
        }
    }

    @Override
    public boolean addSelectedItems(Transferable[] toAdd) {
        try {
            ArrayList selection = new ArrayList();
            for (int i = 0; i < toAdd.length; ++i) {
                DBObject obj = ((DBObjectTransferable)toAdd[i]).getDBObject();
                DBObject[] objPath = ((DBObjectTransferable)toAdd[i]).getPath();
                if (objPath == null || objPath.length == 1) {
                    if (!(obj instanceof Relation)) continue;
                    this.addRelation((Relation)obj, selection, this.m_treeRoot);
                    continue;
                }
                this.addFKs(objPath, selection);
            }
            this.reloadTreeUI();
            this.m_tree.setSelectionPaths(selection.toArray(new TreePath[selection.size()]));
            return true;
        }
        catch (SQLQueryException sqe) {
            DBExceptionDialog.showErrorDialog(this.getComponent(), null, (DBException)((Object)sqe));
            return false;
        }
    }

    @Override
    public Transferable createTransferable(TreePath path) {
        Object node = path.getLastPathComponent();
        if (node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof SQLFragment) {
            return new DBObjectTransferable(null);
        }
        return null;
    }

    @Override
    public Transferable[] getAllSelectableItems() {
        return new DBObjectTransferable[]{new DBObjectTransferable(null)};
    }

    @Override
    public void removeAllSelectableItems() {
        if (this.m_builder != null) {
            ArrayList<SQLFragment> deps = new ArrayList<SQLFragment>();
            FromObject[] froms = this.m_builder.listAllFromObjects();
            for (int i = 0; froms != null && i < froms.length; ++i) {
                deps.addAll(Arrays.asList(this.m_builder.getDependentObjects(froms[i])));
            }
            String message = UIArb.getString(176);
            if (deps.size() < 1 || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)UIArb.getString(177), (String)REMOVE_FROM_HELP_ID, (boolean)true)) {
                for (int i = 0; froms != null && i < froms.length; ++i) {
                    this.m_builder.removeFromObject(froms[i]);
                }
                this.clear();
            }
        }
    }

    protected void clear() {
        this.m_treeRoot.removeAllChildren();
        this.m_treeModel.reload();
    }

    @Override
    public void removeSelectedItems() {
        boolean bl;
        ArrayList<SQLFragment> dependents = new ArrayList<SQLFragment>();
        ArrayList<Object> fromsToDelete = new ArrayList<Object>();
        ArrayList<Object> joinsToDelete = new ArrayList<Object>();
        HashSet<DBObject> joinsWithDeletionFroms = new HashSet<DBObject>();
        TreePath[] selection = this.m_tree.getSelectionPaths();
        for (int i = 0; i < selection.length; ++i) {
            DBObject parent;
            Object deleteMe;
            Object object = selection[i].getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || !((deleteMe = ((DefaultMutableTreeNode)object).getUserObject()) instanceof FromObject)) continue;
            FromObject from = (FromObject)deleteMe;
            SQLFragment exp = from.getExpression();
            if (exp instanceof JoinObject) {
                joinsToDelete.add(deleteMe);
                continue;
            }
            SQLFragment[] deps = this.m_builder.getDependentObjects(from);
            if (deps != null) {
                dependents.addAll(Arrays.asList(deps));
            }
            if ((parent = from.getParent()) instanceof JoinObject) {
                joinsWithDeletionFroms.add(parent);
            }
            fromsToDelete.add(deleteMe);
        }
        for (JoinObject joinObject : joinsWithDeletionFroms) {
            FromObject right;
            FromObject left;
            if (!(joinObject.getParent() instanceof FromObject) || !fromsToDelete.contains(left = joinObject.getLeftExpression()) || !fromsToDelete.contains(right = joinObject.getRightExpression())) continue;
            fromsToDelete.remove(left);
            fromsToDelete.remove(right);
            fromsToDelete.add(joinObject.getParent());
            if (!joinsToDelete.contains(joinObject)) continue;
            joinsToDelete.remove(joinObject);
        }
        boolean bl2 = true;
        if (dependents.size() > 0) {
            String message = UIArb.getString(176);
            bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)UIArb.getString(177), (String)REMOVE_FROM_HELP_ID, (boolean)true);
        }
        if (bl) {
            int i;
            for (i = 0; i < fromsToDelete.size(); ++i) {
                Object toGo = fromsToDelete.get(i);
                if (!(toGo instanceof FromObject)) continue;
                this.m_builder.removeFromObject((FromObject)toGo);
            }
            for (i = 0; i < joinsToDelete.size(); ++i) {
                Object joinFrom = joinsToDelete.get(i);
                if (!(joinFrom instanceof FromObject)) continue;
                this.m_builder.removeJoinObject((FromObject)joinFrom);
            }
            this.m_commitPending = false;
            this.loadTree();
        }
    }

    @Override
    public Component getComponent() {
        return this.m_panel;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.m_ignoreTree) {
            if (this.m_alias.isEnabled()) {
                try {
                    this.commit();
                }
                catch (SQLQueryException sqe) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)sqe.getMessage(), (String)"", null);
                    this.m_ignoreTree = true;
                    this.m_tree.setSelectionPath(e.getOldLeadSelectionPath());
                    this.m_ignoreTree = false;
                    this.m_alias.requestFocus();
                    return;
                }
            }
            super.valueChanged(e);
            this.m_joinButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            DefaultMutableTreeNode fromNode = null;
            FromObject from = null;
            TreePath[] selection = this.m_tree.getSelectionPaths();
            if (selection != null) {
                if (selection.length == 1) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection[0].getLastPathComponent();
                    if (this.isJoinNode(node) || this.isSubQueryNode(node)) {
                        this.m_editButton.setEnabled(true);
                    } else if (node.getUserObject() instanceof FromObject) {
                        from = (FromObject)node.getUserObject();
                        fromNode = node;
                    }
                } else if (selection.length == 2) {
                    DefaultMutableTreeNode leftNode = (DefaultMutableTreeNode)selection[0].getLastPathComponent();
                    DefaultMutableTreeNode rightNode = (DefaultMutableTreeNode)selection[1].getLastPathComponent();
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)leftNode.getParent();
                    if (parentNode == rightNode.getParent() && !this.isJoinNode(parentNode)) {
                        this.m_joinButton.setEnabled(true);
                    }
                }
            }
            if (from != null) {
                if (fromNode != this.m_current) {
                    this.m_current = fromNode;
                    this.m_alias.setEnabled(true);
                    this.m_aliasLabel.setEnabled(true);
                    this.m_alias.setText(from.getAlias());
                    this.m_alias.requestFocus();
                    this.m_commitPending = false;
                }
            } else {
                this.m_current = null;
                this.m_alias.setText(null);
                this.m_alias.setEnabled(false);
                this.m_aliasLabel.setEnabled(false);
                this.m_commitPending = false;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_joinButton) {
            TreePath[] selection = this.m_tree.getSelectionPaths();
            if (selection.length == 2) {
                DefaultMutableTreeNode leftNode = (DefaultMutableTreeNode)selection[0].getLastPathComponent();
                DefaultMutableTreeNode rightNode = (DefaultMutableTreeNode)selection[1].getLastPathComponent();
                this.join(leftNode, rightNode);
            }
        } else if (source == this.m_editButton) {
            TreePath[] selection = this.m_tree.getSelectionPaths();
            if (selection.length == 1) {
                this.edit((DefaultMutableTreeNode)selection[0].getLastPathComponent());
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected boolean handleDefaultAction(TreePath path) {
        Object node = path.getLastPathComponent();
        if (node instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)node).getUserObject();
            if (this.isJoinNode((DefaultMutableTreeNode)node) || this.isSubQueryNode((DefaultMutableTreeNode)node)) {
                return this.edit((DefaultMutableTreeNode)node);
            }
        }
        return super.handleDefaultAction(path);
    }
}

