/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.FunctionComboBox;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class ExpressionPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
KeyListener,
TreeSelectionListener,
FocusListener {
    public static final String EMPTY = "<" + UIArb.getString(159) + ">";
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(false);
    private DBObjectProvider m_dboPro;
    private FragmentProvider m_fragPro;
    private SQLFragment m_current;
    private boolean m_ignoreList;
    private boolean m_entered;
    private JSplitPane m_expPanel;
    private JPanel m_templPanel;
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_templModel;
    private JTree m_templates;
    private FunctionComboBox m_functions;
    private JButton m_insertTemplate;
    private JButton m_insertFunction;
    private JLabel m_templateLabel;
    private JPanel m_listPanel;
    private DefaultListModel m_expressionsModel = new DefaultListModel();
    private JList m_expressions = new JList(this.m_expressionsModel);
    private final DBUIResourceHelper m_reshelp;
    private JButton m_new = new JButton();
    private JButton m_remove = new JButton();
    private JButton m_up = new JButton();
    private JButton m_down = new JButton();
    private JLabel m_listLabel = new JLabel();
    protected static final Dimension BUTTON_SIZE = new Dimension(28, 25);
    protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public ExpressionPanel(FragmentProvider pro) {
        this.m_fragPro = pro;
        this.m_reshelp = new DBUIResourceHelper(pro.getComponentNamePrefix() + ".ExpPanel");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridLayout(2, 1, 0, 5));
        this.createListPanel();
        this.add(this.m_listPanel);
        this.createExpressionPanel();
        this.add(this.m_expPanel);
    }

    private void createListPanel() {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.m_listPanel = new JPanel();
        this.m_listPanel.setLayout(new GridBagLayout());
        this.m_expressions.setSelectionMode(2);
        this.m_expressions.setCellRenderer(new DBObjectRenderer(false));
        this.m_expressions.addListSelectionListener(this);
        this.m_expressions.addKeyListener(this);
        this.m_listPanel.add((Component)new JScrollPane(this.m_expressions), new GridBagConstraints(1, 2, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.m_reshelp.resLabel(this.m_listLabel, this.m_expressions, this.m_fragPro.getListTitle(), "Expressions");
        this.m_listPanel.add((Component)this.m_listLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        Insets buttonInsets = new Insets(0, 0, 5, 0);
        GridBagConstraints buttonGbc = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, buttonInsets, 0, 0);
        this.m_new.setIcon(OracleIcons.getIcon((String)"add.png"));
        DBObjectRenderer.setToolTipText(this.m_new, UIArb.getString(167));
        this.m_new.setMnemonic('=');
        this.setupButton(this.m_new, this, BUTTON_SIZE, null, "New");
        ttm.registerComponent(this.m_new);
        this.m_listPanel.add((Component)this.m_new, buttonGbc);
        DBObjectRenderer.setToolTipText(this.m_remove, UIArb.getString(168));
        this.m_remove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.m_remove.setMnemonic('-');
        this.setupButton(this.m_remove, this, BUTTON_SIZE, null, "Remove");
        ttm.registerComponent(this.m_remove);
        ++buttonGbc.gridy;
        buttonGbc.insets.bottom = 10;
        this.m_listPanel.add((Component)this.m_remove, buttonGbc);
        DBObjectRenderer.setToolTipText(this.m_up, UIArb.getString(171));
        this.m_up.setIcon(OracleIcons.getIcon((String)"previous.png"));
        this.m_up.setMnemonic('u');
        this.setupButton(this.m_up, this, BUTTON_SIZE, null, "Up");
        ttm.registerComponent(this.m_up);
        ++buttonGbc.gridy;
        buttonGbc.insets.bottom = 5;
        this.m_listPanel.add((Component)this.m_up, buttonGbc);
        DBObjectRenderer.setToolTipText(this.m_down, UIArb.getString(172));
        this.m_down.setIcon(OracleIcons.getIcon((String)"next.png"));
        this.m_down.setMnemonic('d');
        this.setupButton(this.m_down, this, BUTTON_SIZE, null, "Down");
        ttm.registerComponent(this.m_down);
        ++buttonGbc.gridy;
        buttonGbc.insets.bottom = 0;
        this.m_listPanel.add((Component)this.m_down, buttonGbc);
    }

    private void createExpressionPanel() {
        this.m_templPanel = new JPanel();
        this.m_templPanel.setLayout(new GridBagLayout());
        this.m_expPanel = new JSplitPane(1, this.m_fragPro.getEditorUI(), this.m_templPanel);
        this.m_expPanel.setBorder(BorderFactory.createTitledBorder(this.m_fragPro.getEditorName()));
    }

    private void addTemplateBits() {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.m_templateLabel = new JLabel();
        this.m_top = new DefaultMutableTreeNode("PICKER");
        this.m_templModel = new DefaultTreeModel(this.m_top);
        this.m_templates = new JTree(this.m_templModel);
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(new DBObjectRenderer(true));
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        this.m_templates.addFocusListener(this);
        ttm.registerComponent(this.m_templates);
        this.m_reshelp.resLabel(this.m_templateLabel, this.m_templates, this.m_fragPro.getTemplateTitle(), "Templates");
        this.m_templPanel.add((Component)this.m_templateLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.m_insertTemplate = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        DBObjectRenderer.setToolTipText(this.m_insertTemplate, UIArb.getString(170));
        this.m_insertTemplate.setMnemonic('c');
        ttm.registerComponent(this.m_insertTemplate);
        this.setupButton(this.m_insertTemplate, this, null, EMPTY_INSETS, "InsertTemplate");
        this.m_templPanel.add((Component)this.m_insertTemplate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_templPanel.add((Component)new JScrollPane(this.m_templates), new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private void addFunctionBits() {
        this.m_insertFunction = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        DBObjectRenderer.setToolTipText(this.m_insertFunction, UIArb.getString(169));
        this.m_insertFunction.setMnemonic('t');
        ToolTipManager.sharedInstance().registerComponent(this.m_insertFunction);
        this.setupButton(this.m_insertFunction, this, null, EMPTY_INSETS, "InsertFunction");
        this.m_templPanel.add((Component)this.m_insertFunction, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_functions = new FunctionComboBox();
        this.m_reshelp.setName(this.m_functions, "Functions");
        this.m_templPanel.add((Component)this.m_functions, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
    }

    protected void initExpression() {
        Object obj = this.m_expressions.getSelectedValue();
        this.m_current = null;
        if (obj instanceof SQLFragment) {
            this.m_current = (SQLFragment)obj;
        }
        this.m_fragPro.edit(this.m_current);
    }

    public SQLFragment[] getExpressions() {
        int size = this.m_expressionsModel.getSize();
        SQLFragment[] retval = new SQLFragment[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = (SQLFragment)this.m_expressionsModel.getElementAt(i);
        }
        return retval;
    }

    public void addFunction(Object function) {
        if (this.m_functions == null) {
            this.addFunctionBits();
        }
        this.m_functions.addItem(function);
    }

    public void addTemplate(SQLFragment frag, boolean includeChildren) {
        if (this.m_templates == null) {
            this.addTemplateBits();
        }
        DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode(frag, includeChildren);
        this.m_templModel.insertNodeInto(node, this.m_top, this.m_top.getChildCount());
    }

    public void clearTemplates() {
        if (this.m_templModel != null) {
            this.m_top.removeAllChildren();
            this.m_templModel.reload();
        }
    }

    public void setDBObjectProvider(DBObjectProvider pro) {
        this.m_dboPro = pro;
    }

    private void addToExpression(SQLFragment frag) {
        String text = frag.getSQLText();
        this.m_fragPro.addToExpression(text);
    }

    private void addToExpression(Relation rel) {
        this.m_fragPro.addToExpression(rel.getName());
    }

    void showInvalidExpressionDialog(TraversalException te) {
        MessageDialog.error((Component)this, (Object)te.getMessage(), (String)UIArb.getString(163), null);
    }

    public void entered(SQLFragment[] exps, SQLFragment defaultObject) {
        int i;
        this.m_expressionsModel.removeAllElements();
        for (i = 0; exps != null && i < exps.length; ++i) {
            this.m_expressionsModel.addElement(exps[i]);
        }
        if (this.m_templModel != null) {
            this.m_templModel.reload();
        }
        if (this.m_expressionsModel.size() > 0) {
            i = this.m_expressionsModel.indexOf(defaultObject);
            if (i < 0) {
                i = 0;
            }
            this.m_expressions.setSelectedIndex(i);
            this.initExpression();
        }
        this.enableButtons();
        this.m_expPanel.setDividerLocation(250);
        this.m_entered = true;
    }

    public void exited() throws TraversalException {
        this.m_fragPro.commit();
        this.m_entered = false;
        this.m_current = null;
    }

    protected void enableButtons() {
        boolean enabled;
        JButton focusButt = null;
        if (this.m_up.isFocusOwner()) {
            focusButt = this.m_up;
        } else if (this.m_down.isFocusOwner()) {
            focusButt = this.m_down;
        } else if (this.m_new.isFocusOwner()) {
            focusButt = this.m_new;
        } else if (this.m_remove.isFocusOwner()) {
            focusButt = this.m_remove;
        }
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
        this.m_remove.setEnabled(false);
        int[] selected = this.m_expressions.getSelectedIndices();
        int size = this.m_expressionsModel.getSize();
        if (size > 1 && selected != null && selected.length == 1) {
            if (selected[0] == 0) {
                this.m_down.setEnabled(true);
            } else if (selected[0] == size - 1) {
                this.m_up.setEnabled(true);
            } else {
                this.m_up.setEnabled(true);
                this.m_down.setEnabled(true);
            }
        }
        if (selected != null && selected.length > 0) {
            this.m_remove.setEnabled(true);
        }
        boolean bl = enabled = selected != null && selected.length == 1;
        if (this.m_templates != null) {
            this.m_templateLabel.setEnabled(enabled);
            this.m_templates.setEnabled(enabled);
            this.m_insertTemplate.setEnabled(enabled);
        }
        if (this.m_functions != null) {
            this.m_functions.setEnabled(enabled);
            this.m_insertFunction.setEnabled(enabled);
        }
        if (focusButt != null && !focusButt.isEnabled() && this.m_listPanel != null) {
            this.m_listPanel.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newExpression() {
        try {
            this.m_fragPro.commit();
            this.m_current = this.m_fragPro.newFragment();
            this.m_ignoreList = true;
            try {
                this.m_expressionsModel.addElement(this.m_current);
                this.m_expressions.setSelectedValue(this.m_current, true);
            }
            finally {
                this.m_ignoreList = false;
            }
        }
        catch (TraversalException te) {
            this.showInvalidExpressionDialog(te);
        }
        this.enableButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSelectedExpressions() {
        int firstIndex = this.m_expressions.getSelectedIndex();
        Object[] selected = this.m_expressions.getSelectedValues();
        if (selected != null && selected.length > 0) {
            this.m_ignoreList = true;
            try {
                for (int i = 0; i < selected.length; ++i) {
                    if (selected[i] != EMPTY && !this.m_fragPro.removeFragment((SQLFragment)selected[i])) continue;
                    this.m_expressionsModel.removeElement(selected[i]);
                    int max = this.m_expressionsModel.size() - 1;
                    this.m_expressions.setSelectedIndex(firstIndex > max ? max : firstIndex);
                }
            }
            finally {
                this.m_ignoreList = false;
            }
            this.initExpression();
            this.enableButtons();
        }
    }

    private void insertCurrentTemplate() {
        Object last;
        TreePath p;
        if (this.m_templates != null && (p = this.m_templates.getSelectionPath()) != null && (last = p.getLastPathComponent()) != null && ((DefaultMutableTreeNode)last).isLeaf()) {
            Object obj = ((DefaultMutableTreeNode)last).getUserObject();
            if (obj instanceof SQLFragment) {
                this.addToExpression((SQLFragment)obj);
            } else if (obj instanceof Relation) {
                String name = ((Relation)obj).getName();
                if (this.m_dboPro != null) {
                    name = this.m_dboPro.getExternalName(name);
                }
                this.m_fragPro.addToExpression(name);
            } else if (obj instanceof Column) {
                Object parentObj;
                FastStringBuffer text = new FastStringBuffer();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)last).getParent();
                Object object = parentObj = parent == null ? null : parent.getUserObject();
                if (parentObj != null && parentObj instanceof FromObject) {
                    text.append(((FromObject)parentObj).getName());
                    text.append(".");
                } else {
                    Relation rel = ((Column)obj).getRelation();
                    if (rel != null) {
                        String name = ((Relation)obj).getName();
                        if (this.m_dboPro != null) {
                            name = this.m_dboPro.getExternalName(name);
                        }
                        text.append(name).append(".");
                    }
                }
                String name = ((Column)obj).getName();
                if (this.m_dboPro != null) {
                    name = this.m_dboPro.getExternalName(name);
                }
                text.append(name);
                this.m_fragPro.addToExpression(text.toString());
            }
        }
    }

    private void insertCurrentFunction() {
        Object func = this.m_functions.getSelectedItem();
        String toAdd = null;
        toAdd = func instanceof SQLFragment ? ((SQLFragment)func).getSQLText() : func.toString();
        if (ModelUtil.hasLength((String)toAdd)) {
            this.m_fragPro.addToExpression(toAdd);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_remove) {
            this.removeSelectedExpressions();
        } else if (source == this.m_insertFunction) {
            this.insertCurrentFunction();
        } else if (source == this.m_insertTemplate) {
            this.insertCurrentTemplate();
        } else if (source == this.m_new) {
            this.newExpression();
        } else if (source == this.m_up) {
            SQLFragment upMe = (SQLFragment)this.m_expressions.getSelectedValue();
            int here = this.m_expressions.getSelectedIndex();
            if (here > 0) {
                this.m_expressionsModel.removeElement(upMe);
                this.m_expressionsModel.add(here - 1, upMe);
                this.m_expressions.setSelectedValue(upMe, true);
                this.m_fragPro.moveFragment(upMe, here - 1);
            }
        } else if (source == this.m_down) {
            int size;
            SQLFragment downMe = (SQLFragment)this.m_expressions.getSelectedValue();
            int here = this.m_expressions.getSelectedIndex();
            if (here < (size = this.m_expressionsModel.getSize()) - 1) {
                this.m_expressionsModel.removeElement(downMe);
                this.m_expressionsModel.add(here + 1, downMe);
                this.m_expressions.setSelectedValue(downMe, true);
                this.m_fragPro.moveFragment(downMe, here + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.m_entered && !this.m_ignoreList && e.getSource() == this.m_expressions) {
            Object obj = this.m_expressions.getSelectedValue();
            try {
                if (obj != this.m_current && (obj != EMPTY || this.m_current != null)) {
                    this.m_fragPro.commit();
                    this.initExpression();
                }
            }
            catch (TraversalException te) {
                this.showInvalidExpressionDialog(te);
                this.m_ignoreList = true;
                try {
                    this.m_expressions.setSelectedValue(this.m_current == null ? EMPTY : this.m_current, false);
                }
                finally {
                    this.m_ignoreList = false;
                }
            }
            this.enableButtons();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (e.getClickCount() % 2 == 0 && source == this.m_templates && this.m_templates.isEnabled()) {
            this.insertCurrentTemplate();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.m_expressions) {
            int code = e.getKeyCode();
            switch (code) {
                case 127: {
                    this.removeSelectedExpressions();
                    break;
                }
                case 155: {
                    this.newExpression();
                    break;
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        this.m_templates.scrollPathToVisible(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.m_insertTemplate.setEnabled(node.isLeaf());
    }

    @Override
    public void focusGained(FocusEvent e) {
        int[] rows;
        if (e.getComponent() == this.m_templates && (rows = this.m_templates.getSelectionRows()) == null) {
            this.m_templates.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void setupButton(JButton button, ActionListener list, Dimension size, Insets margins, String compName) {
        ExpressionPanel.setupButton(button, list, size, margins);
        this.m_reshelp.setName(button, compName);
    }

    protected static void setupButton(JButton button, ActionListener list, Dimension size, Insets margins) {
        if (list != null) {
            button.addActionListener(list);
        }
        if (size != null) {
            button.setMaximumSize(size);
            button.setMinimumSize(size);
            button.setPreferredSize(size);
        }
        if (margins != null) {
            button.setMargin(margins);
        }
    }

    public static interface FragmentProvider {
        public SQLFragment newFragment();

        public boolean removeFragment(SQLFragment var1);

        public void moveFragment(SQLFragment var1, int var2);

        public JPanel getEditorUI();

        public void commit() throws TraversalException;

        public void edit(SQLFragment var1);

        public void addToExpression(String var1);

        public String getEditorName();

        public String getListTitle();

        public String getTemplateTitle();

        public String getComponentNamePrefix();
    }
}

