/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryPickerPanel
extends SelectDBObjectsPanel {
    private String[] m_types;
    private SQLQueryBuilder m_builder;
    private boolean m_nondecl;
    private SchemaObject m_sObj;
    private boolean m_canAlwaysNext = true;

    protected BaseSQLQueryPickerPanel() {
    }

    protected BaseSQLQueryPickerPanel(boolean canAlwaysNext) {
        this.m_canAlwaysNext = canAlwaysNext;
    }

    protected final SQLQueryBuilder getBuilder() {
        return this.m_builder;
    }

    protected final SchemaObject getSchemaObject() {
        return this.m_sObj;
    }

    @Override
    protected final String[] getAvailableTypes() {
        if (this.m_types == null) {
            this.m_types = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW"};
        }
        return this.m_types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init(boolean providerChanged, TraversableContext dataContext) {
        String timestampSuspendKey = "Bug7538739.BaseSQLQueryPickerPanel";
        DBObjectProvider prov = (DBObjectProvider)dataContext.get("DBObjectProvider");
        try {
            Object newObject;
            if (prov instanceof DictionaryDatabase) {
                ((DictionaryDatabase)prov).suspendTimestampQueries("Bug7538739.BaseSQLQueryPickerPanel");
            }
            this.m_sObj = (newObject = dataContext.get("NewObject")) instanceof SchemaObject ? (SchemaObject)newObject : null;
            this.m_builder = (SQLQueryBuilder)dataContext.get(SQLQueryBuilder.class);
            Schema schema = this.m_sObj != null ? this.m_sObj.getSchema() : (Schema)dataContext.get("Schema");
            SQLQueryBuilderFactory factory = (SQLQueryBuilderFactory)dataContext.get(SQLQueryBuilderFactory.class);
            if (factory == null) {
                factory = this.getProvider().getDescriptor().getSQLQueryBuilderFactory();
                dataContext.put(SQLQueryBuilderFactory.class.getName(), (Object)factory);
            }
            super.init(providerChanged, dataContext);
            if (this.m_builder == null) {
                SQLQuery query = null;
                if (newObject instanceof SQLQueryOwner) {
                    query = ((SQLQueryOwner)newObject).getSQLQuery();
                } else if (newObject instanceof SQLQuery) {
                    query = (SQLQuery)newObject;
                }
                try {
                    this.m_builder = factory.createSQLQueryBuilder(this.getProvider(), schema);
                    this.m_builder.buildQuery(query);
                    AbstractSQLQuery newQuery = this.m_builder.getSQLQuery();
                    TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)newQuery);
                    newQuery.setID((DBObjectID)id);
                    dataContext.put(SQLQueryBuilder.class.getName(), (Object)this.m_builder);
                    if (newObject instanceof SQLQueryOwner) {
                        ((SQLQueryOwner)newObject).setSQLQuery((SQLQuery)newQuery);
                    } else if (newObject instanceof SQLQuery) {
                        dataContext.put("NewObject", (Object)newQuery);
                    }
                }
                catch (SQLQueryException sqe) {
                    // empty catch block
                }
            }
            if (this.m_builder == null || this.m_builder.getSQLQuery() instanceof NonDeclarativeSQLQuery) {
                this.clearToPicker();
                this.m_shuttle.setEnabled(false);
                this.removeAll();
                this.setLayout(new BorderLayout());
                this.add((Component)new JWrappedLabel(UIArb.getString(271)), "North");
                this.m_nondecl = true;
            } else {
                if (this.m_nondecl) {
                    this.removeAll();
                    this.layoutComponents();
                    this.m_nondecl = false;
                }
                this.m_shuttle.setEnabled(true);
                this.initToPicker(this.m_builder, this.getProvider(), schema);
                Object pro = dataContext.get("DBObjectProvider");
                if (pro instanceof DictionaryDatabase) {
                    ((DictionaryDatabase)pro).suspendTimestampQueries("DBObjectProvider");
                }
            }
        }
        finally {
            if (prov instanceof DictionaryDatabase) {
                ((DictionaryDatabase)prov).resumeTimestampQueries("Bug7538739.BaseSQLQueryPickerPanel");
            }
        }
    }

    protected abstract void clearToPicker();

    protected abstract void initToPicker(SQLQueryBuilder var1, DBObjectProvider var2, Schema var3);

    @Override
    public final void commit(TraversableContext dataContext) throws TraversalException {
        Object pro;
        if (this.m_builder != null) {
            this.commitToPicker(dataContext);
        }
        if ((pro = dataContext.get("DBObjectProvider")) instanceof DictionaryDatabase) {
            ((DictionaryDatabase)pro).resumeTimestampQueries("DBObjectProvider");
        }
    }

    protected abstract void commitToPicker(TraversableContext var1) throws TraversalException;

    @Override
    protected boolean canFinish() {
        return true;
    }

    @Override
    protected boolean canAlwaysNext() {
        return this.m_canAlwaysNext;
    }
}

