/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import oracle.ide.db.UIArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryBuilderPanel
extends DefaultTraversablePanel {
    private boolean m_canFinish = true;
    protected WizardCallbacks m_wc;
    protected DialogCallbacks m_dc;
    protected Namespace m_namespace;
    protected DBObjectProvider m_pro;
    protected SQLQueryBuilderFactory m_fac;
    protected SchemaObject m_sObj;
    protected Schema m_defaultSchema;
    protected String m_parseMessage;
    private boolean m_noBuilderLayout;
    private Object m_object;

    protected BaseSQLQueryBuilderPanel() {
    }

    protected abstract void layoutComponents();

    protected void layoutNoBuilder() {
        this.layoutMessageOnly(UIArb.getString(271));
    }

    protected void layoutMessageOnly(String text) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JTextPane message = new JTextPane();
        message.setText(text);
        message.getAccessibleContext().setAccessibleName(text);
        message.getAccessibleContext().setAccessibleDescription("");
        message.setEditable(false);
        message.setOpaque(false);
        message.setEnabled(true);
        message.setBorder(BorderFactory.createEmptyBorder());
        this.add(message, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEntry(TraversableContext tc) {
        String timestampSuspendKey = "Bug7538739.BaseSQLQueryBuilderPanel";
        DBObjectProvider prov = (DBObjectProvider)tc.get("DBObjectProvider");
        if (prov != null) {
            this.m_pro = prov;
        }
        try {
            AbstractSQLQuery newQuery;
            if (this.m_pro instanceof DictionaryDatabase) {
                ((DictionaryDatabase)this.m_pro).suspendTimestampQueries("Bug7538739.BaseSQLQueryBuilderPanel");
            }
            this.m_namespace = tc;
            this.m_wc = tc.getWizardCallbacks();
            this.m_dc = tc.getDialogCallbacks();
            Schema currSchema = (Schema)tc.get("Schema");
            if (currSchema != null) {
                this.m_defaultSchema = currSchema;
            }
            this.m_fac = (SQLQueryBuilderFactory)tc.get(SQLQueryBuilderFactory.class);
            if (this.m_fac == null && this.m_pro != null) {
                this.m_fac = this.m_pro.getDescriptor().getSQLQueryBuilderFactory();
                tc.put(SQLQueryBuilderFactory.class.getName(), (Object)this.m_fac);
            }
            this.m_object = tc.get("NewObject");
            this.m_sObj = this.m_object instanceof SchemaObject ? (SchemaObject)this.m_object : null;
            SQLQuery query = BaseSQLQueryBuilderPanel.findQuery((Namespace)tc);
            SQLQueryBuilder builder = (SQLQueryBuilder)tc.get(SQLQueryBuilder.class);
            if (!this.isQueryPanel() && builder == null && query != null && this.m_fac != null) {
                try {
                    builder = this.m_fac.createSQLQueryBuilder(this.m_pro, this.m_defaultSchema);
                    builder.buildQuery(query);
                    newQuery = builder.getSQLQuery();
                    TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)newQuery);
                    newQuery.setID((DBObjectID)id);
                    if (newQuery != null && this.m_object instanceof SQLQueryOwner) {
                        newQuery.setParent((DBObject)this.m_object);
                    }
                }
                catch (SQLQueryException sqe) {
                    this.m_parseMessage = sqe.getMessage();
                }
                tc.put(SQLQueryBuilder.class.getName(), (Object)builder);
            }
            if (!this.isQueryPanel() && builder != null && (newQuery = builder.getSQLQuery()) != query) {
                query = newQuery;
                if (this.m_object instanceof SQLQueryOwner) {
                    ((SQLQueryOwner)this.m_object).setSQLQuery((SQLQuery)newQuery);
                } else if (this.m_object instanceof SQLQuery) {
                    tc.put("NewObject", this.m_object);
                }
            }
            if ((builder == null || query instanceof NonDeclarativeSQLQuery) && this.invalidWithoutBuilder()) {
                this.removeAll();
                this.layoutNoBuilder();
                this.m_noBuilderLayout = true;
            } else {
                if (this.m_noBuilderLayout) {
                    this.removeAll();
                    this.layoutComponents();
                    this.m_noBuilderLayout = false;
                }
                DBObject child = (DBObject)tc.get("DefaultChild");
                this.init(builder, child);
            }
            this.validate();
        }
        finally {
            if (this.m_pro instanceof DictionaryDatabase) {
                ((DictionaryDatabase)this.m_pro).resumeTimestampQueries("Bug7538739.BaseSQLQueryBuilderPanel");
            }
        }
    }

    protected boolean isQueryPanel() {
        return false;
    }

    protected boolean invalidWithoutBuilder() {
        return true;
    }

    protected void enableButtons(boolean canAdvance) {
        if (this.m_wc != null) {
            this.m_wc.wizardEnableButtons(null, canAdvance ? Boolean.TRUE : Boolean.FALSE, this.m_canFinish ? Boolean.TRUE : Boolean.FALSE);
        } else if (this.m_dc != null) {
            // empty if block
        }
    }

    protected void setCanFinish(boolean canFinish) {
        this.m_canFinish = canFinish;
    }

    protected abstract void init(SQLQueryBuilder var1, DBObject var2);

    protected static SQLQuery findQuery(Namespace namespace) {
        Object newObject = namespace.get("NewObject");
        SQLQuery query = null;
        if (newObject instanceof SQLQuery) {
            query = (SQLQuery)newObject;
        } else if (newObject instanceof SQLQueryOwner) {
            query = ((SQLQueryOwner)newObject).getSQLQuery();
        }
        return query;
    }

    protected Object getObject() {
        return this.m_object;
    }
}

