/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.plsql.ParamsModel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.PlSqlParametersVerifier;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.icons.OracleIcons;

public class PlSqlParametersPanel
extends BaseInfoPanel {
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();
    private JButton btnUp = new JButton();
    private JButton btnDown = new JButton();
    private JScrollPane scrParams = new JScrollPane();
    private JTable tblParams = new JTable();
    private DBObjectRenderer _renderer;
    private NonNullableComboBoxModel _mdlMode = new NonNullableComboBoxModel();
    private DefaultComboBoxModel _mdlType = new DefaultComboBoxModel();
    private TableColumnModel _mdlCols = new DefaultTableColumnModel();
    private ParamsModel _mdlParams = new ParamsModel();
    private L _listener = new L();
    private Schema _defSchema;
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String UP_CMD = "UP";
    private static final String DOWN_CMD = "DOWN";

    public PlSqlParametersPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._defSchema = ((SchemaObject)traversableContext.find("NewObject")).getSchema();
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (DeclarativePlSql)traversableContext.find("NewObject"), (Verifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((DeclarativePlSql)traversableContext.find("NewObject"), (PlSqlParametersVerifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    protected void init(DBObjectProvider prov, DeclarativePlSql plsql, Verifier ver) {
        super.init(prov, ver);
        Collection dataTypes = prov.getDescriptor().listPreferredDataTypeNames();
        if (this._mdlType.getSize() == 0) {
            for (String datatype : dataTypes) {
                this._mdlType.addElement(datatype);
            }
        }
        this._mdlParams.init(prov, plsql, plsql instanceof Function, this._defSchema);
    }

    protected void commit(DeclarativePlSql plsql, PlSqlParametersVerifier verifier) throws TraversalException {
        int currRow = this.tblParams.getSelectedRow();
        if (this.tblParams.isEditing() && currRow != -1) {
            int currCol = this.tblParams.getSelectedColumn();
            int tmpCol = currCol == 2 ? 4 : 2;
            this.tblParams.editCellAt(currRow, tmpCol);
            this.tblParams.editCellAt(currRow, currCol);
        }
        this._mdlParams.commit(plsql, verifier);
    }

    private void jbInit() throws Exception {
        TableColumn colName = new TableColumn(0);
        colName.setHeaderValue(UIArb.getString(1003));
        colName.setCellRenderer(this._renderer);
        this._mdlCols.addColumn(colName);
        TableColumn colType = new TableColumn(1);
        colType.setHeaderValue(UIArb.getString(1004));
        JComboBox cmbType = new JComboBox(this._mdlType);
        cmbType.setName("PlSqlParametersPanel.cmbType");
        cmbType.setEditable(true);
        colType.setCellEditor(new DefaultCellEditor(cmbType));
        this._mdlCols.addColumn(colType);
        for (PlSqlParameter.Mode mode : PlSqlParameter.Mode.values()) {
            this._mdlMode.addElement((Object)mode);
        }
        this._mdlMode.addElement((Object)"");
        TableColumn colMode = new TableColumn(2);
        colMode.setHeaderValue(UIArb.getString(1005));
        JComboBox cmbMode = new JComboBox(this._mdlMode);
        cmbMode.setName("PlSqlParametersPanel.cmbMode");
        colMode.setCellEditor(new DefaultCellEditor(cmbMode));
        this._mdlCols.addColumn(colMode);
        TableColumn colDefault = new TableColumn(3);
        colDefault.setHeaderValue(UIArb.getString(1006));
        this._mdlCols.addColumn(colDefault);
        this.tblParams.setModel(this._mdlParams);
        this.tblParams.setColumnModel(this._mdlCols);
        this.tblParams.getSelectionModel().addListSelectionListener(this._listener);
        this.setLayout(new BorderLayout());
        Dimension size = new Dimension(28, 25);
        this.btnUp.setPreferredSize(size);
        this.btnUp.setIcon(OracleIcons.getIcon((String)"previous.png"));
        DBObjectRenderer.setToolTipText(this.btnUp, UIArb.getString(579));
        this.btnUp.setActionCommand(UP_CMD);
        this.btnUp.addActionListener(this._listener);
        this.btnUp.setEnabled(false);
        this.btnDown.setPreferredSize(size);
        this.btnDown.setIcon(OracleIcons.getIcon((String)"next.png"));
        DBObjectRenderer.setToolTipText(this.btnDown, UIArb.getString(580));
        this.btnDown.setActionCommand(DOWN_CMD);
        this.btnDown.addActionListener(this._listener);
        this.btnDown.setEnabled(false);
        this.btnAdd.setPreferredSize(size);
        this.btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        DBObjectRenderer.setToolTipText(this.btnAdd, UIArb.getString(577));
        this.btnAdd.setActionCommand(ADD_CMD);
        this.btnAdd.addActionListener(this._listener);
        this.btnRemove.setPreferredSize(size);
        this.btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        DBObjectRenderer.setToolTipText(this.btnRemove, UIArb.getString(578));
        this.btnRemove.setActionCommand(REMOVE_CMD);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(this._listener);
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        pnlButtons.add((Component)this.btnAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.tblParams.setSelectionMode(0);
        this.scrParams.getViewport().add((Component)this.tblParams, null);
        this.setLayout(new BorderLayout(5, 5));
        this.add(pnlButtons, "East");
        this.add(this.scrParams, "Center");
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        private L() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = PlSqlParametersPanel.this.tblParams.getSelectedRow();
            this.updateButtons(row);
        }

        private void updateButtons(int row) {
            PlSqlParametersPanel.this.btnRemove.setEnabled(PlSqlParametersPanel.this._mdlParams.canRemoveRow(row));
            PlSqlParametersPanel.this.btnUp.setEnabled(PlSqlParametersPanel.this._mdlParams.canMoveRowUp(row));
            PlSqlParametersPanel.this.btnDown.setEnabled(PlSqlParametersPanel.this._mdlParams.canMoveRowDown(row));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = PlSqlParametersPanel.this.tblParams.getSelectedRow();
            String cmd = e.getActionCommand();
            if (PlSqlParametersPanel.ADD_CMD.equals(cmd)) {
                if (sel >= 0) {
                    PlSqlParametersPanel.this._mdlParams.addParameter(sel++);
                } else {
                    PlSqlParametersPanel.this._mdlParams.addParameter();
                    sel = PlSqlParametersPanel.this._mdlParams.getRowCount() - 1;
                }
            } else if (PlSqlParametersPanel.REMOVE_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.removeParameter(sel);
                if (sel >= PlSqlParametersPanel.this._mdlParams.getRowCount()) {
                    sel = PlSqlParametersPanel.this._mdlParams.getRowCount() - 1;
                }
            } else if (PlSqlParametersPanel.UP_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.moveUp(sel--);
            } else if (PlSqlParametersPanel.DOWN_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.moveDown(sel++);
            }
            if (sel > -1) {
                PlSqlParametersPanel.this.tblParams.setRowSelectionInterval(sel, sel);
            }
            if (PlSqlParametersPanel.REMOVE_CMD.equals(cmd)) {
                if (sel > -1) {
                    PlSqlParametersPanel.this.btnRemove.requestFocus();
                } else {
                    PlSqlParametersPanel.this.btnAdd.requestFocus();
                }
            }
        }
    }
}

