/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import oracle.ide.db.UIArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;

public class PlSqlCompilerOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox m_chkDebug = new JCheckBox();
    private ComboBoxModel m_allModel = new ValueModel();
    private ComboBoxModel m_infoModel = new ValueModel();
    private ComboBoxModel m_sevModel = new ValueModel();
    private ComboBoxModel m_perfModel = new ValueModel();
    private JComboBox m_allCombo = new JComboBox();
    private JComboBox m_infoCombo = new JComboBox();
    private JComboBox m_sevCombo = new JComboBox();
    private JComboBox m_perfCombo = new JComboBox();
    private ListCellRenderer m_valRenderer = new ValueRenderer();

    public PlSqlCompilerOptionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        PlSqlCompilerOptions opts = PlSqlCompilerOptionsPanel.findCompilerOptions(dataContext);
        this.m_chkDebug.setSelected(opts.isGeneratePlSqlDebugInfo());
        this.m_allModel.setSelectedItem(opts.getWarningValue(PlSqlCompilerOptions.WarningCategory.ALL));
        this.m_infoModel.setSelectedItem(opts.getWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL));
        this.m_sevModel.setSelectedItem(opts.getWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE));
        this.m_perfModel.setSelectedItem(opts.getWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE));
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        PlSqlCompilerOptions opts = PlSqlCompilerOptionsPanel.findCompilerOptions(dataContext);
        opts.setGeneratePlSqlDebugInfo(this.m_chkDebug.isSelected());
        opts.setWarningValue(PlSqlCompilerOptions.WarningCategory.ALL, (PlSqlCompilerOptions.WarningValue)this.m_allModel.getSelectedItem());
        opts.setWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL, (PlSqlCompilerOptions.WarningValue)this.m_infoModel.getSelectedItem());
        opts.setWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE, (PlSqlCompilerOptions.WarningValue)this.m_sevModel.getSelectedItem());
        opts.setWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE, (PlSqlCompilerOptions.WarningValue)this.m_perfModel.getSelectedItem());
    }

    private static PlSqlCompilerOptions findCompilerOptions(TraversableContext tc) {
        return GlobalSettings.createGlobalSettings((PropertyStorage)tc.getPropertyStorage()).getPlSqlCompilerOptions();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel m_sevLabel = new JLabel();
        JLabel m_perfLabel = new JLabel();
        JLabel m_infoLabel = new JLabel();
        JLabel m_allLabel = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_chkDebug, (String)UIArb.getString(961));
        ResourceUtils.resLabel((JLabel)m_allLabel, (Component)this.m_allCombo, (String)UIArb.getString(957));
        ResourceUtils.resLabel((JLabel)m_infoLabel, (Component)this.m_infoCombo, (String)UIArb.getString(958));
        ResourceUtils.resLabel((JLabel)m_sevLabel, (Component)this.m_sevCombo, (String)UIArb.getString(959));
        ResourceUtils.resLabel((JLabel)m_perfLabel, (Component)this.m_perfCombo, (String)UIArb.getString(960));
        m_infoLabel.setText(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL.name());
        m_sevLabel.setText(PlSqlCompilerOptions.WarningCategory.SEVERE.name());
        m_perfLabel.setText(PlSqlCompilerOptions.WarningCategory.PERFORMANCE.name());
        this.m_allCombo.setModel(this.m_allModel);
        this.m_allCombo.setRenderer(this.m_valRenderer);
        this.m_infoCombo.setModel(this.m_infoModel);
        this.m_infoCombo.setRenderer(this.m_valRenderer);
        this.m_sevCombo.setModel(this.m_sevModel);
        this.m_sevCombo.setRenderer(this.m_valRenderer);
        this.m_perfCombo.setModel(this.m_perfModel);
        this.m_perfCombo.setRenderer(this.m_valRenderer);
        int y = 0;
        this.add(this.m_chkDebug, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 15, 0), 0, 0));
        this.add(m_allLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_allCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(m_infoLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_infoCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(m_sevLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_sevCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(m_perfLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_perfCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private static class ValueRenderer
    extends DefaultListCellRenderer {
        private ValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                value = " ";
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class ValueModel
    implements ComboBoxModel {
        private PlSqlCompilerOptions.WarningValue m_selObj;

        private ValueModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.m_selObj = (PlSqlCompilerOptions.WarningValue)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_selObj;
        }

        @Override
        public int getSize() {
            return PlSqlCompilerOptions.WarningValue.values().length + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index == 0 ? null : PlSqlCompilerOptions.WarningValue.values()[index - 1];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

