/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleStorageProperties;

public class MViewRightPanel
extends JPanel
implements ActionListener {
    private final String[] _buildTypeStrings = new String[]{UIArb.getString(821), UIArb.getString(822)};
    private MViewInfoVerifier m_verifier = null;
    private JCheckBox _useindexCheckBox = new JCheckBox();
    private JButton _indexStorageButton = new JButton();
    private JButton _storageButton = new JButton();
    private JCheckBox _compressCheckBox = new JCheckBox();
    private JCheckBox _parallelCheckBox = new JCheckBox();
    private JTextField _parallelValue = new JTextField();
    private JPanel northPane = new JPanel();
    private JPanel centerPane = new JPanel();
    private JCheckBox _enableCacheCheckBox = new JCheckBox();
    private JLabel _buildTypeLabel = new JLabel();
    private JComboBox _buildTypeComboBox = new JComboBox<String>(this._buildTypeStrings);
    private JCheckBox _queryRewriteCheck = new JCheckBox();
    private JCheckBox _prebuiltCheckBox = new JCheckBox();
    private ButtonGroup bgPrebuilt = new ButtonGroup();
    private JRadioButton _reducedPrecisionRadio = new JRadioButton();
    private JRadioButton _noReducedRadio = new JRadioButton();
    private DBObjectProvider m_prov;
    private MaterializedView m_matView;
    private StorageInfoVerifier m_siVerifier;
    private boolean m_editting;
    private DBUIResourceHelper _resHelper = new DBUIResourceHelper("MViewRightPanel");

    public MViewRightPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getParallelCheck() {
        return this._parallelCheckBox.isSelected();
    }

    public void setParallelCheck(boolean b) {
        this._parallelCheckBox.setSelected(b);
    }

    public String getParallelValue() {
        return this._parallelValue.getText();
    }

    public void setParallelValue(String s) {
        this._parallelValue.setText(s);
    }

    public boolean getEnableCache() {
        return this._enableCacheCheckBox.isSelected();
    }

    public void setEnableCache(boolean b) {
        this._enableCacheCheckBox.setSelected(b);
    }

    public boolean getEnableQueryRewrite() {
        return this._queryRewriteCheck.isSelected();
    }

    public void setEnableQueryRewrite(boolean b) {
        this._queryRewriteCheck.setSelected(b);
    }

    public boolean getUseIndex() {
        return this._useindexCheckBox.isSelected();
    }

    public void setUseIndex(boolean b) {
        this._useindexCheckBox.setSelected(b);
    }

    public String getBuildType() {
        return (String)this._buildTypeComboBox.getSelectedItem();
    }

    public void setBuildType(String s) {
        this._buildTypeComboBox.setSelectedItem(s);
    }

    @Deprecated
    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, StorageInfoVerifier siVerifier, Schema[] schemas, String[] tablespaces, boolean editting, boolean isEditable) {
        this.init(prov, mview, verifier, siVerifier, schemas, editting, isEditable);
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, StorageInfoVerifier siVerifier, Schema[] schemas, boolean editting, boolean isEditable) {
        this.m_verifier = verifier;
        this.m_prov = prov;
        this.m_matView = mview;
        this.m_siVerifier = siVerifier;
        this.m_editting = editting;
        this._compressCheckBox.setSelected(mview.isCompression());
        int parallel = mview.getParallel();
        if (parallel == 0) {
            this._parallelValue.setText(null);
            this._parallelCheckBox.setSelected(true);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
        } else if (parallel < 2) {
            this._parallelValue.setText(null);
            this._parallelCheckBox.setSelected(false);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(false);
        } else {
            this._parallelValue.setText(Integer.toString(parallel));
            this._parallelCheckBox.setSelected(true);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
        }
        this._enableCacheCheckBox.setSelected(mview.isCache());
        this._enableCacheCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOEnableCache());
        this._queryRewriteCheck.setSelected(mview.isRewrite());
        this._queryRewriteCheck.setEnabled(this.m_verifier == null || this.m_verifier.canMVOQueryRewrite());
        if (mview.getBuildType() == MaterializedView.BuildType.IMMEDIATE) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(821));
        } else if (mview.getBuildType() == MaterializedView.BuildType.DEFERRED) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(822));
        }
        this._buildTypeComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._buildTypeLabel.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        if (mview.getOnPrebuilt() != MaterializedView.PrebuiltType.NONE) {
            this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._prebuiltCheckBox.setSelected(true);
            this._reducedPrecisionRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._noReducedRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            if (MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION == mview.getOnPrebuilt()) {
                this._noReducedRadio.setSelected(true);
            } else {
                this._reducedPrecisionRadio.setSelected(true);
            }
        } else {
            this._prebuiltCheckBox.setSelected(false);
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
        this._useindexCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
        this._useindexCheckBox.setSelected(!mview.isUseNoIndex());
        this._indexStorageButton.setEnabled(!mview.isUseNoIndex());
        if (!isEditable) {
            this.disableAll();
        }
    }

    public void commit(MaterializedView mview) throws TraversalException {
        mview.setCompression(this._compressCheckBox.isSelected());
        int parallelValue = 1;
        if (this._parallelCheckBox.isSelected()) {
            String textIn = this._parallelValue.getText();
            try {
                parallelValue = textIn == null || textIn.equals("") ? 0 : Integer.parseInt(textIn);
            }
            catch (NumberFormatException e) {
                parallelValue = 0;
            }
        }
        mview.setParallel(parallelValue);
        mview.setCache(this._enableCacheCheckBox.isSelected());
        mview.setRewrite(this._queryRewriteCheck.isSelected());
        mview.setUseNoIndex(true);
        if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(821))) {
            mview.setBuildType(MaterializedView.BuildType.IMMEDIATE);
        } else if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(822))) {
            mview.setBuildType(MaterializedView.BuildType.DEFERRED);
        }
        if (this._useindexCheckBox.isSelected()) {
            mview.setUseNoIndex(false);
        } else {
            mview.setUseNoIndex(true);
            this.m_matView.getProperties().remove("MatViewIndexStorageProperties");
        }
        if (this._prebuiltCheckBox.isSelected()) {
            mview.setOnPrebuilt(this._reducedPrecisionRadio.isSelected() ? MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION : MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION);
        } else {
            mview.setOnPrebuilt(MaterializedView.PrebuiltType.NONE);
        }
    }

    private void jbInit() throws Exception {
        this._resHelper.resButton(this._enableCacheCheckBox, UIArb.getString(842), "_enableCacheCheckBox");
        this._enableCacheCheckBox.setToolTipText(UIArb.getString(843));
        this._enableCacheCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewRightPanel.this._cacheCheck_actionPerformed(e);
            }
        });
        this._resHelper.resLabel(this._buildTypeLabel, this._buildTypeComboBox, UIArb.getString(844), "_buildTypeComboBox");
        this._resHelper.resButton(this._useindexCheckBox, UIArb.getString(854), "_useindexCheckBox");
        this._useindexCheckBox.setEnabled(true);
        this._useindexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewRightPanel.this._useindexCheckBox_actionPerformed(e);
            }
        });
        this._resHelper.resButton(this._compressCheckBox, UIArb.getString(845), "_compressCheckBox");
        this._resHelper.resButton(this._storageButton, UIArb.getString(504), "_storageButton");
        this._storageButton.addActionListener(this);
        this._resHelper.resButton(this._indexStorageButton, UIArb.getString(1008), "_indexStorageButton");
        this._indexStorageButton.addActionListener(this);
        this._resHelper.resButton(this._parallelCheckBox, UIArb.getString(846), "_parallelCheckBox");
        this._parallelCheckBox.setToolTipText(UIArb.getString(847));
        this._parallelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewRightPanel.this._parallelCheckBox_actionPerformed(e);
            }
        });
        this._parallelValue.setName("MViewRightPanel._parallelValue");
        this._parallelValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewRightPanel.this._parallelValue_actionPerformed(e);
            }
        });
        this._parallelValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    MViewRightPanel.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        this._parallelValue.setEnabled(this._parallelCheckBox.isEnabled());
        this._buildTypeComboBox.setSelectedIndex(0);
        this._resHelper.resButton(this._queryRewriteCheck, UIArb.getString(848), "_queryRewriteCheck");
        this._resHelper.resButton(this._prebuiltCheckBox, UIArb.getString(849), "_prebuiltCheckBox");
        this._prebuiltCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewRightPanel.this._prebuiltCheckBox_actionPerformed(e);
            }
        });
        this._resHelper.resButton(this._reducedPrecisionRadio, UIArb.getString(850), "_reducedPrecisionRadio");
        this._resHelper.resButton(this._noReducedRadio, UIArb.getString(851), "_noReducedRadio");
        this.bgPrebuilt.add(this._noReducedRadio);
        this.bgPrebuilt.add(this._reducedPrecisionRadio);
        this._noReducedRadio.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
        DBUILayoutHelper uiHelper = new DBUILayoutHelper(this);
        DBUILayoutHelper mvOptions = uiHelper.newTitledBorderHelper(UIArb.getString(841), 1, 1, true, true);
        mvOptions.add(this._compressCheckBox);
        mvOptions.nextRow();
        DBUILayoutHelper parallel = mvOptions.newChildHelper(1, 1, true, false);
        parallel.add(this._parallelCheckBox);
        parallel.add(this._parallelValue);
        mvOptions.nextRow();
        mvOptions.add(this._enableCacheCheckBox);
        mvOptions.nextRow();
        mvOptions.add(this._queryRewriteCheck);
        mvOptions.nextRow();
        mvOptions.add(this._prebuiltCheckBox);
        mvOptions.nextRow();
        mvOptions.add(this._reducedPrecisionRadio);
        mvOptions.indent(this._reducedPrecisionRadio);
        mvOptions.nextRow();
        mvOptions.add(this._noReducedRadio);
        mvOptions.indent(this._noReducedRadio);
        mvOptions.nextRow();
        DBUILayoutHelper mvOptionsBuildType = mvOptions.newChildHelper(1, 1, true, false);
        mvOptionsBuildType.add(this._buildTypeLabel);
        mvOptionsBuildType.add(this._buildTypeComboBox);
        mvOptions.nextRowWithGap();
        mvOptions.add(this._storageButton);
        mvOptions.nextRowWithGap();
        mvOptions.add(this._useindexCheckBox);
        mvOptions.nextRow();
        mvOptions.add(this._indexStorageButton);
        mvOptions.pushUp();
        uiHelper.layout();
    }

    private void _useindexCheckBox_actionPerformed(ActionEvent e) {
        this._indexStorageButton.setEnabled(this._useindexCheckBox.isSelected());
    }

    private void _parallelValue_actionPerformed(ActionEvent e) {
    }

    private void _parallelCheckBox_actionPerformed(ActionEvent e) {
        if (this._parallelCheckBox.isSelected()) {
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            if (this._parallelCheckBox.isSelected()) {
                this._parallelValue.setEditable(true);
            } else {
                this._parallelValue.setEditable(false);
            }
        } else {
            this._parallelValue.setEnabled(false);
            this._parallelValue.setEditable(false);
        }
    }

    private void _valueParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(true);
    }

    private void _defaultParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(false);
    }

    private void _cacheCheck_actionPerformed(ActionEvent e) {
    }

    private void jButton2_actionPerformed(ActionEvent e) {
    }

    private void jComboBox1_actionPerformed(ActionEvent e) {
    }

    private void _extentTextField_actionPerformed(ActionEvent e) {
    }

    private void _prebuiltCheckBox_actionPerformed(ActionEvent e) {
        if (this._prebuiltCheckBox.isSelected()) {
            this._reducedPrecisionRadio.setEnabled(true);
            this._noReducedRadio.setEnabled(true);
        } else {
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
    }

    private void disableAll() {
        this._useindexCheckBox.setEnabled(false);
        this._storageButton.setEnabled(false);
        this._indexStorageButton.setEnabled(false);
        this._parallelCheckBox.setEnabled(false);
        this._parallelValue.setEnabled(false);
        this._enableCacheCheckBox.setEnabled(false);
        this._compressCheckBox.setEnabled(false);
        this._buildTypeLabel.setEnabled(false);
        this._buildTypeComboBox.setEnabled(false);
        this._queryRewriteCheck.setEnabled(false);
        this._prebuiltCheckBox.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
        this._noReducedRadio.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._storageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_matView.getProperty("OracleStorageProperties");
            if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this)) != null) {
                this.m_matView.setProperty("OracleStorageProperties", (Object)osp);
            } else {
                this.m_matView.getProperties().remove("OracleStorageProperties");
            }
        } else if (source == this._indexStorageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_matView.getProperty("MatViewIndexStorageProperties");
            if (this.m_editting && this.m_prov instanceof Database) {
                StorageInfoPanel.view(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW_INDEX, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this);
            } else if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW_INDEX, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this)) != null) {
                this.m_matView.setProperty("MatViewIndexStorageProperties", (Object)osp);
            } else {
                this.m_matView.getProperties().remove("MatViewIndexStorageProperties");
            }
        }
    }
}

