/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.icons.OracleIcons;

public class MViewLogHeader
extends DBTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
    private DBObjectChooser m_cmbOwner = new DBObjectChooser("SCHEMA");
    private SchemaObjectComboBox m_cmbMasterTable = new SchemaObjectComboBox();
    private JLabel m_templateHint = new JLabel();
    private boolean m_create = true;
    private boolean m_firstInit = true;
    private boolean m_listening;
    private SchemaObject m_originalObject;
    private MaterializedViewLog m_schemaObject = null;
    private DBObjectProvider m_pro;
    private SchemaObjectInfoVerifier m_verifier = null;
    private HashMap m_tableNameAndIdHash = new HashMap();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("MViewLogHeader");

    public MViewLogHeader() {
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel pnlInfo) {
        pnlInfo.setLayout(new GridBagLayout());
        JLabel lblOwner = new JLabel();
        this.m_cmbOwner.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (MViewLogHeader.this.m_listening) {
                    try {
                        MViewLogHeader.this.commit();
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                    MViewLogHeader.this.m_listening = true;
                }
            }
        });
        this.m_resHelper.resLabel(lblOwner, this.m_cmbOwner, UIArb.getString(108), "_cmbOwner");
        pnlInfo.add((Component)lblOwner, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblName = new JLabel();
        this.m_cmbMasterTable.addActionListener(this);
        this.m_resHelper.resLabel(lblName, this.m_cmbMasterTable, UIArb.getString(869), "_cmbMasterTable");
        pnlInfo.add((Component)lblName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbMasterTable, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        pnlInfo.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlInfo.add((Component)this.m_templateHint, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private Schema[] validateSchemaPermissions(Schema[] schemas) {
        if (this.m_pro instanceof Database) {
            ArrayList<Schema> retval = new ArrayList<Schema>();
            String type = this.m_schemaObject.getType();
            for (int i = 0; i < schemas.length; ++i) {
                if (!this.m_pro.hasPriviledge(type, schemas[i], this.isEditing() ? "MODIFY" : "CREATE")) continue;
                retval.add(schemas[i]);
            }
            return retval.toArray(new Schema[retval.size()]);
        }
        return schemas;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this.m_verifier;
    }

    protected DBObjectChooser getSchemaPicker() {
        return this.m_cmbOwner;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected SchemaObject getSchemaObject() {
        return this.m_schemaObject;
    }

    protected boolean isEditing() {
        return this.m_originalObject != null;
    }

    protected void init(SchemaObject obj, SchemaObject origObj, SchemaObjectInfoVerifier verifier, DBObjectProvider pro) {
        String templateName;
        this.m_originalObject = origObj;
        this.m_pro = pro;
        this.m_schemaObject = (MaterializedViewLog)obj;
        this.m_verifier = verifier;
        this.m_create = origObj == null;
        this.m_cmbOwner.setProvider(this.m_pro);
        this.m_cmbOwner.setDBObject((DBObject)obj.getSchema());
        this.m_cmbOwner.setFilter(new DBObjectFilter(){

            public boolean accept(DBObject dbObj) {
                boolean doAccept = false;
                if (MViewLogHeader.this.m_pro instanceof Database) {
                    String type = MViewLogHeader.this.m_schemaObject.getType();
                    if (MViewLogHeader.this.m_pro.hasPriviledge(type, (Schema)dbObj, MViewLogHeader.this.isEditing() ? "MODIFY" : "CREATE")) {
                        doAccept = true;
                    }
                } else {
                    doAccept = true;
                }
                return doAccept;
            }
        });
        this.setupMasterTable();
        this.m_cmbOwner.setEditable(false);
        this.m_cmbMasterTable.setEditable(false);
        if (this.m_cmbMasterTable.getModel().getSize() != 0) {
            try {
                this.commit();
            }
            catch (TraversalException e) {
                // empty catch block
            }
        }
        if ((templateName = TemplateExpander.getTemplateObjectName((DBObject)obj)) != null) {
            this.m_templateHint.setText(templateName);
            this.m_templateHint.setIcon(OracleIcons.getIcon((String)"copy.png"));
            this.m_templateHint.setToolTipText(UIArb.format(985, templateName));
        } else {
            this.m_templateHint.setVisible(false);
        }
        this.m_listening = true;
        this.m_firstInit = false;
    }

    public void commit() throws TraversalException {
        String name;
        this.m_listening = false;
        Schema oldSchema = this.m_schemaObject.getSchema();
        Schema schema = (Schema)this.m_cmbOwner.getDBObject();
        String oldName = this.m_schemaObject.getName();
        SchemaObjectDescriptor sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
        String string = name = sod == null ? null : sod.getName();
        if (oldSchema != schema) {
            HashMap<String, PropertyChangeEvent> props = new HashMap<String, PropertyChangeEvent>(2);
            this.m_schemaObject.setSchema(schema);
            PropertyChangeEvent spce = new PropertyChangeEvent(this.m_schemaObject, "schema", oldSchema, schema);
            props.put(spce.getPropertyName(), spce);
            this.setupMasterTable();
            sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
            if (sod != null) {
                name = sod.getName();
                this.m_schemaObject.setName(name);
                this.m_schemaObject.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
                name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
                PropertyChangeEvent npce = new PropertyChangeEvent(this.m_schemaObject, "name", oldName, name);
                props.put(npce.getPropertyName(), npce);
            }
            DBObjectChange.firePropertiesChanged((SystemObject)this.m_schemaObject, props);
        } else if (name != null && !name.equals(oldName)) {
            name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
            this.m_schemaObject.setName(name);
            this.m_schemaObject.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
            DBObjectChange.firePropertyChanged((SystemObject)this.m_schemaObject, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(this.m_schemaObject, "name", oldName, name)});
        }
    }

    public void onEntry(TraversableContext data) {
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        SchemaObject obj = (SchemaObject)data.get("NewObject");
        SchemaObject origObj = (SchemaObject)data.get("OriginalObject");
        if (this.m_firstInit) {
            this.init(obj, origObj, null, pro);
        }
        this.m_listening = true;
        boolean isEditable = (Boolean)data.find("DBObjectIsEditable");
        if (!isEditable) {
            this.m_cmbOwner.setEnabled(false);
            this.m_cmbMasterTable.setEnabled(false);
        }
    }

    public void onExit(TraversableContext data) throws TraversalException {
        this.commit();
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_cmbMasterTable;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            try {
                this.commit();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            this.m_listening = true;
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        this.m_list.add(list);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        return this.m_list.remove(list);
    }

    protected final void changePanels(String key, Navigable[] navs) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener list : this.m_list) {
            list.panelSetChange(key, navs);
        }
    }

    private void setupMasterTable() {
        this.m_cmbMasterTable.removeAllItems();
        this.m_cmbMasterTable.setShowIcon(true);
        this.m_tableNameAndIdHash.clear();
        if (this.m_create) {
            this.m_schemaObject.setName(null);
            this.m_schemaObject.setMasterTableID(null);
            if (this.m_pro instanceof OracleDatabaseImpl) {
                final QueryWrapper wrap = new QueryWrapper((Database)this.m_pro, MaterializedViewLogBuilder.getCandidateTablesQuery(), new Object[]{this.m_schemaObject.getSchema()});
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                DBObjectID tableID = ((OracleDatabaseImpl)MViewLogHeader.this.m_pro).createID(MViewLogHeader.this.m_schemaObject.getSchema(), rs.getString(1), rs.getString(2), (Object)rs.getString(3));
                                SchemaObjectDescriptor sod = new SchemaObjectDescriptor(rs.getString(1), rs.getString(2), MViewLogHeader.this.m_schemaObject.getSchema().getName());
                                MViewLogHeader.this.m_cmbMasterTable.addItem(sod);
                                MViewLogHeader.this.m_tableNameAndIdHash.put(rs.getString(1), tableID);
                                if (MViewLogHeader.this.m_schemaObject.getMasterTableID() != null) continue;
                                MViewLogHeader.this.m_schemaObject.setMasterTableID(tableID);
                            }
                        }
                        catch (SQLException ex) {
                            wrap.throwDBException(ex);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    boolean debug = false;
                }
            } else {
                int tabLoop;
                SchemaObject[] tables = null;
                String[] tabTypes = new String[]{"TABLE", "MATERIALIZED VIEW"};
                try {
                    tables = this.m_pro.listObjects(tabTypes, this.m_schemaObject.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                SchemaObject[] mvls = null;
                String[] mvlType = new String[]{"MATERIALIZED VIEW LOG"};
                try {
                    mvls = this.m_pro.listObjects(mvlType, this.m_schemaObject.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                block8: for (tabLoop = 0; tabLoop < tables.length; ++tabLoop) {
                    for (int mvlLoop = 0; mvlLoop < mvls.length; ++mvlLoop) {
                        if (!tables[tabLoop].getID().equals(((MaterializedViewLog)mvls[mvlLoop]).getMasterTableID())) continue;
                        tables[tabLoop] = null;
                        continue block8;
                    }
                }
                for (tabLoop = 0; tabLoop < tables.length; ++tabLoop) {
                    Object type;
                    Table tab;
                    if (tables[tabLoop] == null || (tab = (Table)tables[tabLoop]) == null || (type = tab.getProperty("TableType")) == Table.TableType.TRANSACTION_TEMP || type == Table.TableType.SESSION_TEMP || type == Table.TableType.EXTERNAL) continue;
                    SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), this.m_schemaObject.getSchema().getName());
                    this.m_cmbMasterTable.addItem(sod);
                    this.m_tableNameAndIdHash.put(tab.getName(), tab.getID());
                    if (this.m_schemaObject.getMasterTableID() != null) continue;
                    this.m_schemaObject.setMasterTableID(tab.getID());
                }
            }
            if (this.m_cmbMasterTable.getSelectedItem() != null) {
                this.m_schemaObject.setMasterTableID(null);
            }
        } else {
            DBObject tab = null;
            try {
                tab = this.m_schemaObject.getMasterTableID().resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (tab != null) {
                SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), this.m_schemaObject.getSchema().getName());
                this.m_cmbMasterTable.addItem(sod);
            }
        }
    }
}

