/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;

public class MViewLeftPanel
extends JPanel
implements ListCellRenderer {
    private final String[] _withStrings = new String[]{"", UIArb.getString(809), UIArb.getString(810)};
    private MViewInfoVerifier m_verifier = null;
    private JLabel _refreshPeriodLabel = new JLabel();
    private JComboBox _refreshPeriodComboBox = new JComboBox<MaterializedView.RefreshMode>(MaterializedView.RefreshMode.values());
    private JLabel _refreshMethodLabel = new JLabel();
    private JComboBox _refreshMethodComboBox = new JComboBox<MaterializedView.RefreshMethod>(MaterializedView.RefreshMethod.values());
    private JLabel _refreshWithLabel = new JLabel();
    private JComboBox _refreshWithComboBox = new JComboBox<String>(this._withStrings);
    private DateFormat _oracleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private DateEditor _dateChooser = new DateEditor();
    private DateEditor _nextDateChooser = new DateEditor();
    private JLabel _refreshAtLabel = new JLabel();
    private JLabel _nextDateLabel = new JLabel();
    private JCheckBox _rollbackCheckBox = new JCheckBox();
    private ButtonGroup defaultUse = new ButtonGroup();
    private JRadioButton _defaultRollbackRadio = new JRadioButton();
    private JRadioButton _useSpecificRadioButton = new JRadioButton();
    private JTextField _rollbackSegmentTextField = new JTextField();
    private ButtonGroup localMaster = new ButtonGroup();
    private JRadioButton _localRollbackRadio = new JRadioButton();
    private JRadioButton _masterRollbackRadio = new JRadioButton();
    private JCheckBox _refreshUseConstraintCheckBox = new JCheckBox();
    private JRadioButton _enforcedRadioButton = new JRadioButton();
    private JRadioButton _trustedRadioButton = new JRadioButton();
    private ButtonGroup _conButtonGroup = new ButtonGroup();
    private DBUIResourceHelper _resHelper = new DBUIResourceHelper("MViewLeftPanel");
    private DefaultListCellRenderer m_rend;

    public MViewLeftPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, Schema[] schemas, boolean isEditable) {
        this.m_verifier = verifier;
        this._refreshMethodComboBox.setSelectedItem(mview.getRefreshMethod());
        if (mview.getRefreshMethod() != MaterializedView.RefreshMethod.NA) {
            this._refreshMethodComboBox.removeItem(MaterializedView.RefreshMethod.NA);
        }
        this._refreshPeriodComboBox.setSelectedItem(mview.getRefreshMode());
        MaterializedView.RefreshWith refreshWith = mview.getKeyType();
        if (this.m_verifier == null) {
            if (refreshWith == MaterializedView.RefreshWith.ROWID) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(810));
            } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(809));
            } else {
                this._refreshWithComboBox.setSelectedItem("");
            }
        } else {
            this.m_verifier.setupRefreshCombo(this._refreshWithComboBox, refreshWith);
        }
        this._refreshPeriodComboBox.setSelectedItem(mview.getRefreshMode());
        if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.NONE) {
            this._rollbackCheckBox.setSelected(false);
            this._masterRollbackRadio.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
            this._rollbackCheckBox.setEnabled(verifier == null || verifier.canRefreshUseRollback());
        } else {
            this._rollbackCheckBox.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._rollbackCheckBox.setSelected(true);
            this._localRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._defaultRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._rollbackSegmentTextField.setEnabled(false);
            if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL) {
                this._localRollbackRadio.setSelected(true);
            } else {
                this._localRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.MASTER) {
                this._masterRollbackRadio.setSelected(true);
            } else {
                this._masterRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentName() == null || mview.getRollbackSegmentName().trim().equals("")) {
                this._defaultRollbackRadio.setSelected(true);
            } else {
                this._defaultRollbackRadio.setSelected(false);
                this._useSpecificRadioButton.setSelected(true);
                this._rollbackSegmentTextField.setEnabled(verifier == null || verifier.canRefreshUseRollback());
                this._rollbackSegmentTextField.setText(mview.getRollbackSegmentName());
            }
        }
        MaterializedView.UsingConstraints usingCons = mview.getUsingConstraints();
        this._refreshUseConstraintCheckBox.setSelected(usingCons != null);
        this._refreshUseConstraintCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshConstraints());
        this._enforcedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isEnabled() && this._refreshUseConstraintCheckBox.isSelected());
        this._trustedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isEnabled() && this._refreshUseConstraintCheckBox.isSelected());
        this._refreshWithLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshWithComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshMethodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshMethodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshPeriodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        this._refreshPeriodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        if (usingCons == MaterializedView.UsingConstraints.TRUSTED) {
            this._trustedRadioButton.setSelected(true);
        } else {
            this._enforcedRadioButton.setSelected(true);
        }
        if (mview.getLastRefreshDate() != null) {
            this._dateChooser.setDate(mview.getLastRefreshDate());
        }
        if (mview.getNextRefreshDate() != null) {
            this._nextDateChooser.setDate(mview.getNextRefreshDate());
            this._refreshPeriodComboBox.setSelectedIndex(3);
        }
        if (!isEditable) {
            this.disableAll();
        }
    }

    public void commit(MaterializedView mview) throws TraversalException {
        String keyMethod;
        mview.setRefreshMethod((MaterializedView.RefreshMethod)this._refreshMethodComboBox.getSelectedItem());
        MaterializedView.RefreshMode mode = (MaterializedView.RefreshMode)this._refreshPeriodComboBox.getSelectedItem();
        mview.setRefreshMode(mode);
        if (mode == MaterializedView.RefreshMode.SPECIFY) {
            mview.setLastRefreshDate(this.getStartDate());
            mview.setNextRefreshDate(this.getNextDate());
            long secInterval = (this.getNextDate().getTime() - this.getStartDate().getTime()) / 1000L;
            if (secInterval > 0L) {
                StringBuilder sb = new StringBuilder("SYSDATE ");
                if (secInterval / 86400L >= 1L) {
                    sb.append("+ ");
                    sb.append(Long.valueOf(secInterval / 86400L).toString());
                    secInterval %= 86400L;
                }
                if (secInterval > 0L) {
                    sb.append("+ (");
                    if (secInterval % 3600L == 0L) {
                        sb.append(Long.valueOf(secInterval / 3600L).toString()).append("/24)");
                    } else if (secInterval % 60L == 0L) {
                        sb.append(Long.valueOf(secInterval / 60L).toString()).append("/(24*60))");
                    } else {
                        sb.append(Long.valueOf(secInterval).toString()).append("/(24*60*60))");
                    }
                }
                mview.setInterval(sb.toString());
            } else {
                mview.setInterval(null);
            }
        }
        if ((keyMethod = this.getMethod()).equals(UIArb.getString(809))) {
            mview.setKeyType(MaterializedView.RefreshWith.PRIMARY_KEY);
        } else if (keyMethod.equals(UIArb.getString(810))) {
            mview.setKeyType(MaterializedView.RefreshWith.ROWID);
        } else {
            mview.setKeyType(MaterializedView.RefreshWith.UNSPECIFIED);
        }
        if (this._rollbackCheckBox.isSelected()) {
            if (this._localRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
            } else if (this._masterRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
            }
            if (this._defaultRollbackRadio.isSelected()) {
                mview.setRollbackSegmentName(null);
            } else if (this._useSpecificRadioButton.isSelected()) {
                mview.setRollbackSegmentName(this._rollbackSegmentTextField.getText());
            }
        } else {
            mview.setRollbackSegmentName(null);
            mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.NONE);
        }
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            if (this._enforcedRadioButton.isSelected()) {
                mview.setUsingConstraints(MaterializedView.UsingConstraints.ENFORCED);
            } else if (this._trustedRadioButton.isSelected()) {
                mview.setUsingConstraints(MaterializedView.UsingConstraints.TRUSTED);
            }
        } else {
            mview.setUsingConstraints(null);
        }
    }

    public String getMethod() {
        return (String)this._refreshWithComboBox.getSelectedItem();
    }

    public Date getStartDate() {
        return this._dateChooser.getDate();
    }

    public Date getNextDate() {
        return this._nextDateChooser.getDate();
    }

    private void jbInit() throws Exception {
        this.localMaster.add(this._localRollbackRadio);
        this.localMaster.add(this._masterRollbackRadio);
        this.defaultUse.add(this._defaultRollbackRadio);
        this.defaultUse.add(this._useSpecificRadioButton);
        this._resHelper.resLabel(this._refreshPeriodLabel, this._refreshPeriodComboBox, UIArb.getString(828), "_refreshPeriodComboBox");
        this._refreshPeriodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._refreshPeriodComboBox_actionPerformed(e);
            }
        });
        this._resHelper.resLabel(this._refreshMethodLabel, this._refreshMethodComboBox, UIArb.getString(829), "_refreshMethodComboBox");
        this._refreshMethodComboBox.setSelectedItem(MaterializedView.RefreshMethod.FAST);
        this._refreshMethodComboBox.removeItem(MaterializedView.RefreshMethod.NEVER);
        this._resHelper.resLabel(this._refreshWithLabel, this._refreshWithComboBox, UIArb.getString(830), "_refreshWithComboBox");
        this._refreshWithComboBox.setSelectedIndex(0);
        this._dateChooser.setToolTipText(UIArb.getString(823));
        this._dateChooser.setDateFormat(this._oracleDateFormat);
        this._dateChooser.setEnabled(false);
        this._dateChooser.setDate(new Date());
        this._resHelper.resLabel(this._refreshAtLabel, (Component)this._dateChooser, UIArb.getString(831), "_dateChooser");
        this._refreshAtLabel.setEnabled(false);
        this._nextDateChooser.setToolTipText(UIArb.getString(824));
        this._nextDateChooser.setDateFormat(this._oracleDateFormat);
        this._nextDateChooser.setEnabled(false);
        this._nextDateChooser.setDate(new Date());
        this._resHelper.resLabel(this._nextDateLabel, (Component)this._nextDateChooser, UIArb.getString(832), "_nextDateChooser");
        this._nextDateLabel.setEnabled(false);
        this._resHelper.resButton(this._rollbackCheckBox, UIArb.getString(833), "_rollbackCheckBox");
        this._rollbackCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._rollbackCheckBox_actionPerformed(e);
            }
        });
        this._resHelper.resButton(this._defaultRollbackRadio, UIArb.getString(834), "_defaultRollbackRadio");
        this._defaultRollbackRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._defaultRollbackRadio_actionPerformed(e);
            }
        });
        this._defaultRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._useSpecificRadioButton, UIArb.getString(835), "_useSpecificRadioButton");
        this._useSpecificRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._useSpecificRadioButton_actionPerformed(e);
            }
        });
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setName("MViewLeftPanel._rollbackSegmentTextField");
        this._rollbackSegmentTextField.setEnabled(false);
        this._resHelper.resButton(this._localRollbackRadio, UIArb.getString(836), "_localRollbackRadio");
        this._localRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._masterRollbackRadio, UIArb.getString(837), "_masterRollbackRadio");
        this._masterRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._refreshUseConstraintCheckBox, UIArb.getString(838), "_refreshUseConstraintCheckBox");
        this._refreshUseConstraintCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._useCheckContraints_actionPerformed(e);
            }
        });
        this._resHelper.resButton(this._enforcedRadioButton, UIArb.getString(839), "_enforcedRadioButton");
        this._resHelper.resButton(this._trustedRadioButton, UIArb.getString(840), "_trustedRadioButton");
        this._conButtonGroup.add(this._trustedRadioButton);
        this._conButtonGroup.add(this._enforcedRadioButton);
        this._trustedRadioButton.setEnabled(false);
        this._trustedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MViewLeftPanel.this._trustedRadioButton_actionPerformed(e);
            }
        });
        this._enforcedRadioButton.setEnabled(false);
        DBUILayoutHelper uiHelper = new DBUILayoutHelper(this);
        DBUILayoutHelper refreshOptions = uiHelper.newTitledBorderHelper(UIArb.getString(827), 1, 1, true, true);
        refreshOptions.add(this._refreshPeriodLabel);
        refreshOptions.add(this._refreshPeriodComboBox);
        refreshOptions.nextRow();
        refreshOptions.add(this._refreshMethodLabel);
        refreshOptions.add(this._refreshMethodComboBox);
        refreshOptions.nextRow();
        refreshOptions.add(this._refreshWithLabel);
        refreshOptions.add(this._refreshWithComboBox);
        refreshOptions.nextRow();
        refreshOptions.add(this._refreshAtLabel);
        refreshOptions.add((Component)this._dateChooser, 1, 1, true, false);
        refreshOptions.nextRow();
        refreshOptions.add(this._nextDateLabel);
        refreshOptions.add((Component)this._nextDateChooser, 1, 1, true, false);
        refreshOptions.nextRowWithGap();
        DBUILayoutHelper refreshOptionsBottom = refreshOptions.newChildHelper(2, 1, true, false);
        refreshOptionsBottom.add(this._rollbackCheckBox, 2, 1, true, false);
        refreshOptionsBottom.nextRow();
        refreshOptionsBottom.add(this._masterRollbackRadio);
        refreshOptionsBottom.indent(this._masterRollbackRadio);
        refreshOptionsBottom.add(this._localRollbackRadio);
        refreshOptionsBottom.nextRow();
        refreshOptionsBottom.add(this._defaultRollbackRadio);
        refreshOptionsBottom.indent(this._defaultRollbackRadio);
        DBUILayoutHelper useRBSHelper = refreshOptionsBottom.newChildHelper(1, 1, true, false);
        useRBSHelper.add(this._useSpecificRadioButton);
        useRBSHelper.add(this._rollbackSegmentTextField);
        refreshOptionsBottom.nextRowWithGap();
        refreshOptionsBottom.add(this._refreshUseConstraintCheckBox, 2, 1, true, false);
        refreshOptionsBottom.nextRow();
        refreshOptionsBottom.add(this._enforcedRadioButton);
        refreshOptionsBottom.indent(this._enforcedRadioButton);
        refreshOptionsBottom.add(this._trustedRadioButton);
        refreshOptions.pushUp();
        uiHelper.layout();
    }

    private void _rollbackCheckBox_actionPerformed(ActionEvent e) {
        if (this._rollbackCheckBox.isSelected()) {
            this._defaultRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._localRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            if (this._useSpecificRadioButton.isSelected()) {
                this._rollbackSegmentTextField.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            }
        } else {
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._masterRollbackRadio.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
        }
    }

    private void _useSpecificRadioButton_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(true);
    }

    private void _defaultRollbackRadio_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(false);
    }

    private void _useCheckContraints_actionPerformed(ActionEvent e) {
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            this._enforcedRadioButton.setEnabled(true);
            this._trustedRadioButton.setEnabled(true);
        } else {
            this._enforcedRadioButton.setEnabled(false);
            this._trustedRadioButton.setEnabled(false);
        }
    }

    private void _refreshPeriodComboBox_actionPerformed(ActionEvent e) {
        if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.NEVER) {
            this._dateChooser.setEnabled(false);
            this._nextDateChooser.setEnabled(false);
            this._rollbackCheckBox.setSelected(false);
            this._rollbackCheckBox_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._refreshUseConstraintCheckBox.setSelected(false);
            this._useCheckContraints_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._rollbackCheckBox.setEnabled(false);
            this._refreshMethodComboBox.setEnabled(false);
            this._refreshWithLabel.setEnabled(false);
            this._refreshWithComboBox.setEnabled(false);
            this._rollbackCheckBox.setEnabled(false);
            this._refreshUseConstraintCheckBox.setEnabled(false);
            this._refreshMethodLabel.setEnabled(false);
        } else {
            this._rollbackCheckBox.setEnabled(true);
            this._refreshMethodComboBox.setEnabled(true);
            this._refreshWithLabel.setEnabled(true);
            this._refreshWithComboBox.setEnabled(true);
            this._rollbackCheckBox.setEnabled(true);
            this._refreshUseConstraintCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshConstraints());
            this._refreshMethodLabel.setEnabled(true);
            if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.SPECIFY) {
                this._dateChooser.setEnabled(true);
                this._nextDateChooser.setEnabled(true);
                this._nextDateLabel.setEnabled(true);
                this._refreshAtLabel.setEnabled(true);
            } else {
                this._dateChooser.setEnabled(false);
                this._nextDateChooser.setEnabled(false);
                this._nextDateLabel.setEnabled(false);
                this._refreshAtLabel.setEnabled(false);
            }
        }
    }

    private void _trustedRadioButton_actionPerformed(ActionEvent e) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.m_rend == null) {
            this.m_rend = new DefaultListCellRenderer();
        }
        if (value instanceof MaterializedView.RefreshMode) {
            switch ((MaterializedView.RefreshMode)value) {
                case DEMAND: {
                    value = UIArb.getString(812);
                    break;
                }
                case COMMIT: {
                    value = UIArb.getString(813);
                    break;
                }
                case SPECIFY: {
                    value = UIArb.getString(814);
                    break;
                }
                case NEVER: {
                    value = UIArb.getString(815);
                    break;
                }
            }
        } else if (value instanceof MaterializedView.RefreshMethod) {
            switch ((MaterializedView.RefreshMethod)value) {
                case COMPLETE: {
                    value = UIArb.getString(807);
                    break;
                }
                case FORCE: {
                    value = UIArb.getString(805);
                    break;
                }
                case FAST: {
                    value = UIArb.getString(806);
                    break;
                }
                default: {
                    value = UIArb.getString(804);
                }
            }
        }
        return this.m_rend.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    private void disableAll() {
        this._refreshPeriodLabel.setEnabled(false);
        this._refreshPeriodComboBox.setEnabled(false);
        this._refreshMethodLabel.setEnabled(false);
        this._refreshMethodComboBox.setEnabled(false);
        this._refreshWithLabel.setEnabled(false);
        this._refreshWithComboBox.setEnabled(false);
        this._dateChooser.setEnabled(false);
        this._nextDateChooser.setEnabled(false);
        this._refreshAtLabel.setEnabled(false);
        this._nextDateLabel.setEnabled(false);
        this._rollbackCheckBox.setEnabled(false);
        this._defaultRollbackRadio.setEnabled(false);
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setEnabled(false);
        this._localRollbackRadio.setEnabled(false);
        this._masterRollbackRadio.setEnabled(false);
        this._refreshUseConstraintCheckBox.setEnabled(false);
        this._enforcedRadioButton.setEnabled(false);
        this._trustedRadioButton.setEnabled(false);
    }
}

