/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.icons.OracleIcons;

public class TabbedEditorPanel
extends DBTraversablePanel
implements PanelLibrary.HeaderPanelListener {
    private Traversable m_top;
    protected Traversable m_middle;
    protected String m_startPage;
    private JPanel m_cardPanel;
    private CardLayout m_cardLayout;
    private Map<String, Traversable> m_mapPanelSets = new HashMap<String, Traversable>();
    private TraversableContext m_data;

    protected TabbedEditorPanel(Traversable top, Navigable[] navs, String startPage) {
        this.m_startPage = startPage;
        this.m_top = top;
        if (this.m_top instanceof PanelLibrary.HeaderPanel) {
            ((PanelLibrary.HeaderPanel)this.m_top).addHeaderPanelListener(this);
        }
        this.layoutComponents(this.createPanel(navs));
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component c;
        if (this.m_top instanceof DBTraversablePanel && (c = ((DBTraversablePanel)this.m_top).getDefaultFocusComponent()) != null && c.isEnabled()) {
            return c;
        }
        if (this.m_middle instanceof DBTraversablePanel && (c = ((DBTraversablePanel)this.m_middle).getDefaultFocusComponent()) != null && c.isEnabled()) {
            return c;
        }
        return super.getDefaultFocusComponent();
    }

    protected Traversable createPanel(Navigable[] navs) {
        TabbedPanel retval = null;
        if (navs != null && navs.length > 0) {
            retval = new TabbedPanel(navs);
        }
        return retval;
    }

    public String getHelpID() {
        if (this.m_middle != null) {
            return this.m_middle.getHelpID();
        }
        return super.getHelpID();
    }

    private void layoutComponents(Traversable defaultPanel) {
        this.setLayout(new BorderLayout(0, 10));
        if (this.m_top != null) {
            JPanel header = new JPanel(new GridBagLayout());
            header.add(this.m_top.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
            JLabel iconLabel = new JLabel();
            iconLabel.setIcon(OracleIcons.getIcon((String)"header/database.png"));
            header.add((Component)iconLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (defaultPanel == null) {
                this.add(header, "Center");
            } else {
                this.add(header, "North");
            }
        }
        if (defaultPanel != null) {
            this.m_cardLayout = new CardLayout();
            this.m_cardPanel = new JPanel(this.m_cardLayout);
            this.addPanelSet("DEFAULT_PANEL", defaultPanel);
            this.add(this.m_cardPanel, "Center");
        }
    }

    private void addPanelSet(String key, Traversable panel) {
        this.m_mapPanelSets.put(key, panel);
        panel.getComponent().setName(key);
        this.m_cardPanel.add(panel.getComponent(), key);
    }

    private void showPanelSet(String key) throws TraversalException {
        Traversable panel;
        if (this.m_middle != null) {
            this.m_middle.onExit(this.m_data);
        }
        if (this.m_top instanceof PanelLibrary.HeaderPanel) {
            ((PanelLibrary.HeaderPanel)this.m_top).validatePanelChange(this.m_data);
        }
        if ((panel = this.m_mapPanelSets.get(key)) == null) {
            if (!key.equals("DEFAULT_PANEL")) {
                throw new IllegalStateException("tried to show a non-existent panel set: " + key);
            }
        } else {
            this.m_middle = panel;
            DBLog.log((String)("Editor showing panel set " + key), (Object[])new Object[0]);
            this.m_cardLayout.show(this.m_cardPanel, key);
            this.enterPanel(panel);
        }
    }

    protected void enterPanel(Traversable panel) {
        if (panel != null) {
            panel.onEntry(this.m_data);
        }
    }

    public void onEntry(TraversableContext data) {
        this.m_data = data;
        this.enterPanel(this.m_top);
        if (this.m_middle == null) {
            try {
                this.showPanelSet("DEFAULT_PANEL");
            }
            catch (TraversalException te) {
                DBLog.getLogger().log(Level.SEVERE, "Unexpected traversal error", te);
            }
        }
    }

    public void onExit(TraversableContext data) throws TraversalException {
        try {
            if (this.m_middle != null) {
                this.m_middle.onExit(data);
            }
            if (this.m_top != null) {
                this.m_top.onExit(data);
            }
            this.commitToProvider(data);
        }
        catch (TraversalException te) {
            this.enterPanel(this.m_top);
            this.enterPanel(this.m_middle);
            throw te;
        }
    }

    protected void commitToProvider(TraversableContext data) throws TraversalException {
        SystemObject newObject = (SystemObject)data.get("NewObject");
        SystemObject oldObject = (SystemObject)data.get("OriginalObject");
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        SystemObject[] secondaryObjects = (SystemObject[])data.get("NewSecondaryDBObjects");
        if (newObject == null) {
            throw new IllegalArgumentException("cannot create/edit without an object");
        }
        if (pro == null) {
            throw new IllegalArgumentException("cannot create/edit without a provider");
        }
        boolean replace = false;
        if (data.get("allowReplaceForUpdate") == Boolean.TRUE) {
            replace = true;
        }
        boolean creating = oldObject == null;
        Boolean boo = (Boolean)data.get("COMMIT_TO_PROVIDER_KEY");
        if (Boolean.TRUE.equals(boo)) {
            try {
                Schema newSchema = DBUtil.getSchema((DBObject)newObject);
                if (newSchema != null) {
                    Schema existingSchema = pro.getSchema(newSchema.getName());
                    if (existingSchema == null) {
                        pro.createSchema(newSchema, false);
                    } else if (newObject instanceof SchemaObject) {
                        ((SchemaObject)newObject).setSchema(existingSchema);
                    }
                }
                if (oldObject == null) {
                    SystemObject[] allObjects;
                    if (secondaryObjects != null && secondaryObjects.length > 0) {
                        allObjects = new SystemObject[secondaryObjects.length + 1];
                        allObjects[0] = newObject;
                        System.arraycopy(secondaryObjects, 0, allObjects, 1, secondaryObjects.length);
                    } else {
                        allObjects = new SystemObject[]{newObject};
                    }
                    pro.createObjects(allObjects, replace);
                } else {
                    SystemObject[] oldObjects;
                    SystemObject[] newObjects;
                    if (secondaryObjects != null && secondaryObjects.length > 0) {
                        newObjects = new SystemObject[secondaryObjects.length + 1];
                        oldObjects = new SystemObject[secondaryObjects.length + 1];
                        newObjects[0] = newObject;
                        oldObjects[0] = oldObject;
                        int i = 1;
                        for (SystemObject so : secondaryObjects) {
                            try {
                                newObjects[i] = so;
                                oldObjects[i++] = (SystemObject)DBUtil.getProviderDefinition((DBObject)so, (DBObjectProvider)pro);
                            }
                            catch (DBException e) {
                                DBLog.getLogger((Object)this).warning("Error listing existing objects: " + e.getMessage());
                            }
                        }
                    } else {
                        newObjects = new SystemObject[]{newObject};
                        oldObjects = new SystemObject[]{oldObject};
                    }
                    if (newObject instanceof PlSql) {
                        this.ensureNameIsInSource((PlSql)newObject, pro);
                    }
                    if (!CascadeConfirmDialog.updateObjects((Component)((Object)this), UIArb.getString(117), pro, oldObjects, newObjects, replace)) {
                        throw new TraversalException(null);
                    }
                }
            }
            catch (DBException ex) {
                this.processException(ex, creating);
            }
        } else if (oldObject != null) {
            DBUtil.updateObjectAndIDs((DBObject)oldObject, (DBObject)newObject);
        }
    }

    private void processException(DBException ex, boolean creating) throws TraversalException {
        DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIArb.getString(creating ? 118 : 117), ex);
        throw new TraversalException(null);
    }

    @Override
    public void panelSetChange(String key, Navigable[] navs) throws TraversalException {
        if (!this.m_mapPanelSets.containsKey(key)) {
            Traversable middle = this.createPanel(navs);
            this.addPanelSet(key, middle);
        }
        this.showPanelSet(key);
    }

    protected void ensureNameIsInSource(PlSql newObject, DBObjectProvider pro) {
        SpecPlSql obj;
        PlSqlInterrogator pi;
        String oldInternalName;
        String newInternalName = newObject.getName();
        if (!newInternalName.equals(oldInternalName = pro.getInternalName((pi = newObject.getSourceInterrogator()).getName()))) {
            newObject.setSource(pi.getRenamedSource(this.adjustCase(newInternalName)));
        }
        if (newObject instanceof SpecPlSql && (obj = (SpecPlSql)newObject).getBodySource() != null && !newInternalName.equals(oldInternalName = pro.getInternalName((pi = obj.getBodySourceInterrogator()).getName()))) {
            obj.setBodySource(pi.getRenamedSource(this.adjustCase(newInternalName)));
        }
    }

    private String adjustCase(String str) {
        if (str != null && GlobalSettings.getInstance().isNewPlSqlLowerCase() && !str.startsWith("\"") && !str.startsWith("'")) {
            return str.toLowerCase();
        }
        return str;
    }
}

