/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.SynonymInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.util.ModelUtil;

public class SynonymPanel
extends BaseInfoPanel
implements ActionListener {
    private static final String[] SYNONYM_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "PACKAGE", "MATERIALIZED VIEW", "PROCEDURE", "FUNCTION", "TYPE", "SYNONYM"};
    private static final String OBJECTCHANGED = "ObjectChanged";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    private DBObjectProvider m_prov = null;
    private Synonym m_synonym = null;
    private Schema m_forSchema = null;
    private String m_savedName = null;
    private GridBagLayout layCenter = new GridBagLayout();
    private JLabel m_lblFor = new JLabel();
    private JLabel m_lblForSchemaName = new JLabel();
    private JMultiLineLabel m_lblDanglingBlather = new JMultiLineLabel();
    private DBObjectChooser m_cmbForSchema = new DBObjectChooser("SCHEMA");
    private DBObjectChooser m_cmbObject = new DBObjectChooser(this.m_cmbForSchema, SYNONYM_TYPES);
    private JTextField m_txtName = new JTextField();
    private JRadioButton m_rdbObjectBased = new JRadioButton();
    private JRadioButton m_rdbNameBased = new JRadioButton();
    private ButtonGroup m_rbgBased = new ButtonGroup();
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap = new HashMap();
    private SynonymInfoVerifier m_verifier;
    private boolean m_isDefaultObject = true;
    private boolean m_isNewSynonymObject = true;
    private boolean m_active = false;

    public SynonymPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        this.m_cmbForSchema.setName("SynonymPanel.m_cmbForSchema");
        this.m_cmbForSchema.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (SynonymPanel.this.m_active) {
                    boolean nameBased = SynonymPanel.this.m_rdbNameBased.isSelected();
                    SynonymPanel.this.m_forSchema = (Schema)SynonymPanel.this.m_cmbForSchema.getDBObject();
                    if (SynonymPanel.this.m_rdbObjectBased.isSelected() && SynonymPanel.this.m_cmbObject.getDBObjectID() == null) {
                        nameBased = true;
                    }
                    SynonymPanel.this.setEnabledFields(nameBased);
                }
            }
        });
        this.m_cmbForSchema.setEditable(false);
        this.m_cmbObject.setName("BasedOn");
        this.m_cmbObject.setEditable(false);
        this.m_cmbObject.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (SynonymPanel.this.m_active) {
                    SynonymPanel.this.m_isDefaultObject = SynonymPanel.this.m_isNewSynonymObject || SynonymPanel.this.m_cmbObject.getDBObjectID() == null;
                }
            }
        });
        this.m_lblFor.setText(UIArb.getString(345));
        this.m_lblDanglingBlather.setPreferredAspectRatio(0.0f);
        ResourceUtils.resLabel((JLabel)this.m_lblForSchemaName, (Component)this.m_cmbForSchema, (String)UIArb.getString(346));
        this.m_rdbObjectBased.setName("SynonymPanel.m_rdbObjectBased");
        ResourceUtils.resButton((AbstractButton)this.m_rdbObjectBased, (String)UIArb.getString(347));
        this.m_rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.m_rdbObjectBased.addActionListener(this);
        this.m_rdbNameBased.setName("SynonymPanel.m_rdbNameBased");
        ResourceUtils.resButton((AbstractButton)this.m_rdbNameBased, (String)UIArb.getString(348));
        this.m_rdbNameBased.setActionCommand(SETNAMEBASED);
        this.m_rdbNameBased.addActionListener(this);
        this.m_rbgBased.add(this.m_rdbObjectBased);
        this.m_rbgBased.add(this.m_rdbNameBased);
        this.m_txtName.setName("SynonymPanel.m_txtName");
        this.m_txtName.getAccessibleContext().setAccessibleName(UIArb.getString(349));
        this.setLayout(this.layCenter);
        int y = 0;
        this.add(this.m_lblFor, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblForSchemaName, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbForSchema, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbObjectBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbObject, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbNameBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_txtName, new GridBagConstraints(2, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_lblDanglingBlather, new GridBagConstraints(1, ++y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIArb.getString(343);
    }

    public String getHeaderDescription() {
        return UIArb.getString(344);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_active = false;
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_synonym = (Synonym)dataContext.find("NewObject");
        this.m_verifier = (SynonymInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        this.init(this.m_synonym, this.m_verifier);
        this.m_active = true;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Synonym synonym = (Synonym)dataContext.find("NewObject");
        if (synonym == null) {
            synonym = new Synonym();
        }
        this.commit(synonym);
        this.m_active = false;
    }

    private void init(Synonym model, SynonymInfoVerifier verifier) {
        super.init(this.m_prov, verifier);
        this.m_cmbForSchema.setProvider(this.m_prov);
        this.m_cmbForSchema.setDBObject((DBObject)this.m_forSchema);
        this.m_renderer.setProvider(this.m_prov);
        if (this.isDangling(model.getReference())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_forSchema = model.getSchema();
        if (this.m_forSchema != null && "PUBLIC".equals(this.m_forSchema.getName())) {
            try {
                this.m_forSchema = this.m_prov.getDefaultSchema();
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        boolean nameBased = true;
        DBObjectID refID = model.getReference();
        if (null != refID) {
            this.m_isNewSynonymObject = false;
            nameBased = refID instanceof ReferenceID || this.isDangling(refID);
            SchemaObject forObject = null;
            try {
                forObject = (SchemaObject)refID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (forObject == null) {
                this.setForSchemaAndName(refID);
                nameBased = true;
            } else {
                this.m_forSchema = forObject.getSchema();
                this.m_savedName = this.getProvider().getExternalName(forObject.getName());
            }
        }
        this.setEnabledFields(nameBased);
        SchemaObject ref = null;
        if (null != refID) {
            try {
                DBObject temp = refID.resolveID();
                if (temp instanceof SchemaObject) {
                    ref = (SchemaObject)temp;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (null != ref) {
            this.m_isDefaultObject = false;
            this.m_forSchema = ref.getSchema();
        }
        if (nameBased) {
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (null != ref) {
                this.m_cmbObject.setDBObject((DBObject)ref);
            }
            if (this.m_cmbObject.getDBObjectID() == null) {
                nameBased = true;
            }
        }
        this.setEnabledFields(nameBased);
        this.m_lblFor.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_rdbNameBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_cmbObject.setEnabled(!nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEditable(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEnabled(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_isNewSynonymObject = false;
    }

    private void commit(Synonym synonym) throws TraversalException {
        this.m_forSchema = (Schema)this.m_cmbForSchema.getDBObject();
        SchemaObject refObj = null;
        String refObjName = null;
        boolean objectBased = this.m_rdbObjectBased.isSelected();
        if (objectBased) {
            refObj = (SchemaObject)this.m_cmbObject.getDBObject();
            refObjName = refObj == null ? null : refObj.getName();
        } else {
            refObjName = this.m_txtName.getText();
            if (refObjName != null) {
                refObjName = this.getProvider().getInternalName(refObjName);
            }
            refObj = this.findObject(refObjName);
        }
        if (!ModelUtil.hasLength((String)refObjName)) {
            throw new TraversalException(UIArb.getString(352));
        }
        if (objectBased && null != refObj) {
            synonym.setReference(refObj.getID());
        } else {
            ReferenceID nameBasedReference = new ReferenceID(null, this.m_forSchema, refObjName);
            synonym.setReference((DBObjectID)nameBasedReference);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_active) {
            boolean nameBased = this.m_rdbNameBased.isSelected();
            if (SETOBJECTBASED.equals(e.getActionCommand())) {
                SchemaObject object;
                this.m_savedName = this.m_txtName.getText();
                if (ModelUtil.hasLength((String)this.m_savedName) && null != (object = this.findObject(this.m_savedName))) {
                    this.m_cmbObject.setDBObject((DBObject)object);
                }
                this.m_txtName.setText(null);
            } else {
                SchemaObject ob = (SchemaObject)this.m_cmbObject.getDBObject();
                if (!this.m_isDefaultObject && null != ob) {
                    this.m_txtName.setText(ob.getName());
                } else if (null != this.m_savedName && this.m_savedName.length() > 0) {
                    this.m_txtName.setText(this.m_savedName);
                }
                nameBased = true;
            }
            this.setEnabledFields(nameBased);
        }
    }

    private void setEnabledFields(boolean nameBased) {
        this.m_rdbNameBased.setSelected(nameBased);
        this.m_rdbObjectBased.setSelected(!nameBased);
        this.m_txtName.setEditable(nameBased);
        this.m_txtName.setEnabled(nameBased);
        this.m_cmbObject.setEnabled(!nameBased);
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (null != this.m_synonym) {
            objectModel = new NonNullableComboBoxModel();
            try {
                DBObject refob = this.m_synonym.getReference().resolveID();
                if (null != refob) {
                    objectModel.addElement(refob.getName());
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (null != name) {
            for (int i = 0; i < SYNONYM_TYPES.length; ++i) {
                try {
                    result = this.m_prov.getObject(SYNONYM_TYPES[i], this.m_forSchema, name);
                    if (null == result) continue;
                    break;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof BaseObjectID) {
            BaseObjectID sRefID = (BaseObjectID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = null == forSchema ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = this.getProvider().getExternalName(sRefID.getName());
        }
    }

    public String getTitle() {
        return UIArb.getString(353);
    }
}

