/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.controls.SchemaObjectTargetPicker;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SelectDBObjectsPanel
extends SkippingTraversable
implements ActionListener,
ItemListener,
DocumentListener,
ShuttleListener,
KeyListener,
CheckBoxListItemStateListener {
    private static final ArrayList<String> NOT_SCHEMA_OBJECT_TYPES = new ArrayList<String>(Arrays.asList("COLUMN", "CONSTRAINT", "INDEX", "SCHEMA", "RECYCLEBIN"));
    public static final String SELECTED_OBJECTS = "SelectDBObjectsPanel.SELECTED_OBJECTS";
    public static final String SETTINGS_KEY = SelectDBObjectsPanel.class.getName();
    private static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    private static final String SETTINGS_QUERY_KEY = "query";
    private static final String SETTINGS_FILTER_KEY = "filter";
    private static final String SETTINGS_SCHEMA_KEY = "schema";
    private static final String SETTINGS_CONNECTION_KEY = "connection";
    protected WizardCallbacks m_callBacks;
    private boolean m_entered;
    private boolean m_init;
    private Schema m_publicSchema;
    private DBObjectProvider m_pro;
    protected SchemaObjectTargetPicker m_chosen;
    private DBObjectSourcePicker m_from;
    private List m_selectedTypes;
    private Timer m_timer;
    private JPanel m_centerPanel = new JPanel();
    private JLabel m_filterLabel = new JLabel();
    private JTextField m_filter = new JTextField();
    private JCheckBox m_autoQuery = new JCheckBox();
    private JLabel m_schemasLabel = new JLabel();
    private DBObjectChooser m_schemas = new DBObjectChooser("SCHEMA");
    private JButton m_query = new JButton();
    private DBUIResourceHelper m_reshelp = new DBUIResourceHelper(this.getPanelName());
    private JEWTDialog m_typesDialog;
    private CheckBoxListModel m_typeBoxes;
    private CheckBoxListPanel m_typesPanel;
    private JLabel m_typesDialogErrorLabel;
    private JLabel m_typeLabel = new JLabel();
    private JButton m_typeButton = new JButton();
    protected Shuttle m_shuttle = new Shuttle();

    public SelectDBObjectsPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Layout failed", e);
        }
    }

    protected String getPanelName() {
        return "SelectDBObjectsPanel";
    }

    protected void layoutComponents() {
        this.m_centerPanel.setLayout(new GridBagLayout());
        JPanel row1 = this.getRow1();
        this.m_centerPanel.add((Component)row1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel row2 = this.getRow2();
        this.m_centerPanel.add((Component)row2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.m_reshelp.setName((Component)this.m_shuttle, "Shuttle");
        this.m_centerPanel.add((Component)this.m_shuttle, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.m_centerPanel, "Center");
    }

    private JPanel getRow1() {
        JPanel row1 = new JPanel();
        row1.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_schemasLabel, this.m_schemas, UIArb.getString(225), "Schema");
        row1.add((Component)this.m_schemasLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_schemas.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            }
        });
        row1.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        row1.add((Component)this.m_typeLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeButton.addActionListener(this);
        this.m_reshelp.resButton(this.m_typeButton, UIArb.getString(221), "FilterTypes");
        row1.add((Component)this.m_typeButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row1;
    }

    private JPanel getRow2() {
        JPanel row2 = new JPanel();
        row2.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_filterLabel, this.m_filter, UIArb.getString(226), "Filter");
        row2.add((Component)this.m_filterLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_filter.setText("%");
        this.m_filter.getDocument().addDocumentListener(this);
        this.m_filter.addKeyListener(this);
        row2.add((Component)this.m_filter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_autoQuery, UIArb.getString(227), "AutoQuery");
        this.m_autoQuery.addItemListener(this);
        row2.add((Component)this.m_autoQuery, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_query, UIArb.getString(228), "Query");
        this.m_query.addActionListener(this);
        row2.add((Component)this.m_query, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row2;
    }

    private void setupTypesModel() {
        this.m_typesPanel = null;
        this.m_typeBoxes = new CheckBoxListModel();
        Object[] availableTypes = this.getAvailableTypes();
        Arrays.sort(availableTypes);
        for (int i = 0; i < availableTypes.length; ++i) {
            String label = DBTypeDisplayRegistry.getDisplayName((String)availableTypes[i]);
            Icon icon = DBTypeDisplayRegistry.getNodeIcon((String)availableTypes[i]);
            this.m_typeBoxes.addElement(availableTypes[i], icon, true, true, label);
        }
        this.m_typeBoxes.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected NameController getNameController() {
        return null;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new DBObjectSourcePicker(this.m_pro, false, true);
        }
        return this.m_from;
    }

    protected ItemPicker getToPicker() {
        if (this.m_chosen == null) {
            NameController nameController = this.getNameController();
            this.m_chosen = new SchemaObjectTargetPicker(nameController);
            if (nameController != null) {
                this.m_shuttle.addShuttleListener((ShuttleListener)this.m_chosen);
            }
        }
        return this.m_chosen;
    }

    protected boolean canFinish() {
        return false;
    }

    protected boolean canAlwaysNext() {
        return false;
    }

    @Deprecated
    protected boolean canRenameObjects() {
        return false;
    }

    protected String[] getAvailableTypes() {
        ItemPicker to = this.getToPicker();
        if (to instanceof SchemaObjectTargetPicker) {
            DBObjectProvider source = this.m_pro;
            DBObjectProvider target = ((SchemaObjectTargetPicker)to).getProvider();
            if (source != null) {
                ArrayList<String> retval = new ArrayList<String>();
                String[] types = this.listSupportedSchemaTypes(source);
                List<String> targTypes = target != null ? Arrays.asList(this.listSupportedSchemaTypes(target)) : null;
                for (int i = 0; i < types.length; ++i) {
                    if (targTypes != null && !targTypes.contains(types[i])) continue;
                    retval.add(types[i]);
                }
                return retval.toArray(new String[retval.size()]);
            }
        }
        return new String[]{"TABLE", "VIEW"};
    }

    private String[] listSupportedSchemaTypes(DBObjectProvider pro) {
        ArrayList<String> allTypes = new ArrayList<String>(Arrays.asList(pro.listObjectTypes()));
        allTypes.removeAll(NOT_SCHEMA_OBJECT_TYPES);
        return allTypes.toArray(new String[allTypes.size()]);
    }

    protected String getProviderKey() {
        return "DBObjectProvider";
    }

    @Override
    public final void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        this.m_callBacks = dataContext.getWizardCallbacks();
        if (this.isSkipping()) {
            return;
        }
        boolean providerChanged = false;
        DBObjectProvider pro = this.getProvider(dataContext);
        if (this.m_pro != pro) {
            providerChanged = true;
        }
        this.m_pro = pro;
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onEntry(dataContext);
            }
            this.init(providerChanged, dataContext);
            this.entered();
        }
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onExit(dataContext);
            }
            this.exited();
            this.commit(dataContext);
            this.saveSettings();
        }
    }

    private void entered() {
        this.m_entered = true;
    }

    private void exited() {
        this.m_entered = false;
        this.saveSettings();
    }

    protected DBObjectProvider getProvider(TraversableContext dataContext) {
        return (DBObjectProvider)dataContext.get(this.getProviderKey());
    }

    protected void commit(TraversableContext dataContext) throws TraversalException {
        dataContext.put(SELECTED_OBJECTS, this.getSelectedObjects());
    }

    protected Object getSelectedObjects() {
        Object[] retval = null;
        if (this.m_chosen == null) {
            ItemPicker to = this.getToPicker();
            retval = to.getAllSelectableItems();
        } else {
            ListModel model = this.m_chosen.getList().getModel();
            int c = model.getSize();
            retval = new SchemaObjectDescriptor[c];
            for (int i = 0; i < c; ++i) {
                ((SchemaObjectDescriptor[])retval)[i] = (SchemaObjectDescriptor)model.getElementAt(i);
            }
        }
        return retval;
    }

    protected void setIncludePublicSchema(boolean inc) {
        this.m_publicSchema = inc ? new Schema("PUBLIC") : null;
    }

    protected void init(boolean providerChanged, TraversableContext dataContext) {
        boolean doQuery = providerChanged;
        if (!this.m_init) {
            this.m_init = true;
            doQuery = true;
        }
        this.setupTypesModel();
        this.loadSettings();
        if (doQuery) {
            Schema defaultSchema = (Schema)dataContext.get("Schema");
            this.getFromPicker().setProvider(this.m_pro);
            if (defaultSchema == null) {
                try {
                    defaultSchema = this.m_pro.getDefaultSchema();
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(UIArb.format(244, dbe.getMessage()));
                }
            }
            this.m_schemas.setProvider(this.m_pro);
            this.m_schemas.setDBObject((DBObject)defaultSchema);
            this.loadSchemaSetting();
            this.selectTypes();
        }
        this.checkWizardButtons();
        JLabel lblFrom = new JLabel();
        JLabel lblTo = new JLabel();
        DBObjectSourcePicker fromPick = this.getFromPicker();
        ItemPicker toPick = this.getToPicker();
        this.m_shuttle.setFromPicker((ItemPicker)fromPick);
        this.m_shuttle.setToPicker(toPick);
        this.m_reshelp.setName(fromPick.getComponent(), "From");
        this.m_reshelp.setName(toPick.getComponent(), "To");
        this.m_shuttle.add((Component)lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)lblTo, (Object)"ToHeader");
        this.m_reshelp.resLabel(lblFrom, fromPick.getComponent(), UIArb.getString(229), "Available");
        this.m_reshelp.resLabel(lblTo, toPick.getComponent(), UIArb.getString(230), "Selected");
        if (doQuery && this.m_autoQuery.isSelected()) {
            this.fireQuery();
        }
        if (this.m_callBacks != null) {
            if (this.m_autoQuery.isSelected()) {
                if (!this.getToPicker().isSelectableItemPresent()) {
                    this.m_callBacks.wizardSetInitialFocus((Component)this.getFromPicker().getTree());
                }
            } else {
                this.m_callBacks.wizardSetInitialFocus((Component)this.m_query);
            }
        }
    }

    protected void fireQuery() {
        this.getTimer().stop();
        DBObjectSourcePicker from = this.getFromPicker();
        if (from != null && this.m_selectedTypes != null) {
            Schema schema = (Schema)this.m_schemas.getDBObject();
            String filter = this.m_filter.getText();
            String[] types = this.m_selectedTypes.toArray(new String[this.m_selectedTypes.size()]);
            this.setupQuery(from, schema, filter, types);
            this.getTimer().stop();
            from.query();
            this.m_shuttle.setEnabled(true);
        }
    }

    protected void setupQuery(DBObjectSourcePicker from, Schema schema, String filter, String[] types) {
        from.setSchema(schema);
        from.setTypes(types);
        if (filter.startsWith("'") && filter.endsWith("'") && !filter.startsWith("''") && !filter.endsWith("''")) {
            filter = filter.substring(1, filter.length() - 1);
        }
        if (!(filter = filter.replaceAll("'", "''")).startsWith("\"") || !filter.endsWith("\"")) {
            filter = filter.replaceAll("\\*", "%");
        }
        if ((filter = this.m_pro.getInternalName(filter)).indexOf("%") < 0 && !filter.endsWith("%")) {
            filter = filter + "%";
        }
        from.setFilter(filter);
        this.m_filter.setText(this.externaliseFilter(filter));
    }

    private String externaliseFilter(String filter) {
        String extNoPercent;
        String external;
        String string = external = ModelUtil.hasLength((String)filter) ? this.m_pro.getExternalName(filter) : "";
        if (filter.indexOf(37) < 0) {
            String quoteString = this.m_pro.getIdentifierQuoteString();
            if (quoteString != null && external.endsWith(quoteString)) {
                return external.substring(0, external.lastIndexOf(quoteString)) + '%' + quoteString;
            }
            return external + '%';
        }
        String noPercent = filter.replaceAll("%", "");
        String string2 = extNoPercent = ModelUtil.hasLength((String)noPercent) ? this.m_pro.getExternalName(noPercent) : noPercent;
        if (noPercent.equals(extNoPercent)) {
            return filter;
        }
        return external;
    }

    private void selectTypes() {
        StringBuilder typesTT = new StringBuilder();
        typesTT.append(UIArb.getString(224));
        this.m_selectedTypes = this.m_typeBoxes.getSelectionList();
        if (this.m_selectedTypes != null) {
            Iterator iter = this.m_selectedTypes.iterator();
            while (iter.hasNext()) {
                typesTT.append(" ");
                typesTT.append(DBTypeDisplayRegistry.getDisplayName((String)iter.next()));
            }
        }
        DBObjectRenderer.setToolTipText(this.m_typeButton, typesTT.toString());
        if (this.m_selectedTypes == null || this.m_selectedTypes.size() < this.m_typeBoxes.getSize()) {
            this.m_typeLabel.setText(UIArb.getString(222));
        } else {
            this.m_typeLabel.setText(UIArb.getString(223));
        }
    }

    private Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener alist = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            };
            this.m_timer = new Timer(2000, alist);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    protected void loadSettings() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            boolean aq = settings.getBoolean(SETTINGS_AUTO_QUERY_KEY, false);
            this.m_autoQuery.setSelected(aq);
            this.m_query.setEnabled(!aq);
            this.m_typeBoxes.deselectAll();
            for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
                String type = (String)this.m_typeBoxes.getUserObjectAt(i);
                if (!settings.getBoolean(SETTINGS_QUERY_KEY + type, true)) continue;
                this.m_typeBoxes.setElementSelected(i);
            }
            List selected = this.m_typeBoxes.getSelectionList();
            if (selected == null || selected.size() < 1) {
                this.m_typeBoxes.selectAll();
            }
            if (this.useSavedFilterAndSchema()) {
                this.m_filter.setText(settings.getString(SETTINGS_FILTER_KEY));
            }
        } else {
            this.setDefaultSettings();
        }
    }

    private void loadSchemaSetting() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            String schemaName;
            String connectionName = this.getConnectionName();
            if (this.useSavedFilterAndSchema() && ModelUtil.hasLength((String)(schemaName = settings.getString(SETTINGS_SCHEMA_KEY)))) {
                try {
                    Schema schema = this.m_pro.getSchema(schemaName);
                    this.m_schemas.setDBObject((DBObject)schema);
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(UIArb.format(244, dbe.getMessage()));
                }
            }
        }
    }

    private boolean useSavedFilterAndSchema() {
        String userName;
        String connectionName;
        HashStructure settings = this.getSettings();
        return settings != null && ModelUtil.hasLength((String)(connectionName = this.getConnectionName())) && connectionName.equals(settings.getString(SETTINGS_CONNECTION_KEY)) && ModelUtil.hasLength((String)(userName = this.getUserName())) && userName.equals(settings.getString(SETTINGS_SCHEMA_KEY));
    }

    private HashStructure getSettings() {
        String key = this.getSettingsKey();
        HashStructure settings = null;
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            settings = ps.getProperties().getHashStructure(key);
        }
        return settings;
    }

    protected void setDefaultSettings() {
        boolean autoQuery = !(this.m_pro instanceof Database);
        this.m_autoQuery.setSelected(autoQuery);
        this.m_query.setEnabled(!autoQuery);
    }

    protected void saveSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            HashStructure settings = ps.getProperties().getOrCreateHashStructure(key);
            settings.putBoolean(SETTINGS_AUTO_QUERY_KEY, this.m_autoQuery.isSelected());
            if (this.m_typeBoxes != null) {
                for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
                    String type = (String)this.m_typeBoxes.getUserObjectAt(i);
                    settings.putBoolean(SETTINGS_QUERY_KEY + type, this.m_typeBoxes.isElementSelected(i));
                }
            }
            settings.putString(SETTINGS_CONNECTION_KEY, this.getConnectionName());
            settings.putString(SETTINGS_FILTER_KEY, this.m_filter.getText());
            Schema schema = (Schema)this.m_schemas.getDBObject();
            if (schema != null) {
                settings.putString(SETTINGS_SCHEMA_KEY, schema.getName());
            }
        }
    }

    private String getConnectionName() {
        String connectionName = null;
        if (this.m_pro instanceof Database) {
            connectionName = ((Database)this.m_pro).getConnectionName();
        }
        return connectionName;
    }

    private String getUserName() {
        String userName = null;
        if (this.m_pro instanceof Database) {
            try {
                userName = ((Database)this.m_pro).getUserName();
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).warning(UIArb.format(244, dbe.getMessage()));
            }
        }
        return userName;
    }

    protected void checkWizardButtons() {
        ItemPicker to;
        if (this.m_callBacks != null && (to = this.getToPicker()) != null) {
            Boolean finish;
            Transferable[] t = to.getAllSelectableItems();
            boolean haveStuff = t != null && t.length > 0;
            Boolean bl = finish = this.canFinish() && haveStuff ? Boolean.TRUE : Boolean.FALSE;
            Boolean next = this.canAlwaysNext() ? Boolean.TRUE : (haveStuff ? Boolean.TRUE : Boolean.FALSE);
            this.m_callBacks.wizardEnableButtons(null, next, finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFilterTypesDialog() {
        this.m_typesDialog = JEWTDialog.createDialog((Component)this.m_typeButton, (String)UIArb.getString(198), (int)7);
        DefaultTraversablePanel content = new DefaultTraversablePanel();
        content.setHelpID("f1_db_filter_types_html");
        content.setLayout((LayoutManager)new BorderLayout(0, 5));
        if (this.m_typesPanel == null) {
            this.m_typesPanel = new CheckBoxListPanel(this.m_typeBoxes);
            this.m_typesPanel.getList().setLayoutOrientation(1);
        }
        content.add((Component)this.m_typesPanel, (Object)"Center");
        if (this.m_typesDialogErrorLabel == null) {
            this.m_typesDialogErrorLabel = new JLabel(" ");
        }
        content.add((Component)this.m_typesDialogErrorLabel, (Object)"South");
        this.m_typesDialog.setContent((Component)content);
        this.m_typesDialog.setName(this.getPanelName() + ".TypesDialog");
        try {
            if (this.m_typesDialog.runDialog()) {
                this.selectTypes();
                if (this.m_autoQuery.isSelected()) {
                    this.fireQuery();
                }
            } else {
                this.m_typeBoxes.deselectAll();
                for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
                    if (!this.m_selectedTypes.contains(this.m_typeBoxes.getUserObjectAt(i))) continue;
                    this.m_typeBoxes.setElementSelected(i);
                }
            }
        }
        finally {
            this.m_typesDialog.dispose();
            this.m_typesDialog = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_entered) {
            Object source = e.getSource();
            if (source == this.m_query) {
                this.fireQuery();
            } else if (source == this.m_typeButton) {
                this.showFilterTypesDialog();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source;
        if (this.m_entered && (source = e.getSource()) == this.m_autoQuery) {
            switch (e.getStateChange()) {
                case 1: {
                    this.m_query.setEnabled(false);
                    this.getTimer().restart();
                    break;
                }
                case 2: {
                    this.m_query.setEnabled(true);
                }
            }
        }
    }

    private void showTypesErrorDialog(Component parent) {
        MessageDialog.error((Component)parent, (Object)UIArb.getString(242), (String)UIArb.getString(243), null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent p0) {
        this.checkWizardButtons();
    }

    public void shuttleItemsRemoved(ShuttleEvent p0) {
        this.checkWizardButtons();
    }

    public void shuttleItemsReordered(ShuttleEvent p0) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.fireQuery();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void stateChanged(Object source) {
        if (this.m_typesDialog != null) {
            List selected = this.m_typeBoxes.getSelectionList();
            if (selected == null || selected.isEmpty()) {
                this.m_typesDialogErrorLabel.setText(UIArb.getString(242));
                this.m_typesDialog.setOKButtonEnabled(false);
            } else {
                this.m_typesDialogErrorLabel.setText(" ");
                this.m_typesDialog.setOKButtonEnabled(true);
            }
        }
    }

    @Override
    protected String getTraversableName() {
        return null;
    }
}

