/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.DatabaseLinkInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class DatabaseLinkPanel
extends DefaultTraversablePanel
implements ActionListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String PUBLIC = "PUBLIC";
    private JLabel serviceNameLabel = new JLabel();
    private JTextArea serviceNameTextArea = new JTextArea();
    private JRadioButton currentUserRadioBtn = new JRadioButton();
    private JRadioButton fixedUserRadioBtn = new JRadioButton();
    private JLabel fixedUserNameLabel = new JLabel();
    private JLabel fixedUserPasswordLabel = new JLabel();
    private JTextField userNameTextField = new JTextField();
    private JPasswordField passwordField = new JPasswordField();
    private JCheckBox sharedCheckBox = new JCheckBox();
    private JLabel authenUserNameLabel = new JLabel();
    private JLabel authenPasswordLabel = new JLabel();
    private JTextField authenTextFeild = new JTextField();
    private JPasswordField authenPasswordField = new JPasswordField();
    private JLabel jLabel1 = new JLabel();
    private ButtonGroup userTypeButtonGroup = new ButtonGroup();
    private HashMap m_loadingSchemas = new HashMap();
    private static final String[] DATABASELINK_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "DATABASE LINK"};
    private static final String ACMD_FIXEDUSER = "FixedUser";
    private static final String ACMD_SHARED = "Shared";
    protected DBObjectProvider m_prov = null;
    protected DatabaseLink m_dblink = null;
    protected Schema m_forSchema = null;
    protected String m_savedName = null;
    private JComboBox m_cmbObject = new JComboBox();
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap = new HashMap();
    private DatabaseLinkInfoVerifier m_verifier;
    private boolean m_isInit = false;

    public DatabaseLinkPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.userTypeButtonGroup.add(this.fixedUserRadioBtn);
        this.userTypeButtonGroup.add(this.currentUserRadioBtn);
        this.jLabel1.setText(UIArb.getString(974));
        ResourceUtils.resLabel((JLabel)this.serviceNameLabel, (Component)this.serviceNameTextArea, (String)UIArb.getString(963));
        ResourceUtils.resLabel((JLabel)this.fixedUserNameLabel, (Component)this.userNameTextField, (String)UIArb.getString(969));
        ResourceUtils.resLabel((JLabel)this.fixedUserPasswordLabel, (Component)this.passwordField, (String)UIArb.getString(970));
        ResourceUtils.resLabel((JLabel)this.authenUserNameLabel, (Component)this.authenTextFeild, (String)UIArb.getString(971));
        ResourceUtils.resLabel((JLabel)this.authenPasswordLabel, (Component)this.authenPasswordField, (String)UIArb.getString(972));
        ResourceUtils.resButton((AbstractButton)this.fixedUserRadioBtn, (String)UIArb.getString(967));
        ResourceUtils.resButton((AbstractButton)this.currentUserRadioBtn, (String)UIArb.getString(965));
        ResourceUtils.resButton((AbstractButton)this.sharedCheckBox, (String)UIArb.getString(973));
        this.add(this.serviceNameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.serviceNameTextArea, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 6, 0, 0), 0, 0));
        this.add(this.fixedUserRadioBtn, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.add(this.currentUserRadioBtn, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.add(this.fixedUserNameLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.userNameTextField, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.fixedUserPasswordLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.passwordField, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.sharedCheckBox, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.add(this.authenUserNameLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.authenTextFeild, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.authenPasswordLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.authenPasswordField, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.serviceNameLabel.setToolTipText(UIArb.getString(964));
        this.currentUserRadioBtn.setToolTipText(UIArb.getString(966));
        this.fixedUserRadioBtn.setToolTipText(UIArb.getString(968));
        this.serviceNameTextArea.setLineWrap(true);
        this.serviceNameTextArea.setWrapStyleWord(true);
        this.currentUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.currentUserRadioBtn.addActionListener(this);
        this.fixedUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.fixedUserRadioBtn.addActionListener(this);
        this.sharedCheckBox.setActionCommand(ACMD_SHARED);
        this.sharedCheckBox.addActionListener(this);
    }

    private void currentUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    private void fixedUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    public String getHeaderTitle() {
        return UIArb.getString(857);
    }

    public String getHeaderDescription() {
        return UIArb.getString(858);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_dblink = (DatabaseLink)dataContext.find("NewObject");
        boolean edit = dataContext.find("OriginalObject") != null;
        this.m_verifier = (DatabaseLinkInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        this.init(this.m_dblink, this.m_verifier, edit);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DatabaseLink original = (DatabaseLink)dataContext.find("OriginalObject");
        DatabaseLink databaselink = (DatabaseLink)dataContext.find("NewObject");
        if (databaselink == null) {
            databaselink = new DatabaseLink();
        }
        this.commit(original, databaselink);
    }

    private void init(DatabaseLink model, DatabaseLinkInfoVerifier verifier, boolean edit) {
        if (this.m_isInit) {
            return;
        }
        this.m_isInit = true;
        this.serviceNameTextArea.setText(model.getHost());
        this.userNameTextField.setText(model.getUsername());
        this.sharedCheckBox.setSelected(model.isShared());
        this.authenTextFeild.setText(model.getAuthentificationUsername());
        this.currentUserRadioBtn.setSelected(model.isCurrentUser());
        this.fixedUserRadioBtn.setSelected(!model.isCurrentUser());
        this.fixedUserNameLabel.setEnabled(false);
        this.fixedUserPasswordLabel.setEnabled(false);
        this.userNameTextField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.enableFixedUserControls();
        this.enableSharedControls();
    }

    private void commit(DatabaseLink original, DatabaseLink databaselink) throws TraversalException {
        DatabaseLinkInfoVerifier verifier;
        String pwd = null;
        databaselink.setHost(this.serviceNameTextArea.getText());
        if (this.currentUserRadioBtn.isSelected()) {
            databaselink.setCurrentUser(true);
            databaselink.setUsername(null);
            databaselink.setPassword(null);
        } else {
            databaselink.setCurrentUser(false);
            databaselink.setUsername(this.userNameTextField.getText());
            pwd = new String(this.passwordField.getPassword());
            if (!ModelUtil.hasLength((String)pwd)) {
                pwd = null;
            }
        }
        if (this.sharedCheckBox.isSelected()) {
            databaselink.setShared(true);
            databaselink.setAuthentificationPassword(new String(this.authenPasswordField.getPassword()));
            databaselink.setAuthentificationUsername(this.authenTextFeild.getText());
        } else {
            databaselink.setShared(false);
            databaselink.setAuthentificationPassword(null);
            databaselink.setAuthentificationUsername(null);
        }
        if (original == null || ModelUtil.areDifferent((Object)original, (Object)databaselink)) {
            databaselink.setPassword(pwd);
        }
        if ((verifier = this.m_verifier) != null) {
            verifier.verifyDblink();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACMD_FIXEDUSER.equals(e.getActionCommand())) {
            this.enableFixedUserControls();
        } else if (ACMD_SHARED.equals(e.getActionCommand())) {
            this.enableSharedControls();
        }
    }

    private void enableSharedControls() {
        if (this.sharedCheckBox.isSelected()) {
            this.authenUserNameLabel.setEnabled(true);
            this.authenPasswordLabel.setEnabled(true);
            this.authenTextFeild.setEnabled(true);
            this.authenPasswordField.setEnabled(true);
        } else {
            this.authenUserNameLabel.setEnabled(false);
            this.authenPasswordLabel.setEnabled(false);
            this.authenTextFeild.setEnabled(false);
            this.authenPasswordField.setEnabled(false);
        }
    }

    private void enableFixedUserControls() {
        if (this.fixedUserRadioBtn.isSelected()) {
            this.userNameTextField.setEnabled(true);
            this.passwordField.setEnabled(true);
            this.fixedUserNameLabel.setEnabled(true);
            this.fixedUserPasswordLabel.setEnabled(true);
        } else {
            this.userNameTextField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.fixedUserNameLabel.setEnabled(false);
            this.fixedUserPasswordLabel.setEnabled(false);
        }
    }

    private void getAllDblinkObjects(Schema refSchema) {
        try {
            SchemaObject[] objects = this.m_prov.listObjects(DATABASELINK_TYPES, refSchema);
            SchemaObject originalDblink = this.m_verifier.getOriginalObject();
            String originalDblinkName = originalDblink != null ? originalDblink.getName() : null;
            Schema originalSchema = originalDblink != null ? originalDblink.getSchema() : null;
            NonNullableComboBoxModel objectModel = new NonNullableComboBoxModel();
            for (int i = 0; i < objects.length; ++i) {
                if (originalDblink != null && "DATABASE LINK".equals(objects[i].getType()) && ModelUtil.areEqual((Object)originalSchema, (Object)refSchema) && ModelUtil.areEqual((Object)originalDblinkName, (Object)objects[i].getName())) continue;
                objectModel.addElement(objects[i].getName());
            }
            this.m_schemaMap.put(refSchema.getName(), objectModel);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (null == this.m_verifier || this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (null != this.m_dblink) {
            objectModel = new NonNullableComboBoxModel();
        }
        this.m_cmbObject.setModel(objectModel != null ? objectModel : EMPTY_MDL_OBJECT);
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (null != name) {
            for (int i = 0; i < DATABASELINK_TYPES.length; ++i) {
                try {
                    result = this.m_prov.getObject(DATABASELINK_TYPES[i], this.m_forSchema, name);
                    if (null == result) continue;
                    break;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private boolean populateObjectField() {
        Schema refSchema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(refSchema.getName())) {
            this.loadObjectModel(refSchema);
        }
        return this.setObjectModel(refSchema);
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof ReferenceID) {
            ReferenceID sRefID = (ReferenceID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = null == forSchema ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = sRefID.getName();
        }
    }

    private void loadObjectModel(Schema refSchema) {
        if (!this.m_loadingSchemas.containsKey(refSchema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(refSchema);
            this.m_loadingSchemas.put(refSchema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(refSchema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return UIArb.getString(859);
    }

    public String getProgressText() {
        return UIArb.getString(860);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (DatabaseLinkPanel.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), DatabaseLinkPanel.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(DatabaseLinkPanel.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressBar bar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (DatabaseLinkPanel.this.m_loadingSchemas.containsKey(this.m_schema.getName())) {
                    try {
                        DatabaseLinkPanel.this.getAllDblinkObjects(this.m_schema);
                    }
                    catch (Exception e) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
                    }
                    DatabaseLinkPanel.this.m_loadingSchemas.remove(this.m_schema.getName());
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }
}

