/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.util.ModelUtil;

public final class DBObjectNodeUtil {
    private DBObjectNodeUtil() {
    }

    public static boolean isNodeOfType(String type, Object node) {
        if (node instanceof DBObjectNode) {
            return type.equals(((DBObjectNode)node).getObjectType());
        }
        return false;
    }

    public static boolean isOnlineNodeOfType(String type, Object node) {
        if (DBObjectNodeUtil.isNodeOfType(type, node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static boolean isOnlineNode(Object node) {
        if (node instanceof DBObjectNode) {
            return ((DBObjectNode)node).getProviderIdentifier() instanceof String;
        }
        return false;
    }

    public static boolean isRelationNode(Object node) {
        if (node instanceof DBObjectNode) {
            String type = ((DBObjectNode)node).getObjectType();
            return "TABLE".equals(type) || "VIEW".equals(type) || "MATERIALIZED VIEW".equals(type);
        }
        return false;
    }

    public static boolean isRelationNode(Object node, boolean unwrapSynonym) {
        if (unwrapSynonym && DBObjectNodeUtil.isSynonymNode(node)) {
            try {
                DBObjectID refID;
                DBObject syn = ((DBObjectNode)node).getDBObject();
                if (syn instanceof Synonym && (refID = ((Synonym)syn).getReference()) != null) {
                    DBObject refObj = refID.resolveID();
                    return refObj instanceof Relation;
                }
            }
            catch (DBException e) {
                DBLog.getLogger().log(Level.WARNING, "Could not unwrap Synonym : " + e.getMessage());
            }
        }
        return DBObjectNodeUtil.isRelationNode(node);
    }

    public static boolean isSynonymNode(Object node) {
        if (node instanceof DBObjectNode) {
            String type = ((DBObjectNode)node).getObjectType();
            return "SYNONYM".equals(type) || "PUBLIC_SYNONYM".equals(type);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object node) {
        if (DBObjectNodeUtil.isRelationNode(node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object node, boolean unwrapSynonym) {
        if (DBObjectNodeUtil.isRelationNode(node, unwrapSynonym)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static String getStoreName(Object node) {
        if (node instanceof ConnectionStoreNode) {
            return ((ConnectionStoreNode)node).getStoreName();
        }
        if (node instanceof DatabaseNode) {
            return DBObjectNodeUtil.decode(((DatabaseNode)node).getConnectionName(), true);
        }
        return null;
    }

    public static String getConnectionName(Object node) {
        if (node instanceof DBObjectProviderNode) {
            Object ident = ((DBObjectProviderNode)node).getProviderIdentifier();
            if (ident instanceof String) {
                return (String)ident;
            }
        } else if (node instanceof DatabaseNode) {
            return DBObjectNodeUtil.decode(((DatabaseNode)node).getConnectionName(), false);
        }
        return null;
    }

    public static String decode(String name, boolean store) {
        int li;
        if (name.contains("%23")) {
            try {
                name = URLDecoder.decode(name, "utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        if ((li = name.lastIndexOf(35)) >= 0) {
            if (store) {
                return name.substring(0, li);
            }
            return name.substring(li + 1);
        }
        if (store) {
            return null;
        }
        return name;
    }

    public static <T extends Element> T getSelectedElement(Context context, Class<T> clz) {
        Element[] selection;
        T retval = null;
        if (context != null && (selection = context.getSelection()) != null && selection.length == 1) {
            retval = DBObjectNodeUtil.getElementOfType(selection[0], clz);
        }
        return retval;
    }

    public static <T extends Element> T getElementOfType(Element elem, Class<T> clz) {
        Element retval = null;
        if (elem != null) {
            if (clz.isAssignableFrom(elem.getClass())) {
                retval = elem;
            } else {
                URL[] compositeURLs = CompositeFileElementRegistry.getCompositeFileURLs((Element)elem);
                if (compositeURLs != null) {
                    for (URL url : compositeURLs) {
                        Node composite = NodeFactory.find((URL)url);
                        if (composite == null || !clz.isAssignableFrom(composite.getClass())) continue;
                        retval = composite;
                        break;
                    }
                }
            }
        }
        return (T)retval;
    }

    public static Schema getSchema(DBObjectTypeNode node, boolean defaultIfNone) {
        Schema schema = null;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            if (pro != null) {
                String schemaName = node.getSchemaName();
                if (schemaName != null && ModelUtil.hasLength((String)(schemaName = schemaName.trim()))) {
                    schema = new Schema(schemaName);
                }
                if (schema == null && defaultIfNone) {
                    schema = pro.getDefaultSchema();
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schema;
    }
}

