/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectNode
extends Node
implements DBObjectNode {
    private DBObjectID m_id;

    @Override
    public DBObject getDBObject() {
        DBObject retval = null;
        if (this.m_id != null) {
            try {
                retval = this.m_id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (retval == null && (retval = BaseDBObjectNode.findDBObject(this)) != null) {
            this.m_id = retval.getID();
        }
        return retval;
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    @Override
    public void init(DBObject obj, DBObjectProvider pro) {
    }

    static DBObject findDBObject(DBObjectNode node) {
        try {
            DBObjectProvider pro = node.getProvider();
            if (pro != null) {
                Schema s = DBObjectNodeUtil.getSchema(node, true);
                String objectType = node.getObjectType();
                String objectName = node.getObjectName();
                if ("PACKAGE BODY".equals(objectType)) {
                    objectType = "PACKAGE";
                } else if ("TYPE BODY".equals(objectType)) {
                    objectType = "TYPE";
                }
                if (objectType != null && objectType.startsWith("PUBLIC_")) {
                    objectType = objectType.replaceFirst("PUBLIC_", "");
                }
                if (pro instanceof BaseOracleDatabase && "MATERIALIZED VIEW LOG".equals(objectType)) {
                    String masterTableName = MaterializedViewLogBuilder.getMasterTableFromLogTable((DBObjectProvider)pro, (Schema)s, (String)objectName);
                    if (masterTableName != null) {
                        return pro.getObject(objectType, s, masterTableName);
                    }
                } else {
                    return pro.getObject(DBObjectCriteria.createCriteria((String)objectType, (Schema)s, (String)objectName));
                }
                return null;
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not retrieve object for node {0}: {1}", new Object[]{node.getURL(), dbe.getMessage()});
        }
        return null;
    }

    static DBObjectProvider findProvider(DBObjectNode node) {
        try {
            return DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not retrieve provider for node {0}: {1}", new Object[]{node.getURL(), dbe.getMessage()});
            return null;
        }
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(this.getObjectType());
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String name = this.getObjectName();
        if (ModelUtil.hasLength((String)name)) {
            return name;
        }
        return super.getShortLabel();
    }
}

