/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.TemplateObjectsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.Holder;

public class TemplateObjectChooser {
    private TemplateObjectChooser() {
    }

    public static SystemObject getTemplate(DBObjectProvider pro, String[] supportedTypes) {
        final Holder retval = new Holder();
        JEWTDialog dialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)UIArb.getString(980), (int)7);
        HashMap<String, DBObject> map = new HashMap<String, DBObject>();
        for (String type : supportedTypes) {
            map.put(type, pro.getDefaultTemplateForType(type));
        }
        final TemplateObjectChooserPanel panel = new TemplateObjectChooserPanel();
        panel.setPreferredSize(new Dimension(400, 300));
        panel.setHelpID("f1_dbchoosetemplateobject_html");
        panel.init(pro, map);
        dialog.setContent((Component)((Object)panel));
        dialog.setResizable(true);
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                HashMap map;
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && (map = panel.commit()) != null && map.size() > 0) {
                    for (DBObject so : map.values()) {
                        if (!(so instanceof SystemObject) || so instanceof Schema) continue;
                        retval.set((Object)((SystemObject)so));
                        break;
                    }
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        dialog.runDialog();
        return (SystemObject)retval.get();
    }

    private static class TemplateObjectChooserPanel
    extends DefaultTraversablePanel {
        private JWrappedLabel m_hint = new JWrappedLabel();
        private TemplateObjectsPanel m_templateObjectsPanel = new TemplateObjectsPanel(true);

        public TemplateObjectChooserPanel() {
            this.layoutComponents();
        }

        private void layoutComponents() {
            this.setLayout(new GridBagLayout());
            this.m_hint.setText(UIArb.getString(982));
            this.add((Component)this.m_hint, this.gbc(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10)));
            this.add((Component)((Object)this.m_templateObjectsPanel), this.gbc(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 10)));
        }

        private void init(DBObjectProvider pro, HashMap<String, DBObject> map) {
            if (!(pro instanceof Database)) {
                this.m_hint.setText(UIArb.getString(983));
                this.validate();
                this.repaint();
            }
            this.m_templateObjectsPanel.init(pro, map);
        }

        private HashMap<String, DBObject> commit() {
            return this.m_templateObjectsPanel.commit();
        }
    }
}

