/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectLabel;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

public class DBExceptionDialog
extends SQLErrorDialog {
    private JWrappedLabel m_desc = new JWrappedLabel();
    private JPanel m_panel = new JPanel();
    private ExPanel m_expPanel;

    protected DBExceptionDialog() {
    }

    private void setError(DBException error) {
        ArrayList<DBException> errs = new ArrayList<DBException>();
        while (error != null) {
            errs.add(error);
            error = error.getNextException();
        }
        if (errs.size() > 1) {
            this.m_desc.setText(UIArb.getString(99));
        } else {
            this.m_desc.setText(UIArb.getString(100));
        }
        this.setErrors(errs);
    }

    @Override
    protected Component getExceptionComponent() {
        this.m_panel.setLayout(new BorderLayout());
        return this.m_panel;
    }

    @Override
    protected void updateExceptionComponent(Exception e) {
        ExPanel newPanel = null;
        if (e instanceof CascadeRequiredException) {
            if (!(this.m_expPanel instanceof CascadeExceptionPanel)) {
                newPanel = new CascadeExceptionPanel();
            }
        } else if (e instanceof DBSQLException) {
            if (!(this.m_expPanel instanceof DBSQLExceptionPanel)) {
                newPanel = new DBSQLExceptionPanel();
            }
        } else if (e instanceof DBException && !(this.m_expPanel instanceof DBExceptionPanel)) {
            newPanel = new DBExceptionPanel();
        }
        if (newPanel != null) {
            if (this.m_expPanel != null) {
                this.m_panel.remove(this.m_expPanel);
            }
            this.m_expPanel = newPanel;
            this.m_panel.add((Component)this.m_expPanel, "Center");
        }
        this.m_expPanel.setException((DBException)((Object)e));
    }

    public static void showErrorDialog(Component parent, String title, DBException error) {
        DBExceptionDialog.showErrorDialog(parent, title, error, null);
    }

    public static void showErrorDialog(Component parent, String title, DBException error, String helpid) {
        DBExceptionDialog panel = new DBExceptionDialog();
        panel.setError(error);
        panel.runErrorDialog(parent, title, helpid);
    }

    public static boolean showConfirmDialog(Component parent, String title, DBException error) {
        return DBExceptionDialog.showConfirmDialog(parent, title, null, error);
    }

    public static boolean showConfirmDialog(Component parent, String title, String helpTopic, DBException error) {
        DBExceptionDialog panel = new DBExceptionDialog();
        panel.setError(error);
        return panel.runConfirmDialog(parent, title, helpTopic);
    }

    private class CascadeExceptionPanel
    extends ExPanel {
        private CascadeExceptionPanel() {
        }

        private Collection<DBObject> getObjects(CascadeRequiredException cre) {
            ArrayList<DBObject> retval = new ArrayList<DBObject>();
            while (cre != null) {
                retval.addAll(cre.getObjects());
                DBException next = cre.getNextException();
                cre = next instanceof CascadeRequiredException ? (CascadeRequiredException)((Object)next) : null;
            }
            return retval;
        }

        private Collection<DBObjectID> getDependents(CascadeRequiredException cre) {
            ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
            while (cre != null) {
                retval.addAll(cre.getDependents());
                DBException next = cre.getNextException();
                cre = next instanceof CascadeRequiredException ? (CascadeRequiredException)((Object)next) : null;
            }
            return retval;
        }

        @Override
        protected void setException(DBException dbe) {
            CascadeRequiredException cre = (CascadeRequiredException)((Object)dbe);
            this.removeAll();
            this.setLayout(new GridBagLayout());
            Insets gap = new Insets(0, 0, 0, 0);
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, gap, 0, 0);
            this.add((Component)new JWrappedLabel(UIArb.getString(DBExceptionDialog.this.isConfirm() ? 104 : 105)), gbc);
            ++gbc.gridy;
            gbc.weighty = 0.5;
            gbc.insets.top = 15;
            gbc.fill = 1;
            this.add(this.createListPanel(this.getObjects(cre), false), gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            Collection<DBObjectID> deps = this.getDependents(cre);
            if (deps != null) {
                ++gbc.gridy;
                this.add((Component)new JLabel(UIArb.getString(106)), gbc);
                ++gbc.gridy;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                this.add(this.createListPanel(deps, true), gbc);
                gbc.fill = 2;
                gbc.weighty = 0.0;
            }
            if (DBExceptionDialog.this.isConfirm()) {
                ++gbc.gridy;
                this.add((Component)new JLabel(UIArb.getString(107)), gbc);
            }
        }

        private Component createListPanel(Collection things, boolean fullName) {
            JPanel listPanel = new JPanel();
            listPanel.setLayout(new GridBagLayout());
            Insets i = new Insets(0, 5, 0, 5);
            TreeSet<DBObject> added = null;
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, i, 0, 0);
            for (Object thing : things) {
                DBObject obj = null;
                if (thing instanceof DBObjectID) {
                    try {
                        obj = ((DBObjectID)thing).resolveID();
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger().log(Level.WARNING, "Error resolving object id" + dbe.getMessage());
                    }
                } else {
                    obj = (DBObject)thing;
                }
                if (obj != null) {
                    while (obj instanceof SQLFragment) {
                        obj = obj.getParent();
                    }
                }
                if (obj == null) continue;
                if (added == null) {
                    added = new TreeSet<DBObject>(DBUtil.getNameComparator());
                }
                if (added.contains(obj)) continue;
                ++gbc.gridy;
                listPanel.add((Component)new DBObjectLabel(obj, fullName), gbc);
                added.add(obj);
                gbc.insets.top = 5;
            }
            ++gbc.gridy;
            ++gbc.gridx;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.weightx = 1.0;
            listPanel.add(Box.createGlue(), gbc);
            JScrollPane sp = new JScrollPane(listPanel, 20, 31);
            sp.setBorder(null);
            return sp;
        }
    }

    private class DBSQLExceptionPanel
    extends ExPanel {
        private JWrappedLabel m_label;
        private JLabel m_sqlDesc;
        private JTextArea m_sqlStatement;
        private JScrollPane m_sp;

        private DBSQLExceptionPanel() {
            this.m_label = new JWrappedLabel();
            this.m_sqlDesc = new JLabel();
            this.m_sqlStatement = new JTextArea();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0);
            this.add((Component)DBExceptionDialog.this.m_desc, gbc);
            ++gbc.gridy;
            this.add((Component)this.m_label, gbc);
            ++gbc.gridy;
            this.m_sqlDesc.setText(UIArb.getString(102));
            this.add((Component)this.m_sqlDesc, gbc);
            ++gbc.gridy;
            gbc.weightx = 0.5;
            gbc.weighty = 0.5;
            gbc.fill = 1;
            gbc.insets.bottom = 0;
            this.m_sqlStatement.setWrapStyleWord(true);
            this.m_sqlStatement.setEditable(false);
            this.m_sqlStatement.setBackground(this.getBackground());
            this.m_sp = new JScrollPane(this.m_sqlStatement);
            this.add((Component)this.m_sp, gbc);
        }

        @Override
        protected void setException(DBException dbe) {
            String msg = dbe.getMessage();
            msg = msg.replace("java.sql.SQLException:", "").trim();
            this.m_label.setText(msg);
            this.m_sqlStatement.setText(((DBSQLException)dbe).getSQL());
            this.m_sqlStatement.setCaretPosition(0);
        }
    }

    private class DBExceptionPanel
    extends ExPanel {
        private JWrappedLabel m_label;
        private DBObjectLabel m_object;

        private DBExceptionPanel() {
            this.m_label = new JWrappedLabel();
            this.m_object = new DBObjectLabel();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0);
            this.add((Component)DBExceptionDialog.this.m_desc, gbc);
            ++gbc.gridy;
            gbc.insets.left = 5;
            this.m_object.setHideWhenNull(true);
            this.add((Component)this.m_object, gbc);
            gbc.insets.left = 0;
            ++gbc.gridy;
            gbc.insets.bottom = 0;
            this.add((Component)this.m_label, gbc);
            ++gbc.gridy;
            gbc.weighty = 0.5;
            this.add(Box.createGlue(), gbc);
        }

        @Override
        protected void setException(DBException e) {
            StringBuilder message = new StringBuilder();
            DBObject obj = e.getObject();
            this.m_object.setVisible(true);
            this.m_object.setObject(obj, true);
            if (obj instanceof ViewColumn && e instanceof InvalidNameException && !ModelUtil.hasLength((String)obj.getName())) {
                SelectObject sel = null;
                try {
                    sel = (SelectObject)((ViewColumn)obj).getSelectObjectID().resolveID();
                    if (sel != null) {
                        this.m_object.setText(sel.getExpression().getSQLText());
                    }
                }
                catch (DBException f) {
                    // empty catch block
                }
            }
            message.append(e.getMessage());
            this.m_label.setText(message.toString());
            String txt = this.m_object.getText();
            this.m_object.setVisible(ModelUtil.hasLength((String)txt) && !txt.equals("" + null));
        }
    }

    private abstract class ExPanel
    extends JPanel {
        private ExPanel() {
        }

        protected abstract void setException(DBException var1);
    }
}

