/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.property.Metadata;

public class DBEditorFactoryRegistry {
    private List<Entry> m_factories = new ArrayList<Entry>();

    private DBEditorFactoryRegistry() {
    }

    private static List<Entry> getFactories() {
        DBCore core = DBCore.getInstance();
        DBEditorFactoryRegistry reg = (DBEditorFactoryRegistry)core.get(DBEditorFactoryRegistry.class);
        if (reg == null) {
            reg = new DBEditorFactoryRegistry();
            core.put((Object)reg);
        }
        return reg.m_factories;
    }

    private static DBEditorFactory findFactory(DBObjectProvider pro) {
        if (pro != null) {
            return DBEditorFactoryRegistry.findFactory(pro.getClass());
        }
        return null;
    }

    public static DBEditorFactory findFactory(Class<? extends DBObjectProvider> c) {
        for (Entry e : DBEditorFactoryRegistry.getFactories()) {
            if (!e.m_providerClass.isAssignableFrom(c)) continue;
            return e.m_factory;
        }
        return null;
    }

    public static void registerDBEditorFactory(Class providerClass, DBEditorFactory factory) {
        DBEditorFactoryRegistry.getFactories().add(0, new Entry(providerClass, factory));
    }

    public static DBEditorFactory getCreateFactory(DBObjectProvider pro, String dbObjectType) {
        DBEditorFactory retval = null;
        DBEditorFactory f = DBEditorFactoryRegistry.findFactory(pro);
        if (f != null && (f.isCreateSupported(dbObjectType) || pro.isNewFromTemplateType(dbObjectType))) {
            retval = f;
        }
        return retval;
    }

    public static DBEditorFactory getCreateFactory(DBObjectTypeNode node) {
        Object proID;
        String type;
        DBEditorFactory retval = null;
        if (node != null && (type = node.getObjectType()) != null && (proID = node.getProviderIdentifier()) != null) {
            try {
                retval = DBEditorFactoryRegistry.getCreateFactory(DBObjectProviderFactory.findOrCreateProvider((Object)proID), type);
            }
            catch (DBException dbe) {
                DBLog.getLogger(DBEditorFactoryRegistry.class).log(Level.FINE, "Couldn't get provider: " + dbe.getMessage());
            }
        }
        return retval;
    }

    public static DBEditorFactory getEditFactory(SchemaObject obj, DBObjectProvider pro) {
        return DBEditorFactoryRegistry.getEditFactory((DBObject)obj, pro);
    }

    public static DBEditorFactory getEditFactory(DBObject obj, DBObjectProvider pro) {
        DBEditorFactory retval = null;
        DBEditorFactory f = DBEditorFactoryRegistry.findFactory(pro);
        if (f != null && f.canEditDBObject(obj, pro)) {
            retval = f;
        }
        return retval;
    }

    public static DBEditorFactory getEditFactory(DBObjectNode node) {
        String type;
        if (node.getProvider() != null && node.getObjectType() != null && (type = node.getObjectType()) != null) {
            Class clz;
            if (type.startsWith("PUBLIC")) {
                type = type.replaceFirst("PUBLIC", "").trim();
            }
            if ((clz = Metadata.getInstance().getObjectClass(type)) != null) {
                try {
                    DBObject obj = (DBObject)clz.newInstance();
                    return DBEditorFactoryRegistry.getEditFactory(obj, node.getProvider());
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static class Entry {
        private Class m_providerClass;
        private DBEditorFactory m_factory;

        Entry(Class dbClass, DBEditorFactory factory) {
            this.m_providerClass = dbClass;
            this.m_factory = factory;
        }
    }
}

