/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;

public class CascadeConfirmDialog
extends DBExceptionDialog {
    private CascadeConfirmDialog() {
    }

    public static boolean confirmCascade(Component parent, CascadeRequiredException cre, String title, String helpTopic) {
        return CascadeConfirmDialog.showConfirmDialog(parent, title, helpTopic, (DBException)cre);
    }

    public static boolean updateObjects(Component parent, String title, DBObjectProvider pro, SystemObject[] oldObjects, SystemObject[] newObjects) {
        return CascadeConfirmDialog.updateObjects(parent, title, pro, oldObjects, newObjects, false);
    }

    public static boolean updateObjects(Component parent, String title, DBObjectProvider pro, SystemObject[] oldObjects, SystemObject[] newObjects, boolean replace) {
        if (parent == null) {
            parent = DBMessageDialog.getDialogParent();
        }
        if (title == null) {
            title = UIArb.getString(117);
        }
        try {
            ResultSet rs = pro.getDiffEngine().diff((Object[])oldObjects, (Object[])newObjects).getResult();
            try {
                pro.updateObjects((Difference)rs, replace, false);
                return true;
            }
            catch (CascadeRequiredException cre) {
                if (CascadeConfirmDialog.confirmCascade(parent, cre, title, null)) {
                    pro.updateObjects((Difference)rs, replace, true);
                    return true;
                }
            }
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(parent, title, dbe);
        }
        return false;
    }
}

