/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.ide.db.dialogs.AbstractDBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.panels.TraversableProxy;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;

public class BaseDBEditorFactory
extends AbstractDBEditorFactory {
    private Map<String, Object> m_libraries = new HashMap<String, Object>();

    protected BaseDBEditorFactory() {
    }

    protected PanelLibrary getPanelLibrary(String dbObjectType) {
        Object obj = this.m_libraries.get(dbObjectType);
        if (obj instanceof Class) {
            try {
                PanelLibrary lib = (PanelLibrary)((Class)obj).newInstance();
                this.initializeLibrary(lib);
                this.m_libraries.put(dbObjectType, lib);
                return lib;
            }
            catch (Exception e) {
                DBLog.logStackTrace((Throwable)e);
            }
        } else if (obj instanceof PanelLibrary) {
            return (PanelLibrary)obj;
        }
        return null;
    }

    protected void initializeLibrary(PanelLibrary lib) {
    }

    private boolean purgeLibraryCache() {
        for (String key : this.m_libraries.keySet()) {
            Object obj = this.m_libraries.get(key);
            if (!(obj instanceof PanelLibrary)) continue;
            this.m_libraries.put(key, obj.getClass());
        }
        return true;
    }

    protected void registerLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        this.m_libraries.put(dbObjectType, libClass);
    }

    protected void unregisterLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        Object obj = this.m_libraries.get(dbObjectType);
        boolean match = false;
        if (obj instanceof Class) {
            match = obj.equals(libClass);
        } else if (obj != null && libClass != null) {
            match = libClass.isAssignableFrom(obj.getClass());
        }
        if (match) {
            this.m_libraries.remove(dbObjectType);
        } else {
            DBLog.getLogger((Object)this).warning("Cannot remove library for " + dbObjectType + " as libClass doesn't match.");
        }
    }

    @Override
    public String[] listSupportedTypes() {
        return this.m_libraries.keySet().toArray(new String[this.m_libraries.size()]);
    }

    @Override
    public boolean isCreateSupported(String dbObjectType) {
        return this.m_libraries.containsKey(dbObjectType);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        return this.m_libraries.containsKey(dbObjectType) && this.supportsObjectType(dbObjectType, pro);
    }

    protected boolean supportsObjectType(String dbObjectType, DBObjectProvider pro) {
        return pro.supportsObjectType(dbObjectType);
    }

    @Override
    public final DBObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType, DBObject parent, boolean commitToProvider) {
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null) {
            DBObject obj;
            if (Metadata.getInstance().isSchemaObject(dbObjectType)) {
                try {
                    schema = schema == null ? pro.getDefaultSchema() : schema;
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning("Couldn't get default schema: " + dbe.getMessage());
                }
            }
            if (parent != null) {
                parent = parent.copyTo(null, true);
            }
            if (this.createDBObject(obj = lib.getObjectForCreate(schema, pro, parent), pro, commitToProvider)) {
                return obj;
            }
        }
        return null;
    }

    @Override
    protected <T extends DBObject> T createDBObject(Schema schema, DBObjectProvider pro, T template, DBObject parent, boolean commitToProvider) {
        PanelLibrary lib = this.getPanelLibrary(template.getType());
        if (lib != null) {
            try {
                schema = schema == null ? pro.getDefaultSchema() : schema;
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).warning("Couldn't get default schema: " + dbe.getMessage());
            }
            if (parent != null) {
                parent = parent.copyTo(null, true);
            }
            DBObject obj = pro.getObjectFactory().newObject(template, (DBObject)(parent == null ? schema : parent));
            lib.makeNameUnique(obj, schema, pro, parent);
            if (this.createDBObject(obj, pro, commitToProvider)) {
                return (T)obj;
            }
        }
        return null;
    }

    private boolean checkPrivilege(DBObject newObj, DBObjectProvider pro, boolean edit, PanelLibrary lib) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro, boolean commitToProvider) {
        String type = newObj.getType();
        String timestampKey = type + "EditDialog";
        try {
            DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
            PanelLibrary lib = this.getPanelLibrary(type);
            if (lib != null && this.checkPrivilege(newObj, pro, false, lib)) {
                Map<String, Class> verifiers;
                Namespace ns;
                Traversable mainPanel;
                List<Navigable> navs;
                if (newObj.getName() == null) {
                    lib.makeNameUnique(newObj, DBUtil.getSchema((DBObject)newObj), pro, newObj.getParent());
                }
                if ((navs = lib.getCreateNavigables(newObj, pro)) != null && (mainPanel = lib.getMainDialogPanel(newObj, pro, null, navs.toArray(new Navigable[navs.size()]))) != null && (ns = this.createNamespace(pro, newObj, null, verifiers = lib.getCreateVerifiers(), false, commitToProvider)) != null) {
                    ns.put("PANEL_LIBRARY", (Object)lib);
                    String dialogName = "create" + type;
                    boolean bl = this.launchDialog(ns, lib.getCreateTitle(), mainPanel, lib, lib.getSize(false), dialogName);
                    return bl;
                }
            }
        }
        finally {
            DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
        }
        return false;
    }

    @Override
    public boolean canEditDBObject(DBObject obj, DBObjectProvider pro) {
        String dbObjectType;
        PanelLibrary lib;
        boolean retval = false;
        if (obj != null && (lib = this.getPanelLibrary(dbObjectType = obj.getType())) != null && lib.canEditObject(obj, pro)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child, boolean commitToProvider) {
        String type = obj.getType();
        String timestampKey = type + "EditDialog";
        try {
            Map<String, Class> verifiers;
            Namespace ns;
            Traversable mainPanel;
            List<Navigable> navs;
            DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
            boolean retval = false;
            PanelLibrary lib = this.getPanelLibrary(type);
            if (lib != null && this.checkPrivilege(obj, pro, true, lib) && (navs = lib.getEditNavigables(obj, pro)) != null && (mainPanel = lib.getMainDialogPanel(obj, pro, child, navs.toArray(new Navigable[navs.size()]))) != null && (ns = this.createNamespace(pro, obj, child, verifiers = lib.getEditVerifiers(), true, commitToProvider)) != null) {
                ns.put("PANEL_LIBRARY", (Object)lib);
                if (lib.canReplaceByDefault()) {
                    ns.put("allowReplaceForUpdate", (Object)true);
                }
                String dialogName = "edit" + type;
                boolean bl = this.launchDialog(ns, lib.getEditTitle(), mainPanel, lib, lib.getSize(true), dialogName);
                return bl;
            }
        }
        finally {
            DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
        }
        return false;
    }

    @Override
    public String getCreateLabel(String dbObjectType) {
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null) {
            return lib.getCreateText();
        }
        return null;
    }

    protected Namespace createNamespace(DBObjectProvider provider, DBObject object, DBObject child, Map<String, Class> verifiers, boolean isEdit, boolean commitToProvider) {
        DBObject copy = null;
        Namespace data = new Namespace();
        data.put("DBObjectProvider", (Object)provider);
        data.put("COMMIT_TO_PROVIDER_KEY", (Object)commitToProvider);
        if (object != null) {
            DBObject copyDefault;
            if (object instanceof SystemObject) {
                if (isEdit) {
                    copy = object.copyTo(null, true);
                    data.put("OriginalObject", (Object)object);
                    data.put("NewObject", (Object)copy);
                } else {
                    data.put("NewObject", (Object)object);
                }
            } else {
                DBObject childCopy;
                data.put("standAlone", (Object)true);
                DBObject parent = object.getParent();
                if (parent instanceof SystemObject) {
                    DBObjectID parID = parent.getID();
                    if (parID instanceof TemporaryObjectID) {
                        try {
                            data.put("NewObject", (Object)parent);
                            copy = parent;
                            data.put("OriginalObject", (Object)((TemporaryObjectID)parent.getID()).resolveOriginalID());
                        }
                        catch (DBException e) {
                            DBExceptionDialog.showErrorDialog(null, null, e);
                        }
                    } else if (isEdit) {
                        copy = parent.copyTo(null, true);
                        data.put("NewObject", (Object)copy);
                        data.put("OriginalObject", (Object)parent);
                    } else {
                        throw new IllegalStateException("Must create child objects on a temporary copy of their parent.");
                    }
                }
                if ((childCopy = DBUtil.findChildInCopy((DBObject)parent, (DBObject)copy, (DBObject)object)) == null) {
                    if (isEdit) {
                        throw new IllegalStateException("Copy of object to edit not found, was parent object correct?");
                    }
                    data.put("NewChildObject", (Object)object);
                } else {
                    data.put("NewChildObject", (Object)childCopy);
                }
            }
            if (child != null && copy != null && (copyDefault = DBUtil.findChildInCopy((DBObject)object, (DBObject)copy, (DBObject)child)) != null) {
                data.put("DefaultChild", (Object)copyDefault);
            }
            boolean updatable = isEdit ? this.canUpdateObject(object, provider) : true;
            data.put("DBObjectIsEditable", (Object)updatable);
            Schema schema = DBUtil.getSchema((DBObject)object);
            data.put("Schema", (Object)schema);
            if (verifiers != null) {
                for (String key : verifiers.keySet()) {
                    Class cls = verifiers.get(key);
                    try {
                        Object obj = cls.newInstance();
                        if (obj instanceof Verifier) {
                            SchemaObject so = object instanceof SchemaObject ? (SchemaObject)object : DBUtil.getSchemaObject((DBObject)object);
                            Verifier verifier = (Verifier)obj;
                            if (copy == null) {
                                verifier.initializeVerifier(provider, null, so);
                            } else {
                                SchemaObject copySo = copy instanceof SchemaObject ? (SchemaObject)copy : DBUtil.getSchemaObject((DBObject)copy);
                                verifier.initializeVerifier(provider, so, copySo);
                            }
                            verifier.setEditable(updatable);
                        }
                        data.put(key, obj);
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return data;
    }

    protected boolean canUpdateObject(DBObject obj, DBObjectProvider pro) {
        return true;
    }

    private boolean launchDialog(Namespace data, String title, Traversable panel, PanelLibrary lib, Dimension size, String dialogName) {
        Component initialFocus;
        Component parent = DBMessageDialog.getDialogParent();
        TraversableProxy proxyPanel = new TraversableProxy(panel);
        TDialogLauncher launcher = new TDialogLauncher(parent, title, (Traversable)proxyPanel, data);
        if (size != null) {
            launcher.setInitialSize(size);
        }
        JEWTDialog dialog = launcher.initDialog();
        dialog.setName(dialogName);
        ValidationMessagePane validationPane = new ValidationMessagePane();
        dialog.setValidationMessagePane(validationPane);
        data.put("VMP", (Object)validationPane);
        proxyPanel.enable();
        Boolean updateable = (Boolean)data.get("DBObjectIsEditable");
        if (updateable != null && !updateable.booleanValue()) {
            dialog.setOKButtonEnabled(false);
        }
        if ((initialFocus = lib.getInitialFocus(panel)) != null) {
            dialog.setInitialFocus(initialFocus);
        }
        return launcher.showDialog();
    }
}

