/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

abstract class AbstractDBEditorFactory
implements DBEditorFactory {
    AbstractDBEditorFactory() {
    }

    @Override
    public abstract boolean isCreateSupported(String var1);

    @Override
    public abstract String[] listSupportedTypes();

    @Override
    public abstract String getCreateLabel(String var1);

    @Override
    public abstract boolean canCreateDBObject(Schema var1, DBObjectProvider var2, String var3);

    @Override
    public final boolean canCreateDBObject(DBObjectTypeNode node) {
        boolean retval = false;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            if (pro != null) {
                Schema schema = DBObjectNodeUtil.getSchema(node, false);
                retval = this.canCreateDBObject(schema, pro, node.getObjectType());
            }
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, dbe);
        }
        return retval;
    }

    @Override
    public final SchemaObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        if (!Metadata.getInstance().isSchemaObject(dbObjectType)) {
            throw new IllegalArgumentException(dbObjectType + " is not a valid SchemaObject type");
        }
        return (SchemaObject)this.createDBObject(schema, pro, dbObjectType, null, true);
    }

    @Override
    public final SchemaObject createDBObject(DBObjectTypeNode node) {
        SchemaObject obj = null;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            Schema schema = DBObjectNodeUtil.getSchema(node, true);
            obj = this.createDBObject(schema, pro, node.getObjectType());
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, dbe);
        }
        return obj;
    }

    @Override
    public abstract DBObject createDBObject(Schema var1, DBObjectProvider var2, String var3, DBObject var4, boolean var5);

    @Override
    public final <T extends SystemObject> T createDBObject(Schema schema, DBObjectProvider pro, T template, boolean commitToProvider) {
        return this.createDBObject(schema, pro, template, (DBObject)null, commitToProvider);
    }

    @Override
    public final <T extends DBObject> T createDBObject(DBObjectProvider pro, T template, DBObject parent, boolean commitToProvider) {
        return this.createDBObject(DBUtil.getSchema((DBObject)parent), pro, template, parent, commitToProvider);
    }

    protected abstract <T extends DBObject> T createDBObject(Schema var1, DBObjectProvider var2, T var3, DBObject var4, boolean var5);

    @Override
    public final DBObject createDBObject(DBObjectNode node, String dbObjectType) {
        DBObjectProvider pro = node.getProvider();
        DBObject parent = node.getDBObject();
        Schema schema = DBObjectNodeUtil.getSchema(node, true);
        return this.createDBObject(schema, pro, dbObjectType, parent, true);
    }

    @Override
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro) {
        return this.createDBObject(newObj, pro, true);
    }

    @Override
    public abstract boolean createDBObject(DBObject var1, DBObjectProvider var2, boolean var3);

    @Override
    public abstract boolean canEditDBObject(DBObject var1, DBObjectProvider var2);

    @Override
    public final boolean canEditDBObject(SchemaObject obj, DBObjectProvider pro) {
        return this.canEditDBObject((DBObject)obj, pro);
    }

    @Override
    @Deprecated
    public final boolean canEditDBObject(DBObjectNode node) {
        return this.canEditDBObject(node.getDBObject(), node.getProvider());
    }

    @Override
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro) {
        return this.editDBObject(obj, pro, true);
    }

    @Override
    public final boolean editDBObject(SchemaObject obj, DBObjectProvider pro) {
        return this.editDBObject((DBObject)obj, pro, true);
    }

    @Override
    public boolean editDBObject(DBObject obj, DBObjectProvider pro, boolean commitToProvider) {
        return this.editDBObject(obj, pro, null, commitToProvider);
    }

    @Override
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child) {
        return this.editDBObject(obj, pro, child, true);
    }

    @Override
    public final boolean editDBObject(DBObjectNode node) {
        return this.editDBObject(node.getDBObject(), node.getProvider());
    }

    @Override
    public abstract boolean editDBObject(DBObject var1, DBObjectProvider var2, DBObject var3, boolean var4);
}

