/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;

public class TablePicker
extends AbstractPicker {
    private DBObjectProvider m_prov;
    private Schema m_schema;
    private Verifier m_verifier;

    public TablePicker() {
        Handler handler = new Handler();
        super.setEncoder((AbstractPicker.PickerValueEncoder)handler);
        super.setValidator((AbstractPicker.PickerResultValidator)handler);
        super.setEditor((ComboBoxEditor)new Editor(this.getEditor()));
        super.setRenderer((ListCellRenderer)new DBObjectRenderer());
    }

    public void setProvider(DBObjectProvider prov) {
        this.m_prov = prov;
    }

    public DBObjectProvider getProvider() {
        return this.m_prov;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public void setVerifier(Verifier verifier) {
        this.m_verifier = verifier;
    }

    public Verifier getVerifier() {
        return this.m_verifier;
    }

    protected void doBrowse() {
    }

    public void setSelectedItem(Object value) {
        if (value instanceof String) {
            MutableComboBoxModel model = (MutableComboBoxModel)this.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                String s = (String)model.getElementAt(i);
                if (!s.equals(value)) continue;
                value = s;
                break;
            }
        }
        super.setSelectedItem(value);
    }

    public Table getTable() throws TraversalException {
        String tableName = (String)this.getSelectedItem();
        Table table = null;
        if (null != this.m_schema) {
            try {
                table = (Table)this.m_prov.getObject("TABLE", this.m_schema, tableName);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (null == table) {
            throw new TraversalException(null, UIArb.getString(518));
        }
        return table;
    }

    private class Editor
    implements ComboBoxEditor {
        private ComboBoxEditor m_editor;

        public Editor(ComboBoxEditor i_editor) {
            this.m_editor = i_editor;
        }

        @Override
        public Component getEditorComponent() {
            return this.m_editor.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            Component fieldEditor;
            this.m_editor.setItem(anObject);
            if (anObject != null && (fieldEditor = this.m_editor.getEditorComponent()) instanceof JTextField && TablePicker.this.m_prov != null) {
                String name = null;
                name = anObject instanceof DBObject ? TablePicker.this.m_prov.getExternalName(((DBObject)anObject).getName()) : anObject.toString();
                ((JTextField)fieldEditor).setText(name);
            }
        }

        @Override
        public Object getItem() {
            return this.m_editor.getItem();
        }

        @Override
        public void selectAll() {
            this.m_editor.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.m_editor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.m_editor.removeActionListener(l);
        }
    }

    private class Handler
    implements AbstractPicker.PickerValueEncoder,
    AbstractPicker.PickerResultValidator {
        private Handler() {
        }

        public Object encodeValue(Object value) {
            Object result = null;
            if (value instanceof Table) {
                result = value;
            }
            return result;
        }

        public boolean isResultValid(Object result) {
            return result instanceof Table;
        }

        public String getInvalidValueMsg(Object value) {
            return "";
        }
    }
}

