/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public class SearchableTextArea
extends JPanel {
    public static final String PREFS_KEY = "oracle.ide.db.controls.SearchableTextArea";
    public static final String PREFS_CASE_KEY = "oracle.ide.db.controls.SearchableTextArea.CASE";
    private final SearchField m_searchField = new SearchField();
    private final JTextArea m_textArea = new JTextArea();
    boolean m_textHadFocus = false;

    public SearchableTextArea() {
        this((String)null);
    }

    public SearchableTextArea(String text) {
        this.m_textArea.setText(text);
        this.m_textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchableTextArea.this.m_textHadFocus = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_searchField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalStrut(200), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.m_textArea, 20, 31), new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(4, 0, 0, 0), 0, 0));
        this.m_searchField.setStyle(SearchField.Style.FIND);
        this.m_searchField.setAutoFind(true);
        this.m_searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                if (se.isFromClear() || !ModelUtil.hasLength((String)se.getSearchText())) {
                    SearchableTextArea.this.m_textArea.setSelectionEnd(SearchableTextArea.this.m_textArea.getSelectionStart() - 1);
                } else {
                    boolean forward = se.getDirection() == SearchEvent.Direction.FORWARD;
                    boolean matchCase = false;
                    String textToFind = se.getSearchText();
                    String textToSearch = SearchableTextArea.this.m_textArea.getText();
                    if (!matchCase) {
                        textToFind = textToFind.toUpperCase();
                        textToSearch = textToSearch.toUpperCase();
                    }
                    int searchIndex = -1;
                    if (forward) {
                        int nudge = se.isTriggeredByKeypress() ? 0 : 1;
                        int start = SearchableTextArea.this.m_textArea.getSelectionStart();
                        if (start < 0) {
                            start = SearchableTextArea.this.m_textArea.getCaretPosition();
                        }
                        searchIndex = textToSearch.indexOf(textToFind, start + nudge);
                    } else {
                        int start = SearchableTextArea.this.m_textArea.getSelectionStart() - 1;
                        if (start < 0) {
                            start = SearchableTextArea.this.m_textArea.getCaretPosition() - 1;
                        }
                        searchIndex = start >= 0 ? textToSearch.lastIndexOf(textToFind, start) : -1;
                    }
                    if (searchIndex == -1 && textToSearch.indexOf(textToFind) != -1) {
                        searchIndex = forward ? textToSearch.indexOf(textToFind) : textToSearch.lastIndexOf(textToFind);
                    }
                    if (searchIndex >= 0) {
                        SearchableTextArea.this.m_textArea.setCaretPosition(searchIndex);
                        SearchableTextArea.this.m_textArea.setSelectionStart(searchIndex);
                        SearchableTextArea.this.m_textArea.setSelectionEnd(searchIndex + textToFind.length());
                    } else {
                        int pos = 0;
                        if (forward) {
                            pos = textToSearch.length();
                        }
                        SearchableTextArea.this.m_textArea.setCaretPosition(pos);
                        SearchableTextArea.this.m_textArea.setSelectionStart(pos);
                        SearchableTextArea.this.m_textArea.setSelectionEnd(pos);
                    }
                    SearchableTextArea.this.m_textArea.getCaret().setSelectionVisible(true);
                }
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this.m_textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 2 && e.getKeyCode() == 70) {
                    SearchableTextArea.this.m_searchField.setText(SearchableTextArea.this.m_textArea.getSelectedText());
                    SearchableTextArea.this.m_searchField.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public JTextComponent getTextComponent() {
        return this.m_textArea;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_searchField.setName(name + "Search");
        this.m_textArea.setName(name + "Text");
    }
}

