/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import oracle.ide.dialogs.ProgressBar;

public class RestartableProgressBar
implements Runnable {
    private Component _parent;
    private boolean _useBusyBar;
    private String _dialogTitle;
    private ProgressBar m_progressBar;
    private ProgressBar m_dummyBar;
    private int m_status;
    private static final int STATUS_NOT_STARTED = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_COMPLETE = 2;

    public RestartableProgressBar(Component parent, String dialogTitle, Runnable runnable, boolean useBusyBar) {
        this._parent = parent;
        this._dialogTitle = dialogTitle;
        this._useBusyBar = useBusyBar;
        this.m_progressBar = new ProgressBar(parent, dialogTitle, runnable, useBusyBar);
        this.m_status = 0;
    }

    public void setCancelable(boolean canCancel) {
        this.m_progressBar.setCancelable(canCancel);
    }

    public boolean isCancelable() {
        return this.m_progressBar.isCancelable();
    }

    public void start(String initialText, String stepText) {
        int status = this.getStatus();
        if (0 == status) {
            this.setThreadComplete(false);
            this.m_progressBar.start(initialText, stepText);
            if (!this.m_progressBar.hasUserCancelled()) {
                this.setDoneStatus();
            }
        } else if (1 == status) {
            this.m_dummyBar = new ProgressBar(this._parent, this._dialogTitle, (Runnable)this, this._useBusyBar);
            this.m_dummyBar.start(initialText, null);
            if (!this.m_dummyBar.hasUserCancelled()) {
                this.m_dummyBar.setDoneStatus();
            }
            this.m_dummyBar = null;
        }
    }

    public void updateProgress(int completionStatus, String progressText, String stepText) {
        this.m_progressBar.updateProgress(completionStatus, progressText, stepText);
    }

    public void updateProgress(String progressText, String stepText) {
        this.m_progressBar.updateProgress(progressText, stepText);
    }

    public boolean hasUserCancelled() {
        return 1 == this.getStatus() && this.m_progressBar.hasUserCancelled();
    }

    public void sleepForUIToRepaint() {
        this.m_progressBar.sleepForUIToRepaint();
    }

    public void waitUntilDone() {
        this.m_progressBar.waitUntilDone();
    }

    public void setDoneStatus() {
        this.m_progressBar.setDoneStatus();
        this.setThreadComplete(true);
    }

    @Override
    public void run() {
        this.m_progressBar.waitUntilDone();
        this.m_dummyBar.setDoneStatus();
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public synchronized void setThreadComplete(boolean complete) {
        this.m_status = complete ? 2 : 1;
    }
}

