/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public class NameAndSchemaAdvancedEditor<T extends SchemaObject>
extends NameAndSchemaEditor<T>
implements PanelLibrary.HeaderPanel {
    protected static final String SIMPLE = "Simple";
    private JCheckBox m_advanced = new JCheckBox();
    private boolean m_enteredOnce = false;
    private PanelLibrary m_panels;

    public NameAndSchemaAdvancedEditor() {
        this.m_advanced.setSelected(false);
        this.getHelper().registerComponent(this.m_advanced, UIArb.getString(544), "Advanced", null);
        this.add(this.m_advanced, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_advanced.addActionListener(this);
    }

    @Override
    protected void initialisePanel() {
        block7: {
            super.initialisePanel();
            if (!this.m_enteredOnce) {
                this.m_enteredOnce = true;
                this.m_panels = (PanelLibrary)this.getDataContext().find("PANEL_LIBRARY");
                if (this.isEditing() || !ModelUtil.hasNonNullElement((Object[])this.getSimpleNavigables())) {
                    this.m_advanced.setVisible(false);
                } else {
                    this.m_advanced.setVisible(true);
                    if (this.getAdvancedPreference()) {
                        this.m_advanced.setSelected(true);
                    } else {
                        this.m_advanced.setSelected(false);
                        try {
                            this.showSimplePanel();
                        }
                        catch (TraversalException te) {
                            DBLog.getLogger().log(Level.WARNING, "traversal exception on init", te);
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)te.getMessage());
                        }
                    }
                }
            }
        }
    }

    protected void showSimplePanel() throws TraversalException {
        this.changePanels(SIMPLE, this.getSimpleNavigables());
    }

    protected final Navigable[] getSimpleNavigables() {
        List<Navigable> navs = this.getPanelLibrary().getSimpleNavigables();
        return navs == null ? new Navigable[]{} : navs.toArray(new Navigable[navs.size()]);
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.changePanels("DEFAULT_PANEL", null);
    }

    protected boolean isAdvancedLayout() {
        return this.m_advanced.isSelected();
    }

    protected PanelLibrary getPanelLibrary() {
        if (!this.m_enteredOnce) {
            throw new IllegalStateException("can't get panel library until onEntry has been called");
        }
        return this.m_panels;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_advanced) {
            if (this.m_advanced.isSelected()) {
                try {
                    this.showAdvancedPanel();
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(false);
                }
            } else {
                try {
                    this.showSimplePanel();
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(true);
                }
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    private boolean getAdvancedPreference() {
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null) {
            return prefs.isAdvancedView(this.getPanelLibrary().getType());
        }
        return false;
    }

    @Override
    public void validatePanelChange(TraversableContext data) throws TraversalException {
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null) {
            prefs.setAdvancedView(this.getPanelLibrary().getType(), this.m_advanced.isSelected());
        }
    }

    @Override
    protected GridBagConstraints getTemplateHintGridBagConstants() {
        return new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 15), 0, 0);
    }
}

