/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class DBObjectSourcePicker
extends DBObjectPicker
implements Runnable {
    private String[] m_types;
    private DBObjectProvider m_pro;
    private Schema m_schema;
    private String m_filter;
    private ProgressBar m_bar;
    private JPanel m_component = new JPanel();
    private JWrappedLabel m_emptyLabel;

    public DBObjectSourcePicker(DBObjectProvider pro, boolean showChildren, boolean removeOnShuttle) {
        super(showChildren, removeOnShuttle);
        this.m_pro = pro;
        this.showEmptyUI();
    }

    private void showEmptyUI() {
        if (this.m_emptyLabel == null) {
            this.m_emptyLabel = new JWrappedLabel(UIArb.getString(236));
            this.m_component.removeAll();
            this.m_component.setLayout(new GridBagLayout());
            this.m_component.setBorder(BorderFactory.createEtchedBorder());
            this.m_component.add((Component)this.m_emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.m_component.validate();
        }
    }

    public void setProvider(DBObjectProvider pro) {
        if (this.m_pro != pro) {
            this.m_pro = pro;
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
            this.showEmptyUI();
        }
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void setTypes(String[] types) {
        this.m_types = types;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public boolean setFilter(String filter) {
        if (!ModelUtil.areEqual((Object)this.m_filter, (Object)filter)) {
            this.m_filter = filter;
            return true;
        }
        return false;
    }

    public void query() {
        boolean queried = false;
        if (this.m_pro instanceof Database) {
            this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(234), (Runnable)this, true);
            this.m_bar.start(UIArb.getString(235), null);
            if (this.m_bar.hasUserCancelled()) {
                if (this.m_pro instanceof AbstractDatabase) {
                    ((AbstractDatabase)this.m_pro).cancelStatement();
                }
            } else {
                queried = true;
            }
            this.m_bar = null;
        } else {
            this.doQuery();
            queried = true;
        }
        if (queried) {
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
            if (this.m_emptyLabel != null) {
                this.m_component.removeAll();
                DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
                Component tree = super.getComponent();
                reshelp.setName(tree, "Tree");
                this.m_component.add(tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_component.setBorder(null);
                this.m_component.validate();
                this.m_emptyLabel = null;
            }
        }
    }

    protected String getComponentNamePrefix() {
        return "DBObjectSourcePicker";
    }

    private void doQuery() {
        block11: {
            try {
                if (this.m_types != null && this.m_types.length > 0) {
                    ProgressBar bar = this.m_bar;
                    if (bar != null && bar.hasUserCancelled()) {
                        return;
                    }
                    ArrayList<String> sysObjTypes = new ArrayList<String>();
                    ArrayList<String> schemaObjTypes = new ArrayList<String>();
                    for (String type : this.m_types) {
                        if (Metadata.getInstance().isTypeOf(SchemaObject.class, type)) {
                            schemaObjTypes.add(type);
                            continue;
                        }
                        if (type.equals("SCHEMA")) continue;
                        sysObjTypes.add(type);
                    }
                    String[] sysTypes = sysObjTypes.toArray(new String[sysObjTypes.size()]);
                    String[] soTypes = schemaObjTypes.toArray(new String[schemaObjTypes.size()]);
                    DBObjectCriteria dbcSchemaObjs = DBObjectCriteria.createCriteria((String[])soTypes, (Schema)this.m_schema, (String)this.m_filter);
                    Collection listSchemaObjs = this.m_pro.listObjects(dbcSchemaObjs);
                    if (sysTypes.length > 0) {
                        DBObjectCriteria dbcSystemObjs = DBObjectCriteria.createCriteria((String[])sysTypes, null, (String)this.m_filter);
                        Collection listSysObjs = this.m_pro.listObjects(dbcSystemObjs);
                        listSchemaObjs.addAll(listSysObjs);
                    }
                    SystemObject[] objs = listSchemaObjs.toArray(new SystemObject[listSchemaObjs.size()]);
                    if (bar != null && bar.hasUserCancelled()) {
                        return;
                    }
                    objs = this.filterAndSort(objs);
                    this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
                    for (int i = 0; i < objs.length; ++i) {
                        if (bar != null && bar.hasUserCancelled()) {
                            return;
                        }
                        DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode((DBObject)objs[i]);
                        this.m_top.add(node);
                    }
                }
            }
            catch (DBException dbe) {
                if (dbe.getMessage().toUpperCase().indexOf("ORA-01013") >= 0) break block11;
                DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), UIArb.getString(197), dbe);
            }
        }
        if (this.m_bar != null) {
            this.m_bar.setDoneStatus();
        }
    }

    protected SystemObject[] filterAndSort(SystemObject[] objs) {
        Arrays.sort(objs, this.m_dbRenderer);
        return objs;
    }

    @Override
    public void run() {
        this.doQuery();
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }

    private String[] removeSchemaObjectTypes() {
        return null;
    }
}

