/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DBObjectLabel
extends JLabel {
    private boolean m_hideWhenNull;

    public DBObjectLabel() {
    }

    public DBObjectLabel(DBObject obj, boolean fullName) {
        this.setObject(obj, fullName);
    }

    public void setHideWhenNull(boolean hide) {
        this.m_hideWhenNull = hide;
    }

    public void setObject(DBObject obj, boolean fullName) {
        if (obj == null) {
            this.setIcon(null);
            this.setText("" + null);
            this.setToolTipText(null);
        } else {
            String name = fullName ? DBUtil.getFullyQualifiedName((DBObject)obj) : obj.getName();
            this.setText(name);
            Icon i = DBTypeDisplayRegistry.getNodeIcon(obj.getType());
            if (i == null) {
                i = OracleIcons.getIcon((String)"column.png");
            }
            this.setIcon(i);
            DBObject test = obj;
            String type = DBTypeDisplayRegistry.getSingularDisplayName(test.getType());
            while (type == null && (test = test.getParent()) != null) {
                type = DBTypeDisplayRegistry.getSingularDisplayName(test.getType());
            }
            this.setToolTipText(type + " " + name);
            this.setVisible(!this.m_hideWhenNull || ModelUtil.hasLength((String)name) && !name.equals("null"));
        }
    }
}

