/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectChooserDelegate {
    private DBObjectChooser m_delegateOf;
    private DBObjectProvider m_prov;

    protected abstract boolean accept(DBObjectChooser var1, DBObjectProvider var2);

    protected abstract void initialiseUI();

    protected abstract void buildMaintainID();

    protected abstract void contextChanged();

    protected abstract void showID();

    protected DBObjectCriteria getDBObjectCriteria() {
        return null;
    }

    protected abstract void setName(String var1);

    protected abstract String getName();

    protected abstract void setEnabled(boolean var1);

    protected abstract boolean isEnabled();

    protected abstract void setEditable(boolean var1);

    protected abstract boolean isEditable();

    protected abstract DBObject getOrCreateDBObject();

    protected void setChooser(DBObjectChooser chooser) {
        this.m_delegateOf = chooser;
    }

    protected final DBObjectChooser getChooser() {
        return this.m_delegateOf;
    }

    protected void setProvider(DBObjectProvider prov) {
        this.m_prov = prov;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_prov;
    }

    protected final void add(Component comp, GridBagConstraints constraints) {
        this.m_delegateOf.add(comp, constraints);
    }

    protected void addIDToList(DBObjectID id) {
    }

    protected final String getStringFromID(DBObjectID id) {
        String text = "";
        if (id != null) {
            if (id instanceof ReferenceID) {
                text = ((ReferenceID)id).getName();
            } else if (id instanceof DataTypeID) {
                text = ((DataTypeID)id).getTypeName();
            }
            if (!ModelUtil.hasLength((String)text)) {
                try {
                    DBObject dbObject = id.resolveID();
                    if (dbObject != null) {
                        text = dbObject.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (!ModelUtil.hasLength((String)text) && id instanceof BaseObjectID) {
                text = ((BaseObjectID)id).getName();
            }
        }
        if (ModelUtil.hasLength((String)text) && this.internaliseNames()) {
            text = this.m_prov.getExternalName(text);
        }
        return text;
    }

    protected final DBObjectID getIDFromString(String text) {
        ReferenceID id = null;
        if (text != null && text.length() > 0) {
            if (this.getNullText() != null && text.equals(this.getNullText())) {
                return null;
            }
            if (this.internaliseNames()) {
                text = this.m_prov.getInternalName(text);
            }
            String type = this.getTypes()[0];
            id = new ReferenceID(type, null, text, null, null);
            String schemaName = null;
            DBObjectID parentID = this.getChooser().getContextDBObjectID();
            if (SchemaObject.class.isAssignableFrom(Metadata.getInstance().getObjectClass(type))) {
                schemaName = this.getStringFromID(parentID);
                parentID = null;
            }
            id.setParent(parentID);
            id.setSchemaName(schemaName);
        }
        return id;
    }

    private boolean internaliseNames() {
        return !this.getTypes()[0].equals("XML SCHEMA") && !this.getTypes()[0].equals("XMLSchemaElement");
    }

    protected void updateID(DBObjectID id) {
        this.getChooser().updateID(id);
    }

    protected String[] getTypes() {
        return this.getChooser().getTypes();
    }

    protected boolean getShowIcon() {
        return this.getChooser().getShowIcon();
    }

    protected String getNullText() {
        return this.getChooser().getNullText();
    }

    protected DBObjectID getContextDBObjectID() {
        DBObject obj;
        DBObjectID ctxID = this.getChooser().getContextDBObjectID();
        if (ctxID instanceof ReferenceID && (obj = this.resolveInProvider((ReferenceID)ctxID)) != null) {
            ctxID = obj.getID();
        }
        return ctxID;
    }

    private DBObject resolveInProvider(ReferenceID refID) {
        SystemObject retval = null;
        try {
            DBObject parent;
            String type = refID.getType();
            if (SystemObject.class.isAssignableFrom(Metadata.getInstance().getObjectClass(type))) {
                DBObjectCriteria crit = new DBObjectCriteria(Metadata.getInstance().getObjectClass(type), new String[0]);
                crit.setNameLike(refID.getName());
                crit.setSchemaName(refID.getSchemaName());
                retval = this.getProvider().getObject(crit);
            } else if (ChildDBObject.class.isAssignableFrom(Metadata.getInstance().getObjectClass(type)) && refID.getParent() instanceof ReferenceID && (parent = this.resolveInProvider((ReferenceID)refID.getParent())) != null) {
                retval = parent.findOwnedObject(refID.getType(), refID.getName());
            }
        }
        catch (DBException e) {
            retval = null;
        }
        return retval;
    }

    protected DBObjectChooser getParentChooser() {
        return this.getChooser().getParentChooser();
    }

    protected DBObjectChooser getChildChooser() {
        return this.getChooser().getChildChooser();
    }

    protected DBObjectID fixProvider(DBObjectID id) {
        return id;
    }
}

