/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.DBObjectChooserDelegate;
import oracle.ideimpl.db.controls.ChildObjectChooserDelegate;
import oracle.ideimpl.db.controls.SchemaObjectChooserDelegate;
import oracle.ideimpl.db.controls.SystemObjectChooserDelegate;
import oracle.javatools.db.DBObjectProvider;

public abstract class DBObjectChooserBridge
extends DBObjectChooserDelegate {
    private DBObjectChooserDelegate m_subDelegate = null;

    private DBObjectChooserDelegate getSubDelegateOrFail() {
        if (this.m_subDelegate == null) {
            throw new IllegalStateException("cannot access methods on DBObjectChooserBridge before setting subDelegate");
        }
        return this.m_subDelegate;
    }

    @Override
    public void setEditable(boolean editable) {
        this.getSubDelegateOrFail().setEditable(editable);
    }

    @Override
    public boolean isEditable() {
        return this.getSubDelegateOrFail().isEditable();
    }

    protected void setSubDelegate(DBObjectChooserDelegate subDelegate, DBObjectProvider prov) {
        if (subDelegate != null) {
            this.m_subDelegate = subDelegate;
            this.m_subDelegate.setChooser(this.getChooser());
            this.m_subDelegate.setProvider(prov);
            this.m_subDelegate.initialiseUI();
        }
    }

    @Override
    protected void buildMaintainID() {
        this.getSubDelegateOrFail().buildMaintainID();
    }

    @Override
    protected void showID() {
        this.getSubDelegateOrFail().showID();
    }

    @Override
    protected void contextChanged() {
        this.getSubDelegateOrFail().contextChanged();
    }

    @Override
    public void setName(String name) {
        this.getSubDelegateOrFail().setName(name);
    }

    @Override
    public String getName() {
        return this.getSubDelegateOrFail().getName();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getSubDelegateOrFail().setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.getSubDelegateOrFail().isEnabled();
    }

    protected final void setSubDelegateProvider(DBObjectProvider prov) {
        this.getSubDelegateOrFail().setProvider(prov);
        if (this.getChooser().getChildChooser() != null && this.getChooser().getChildChooser().getDelegate() instanceof DBObjectChooserBridge) {
            ((DBObjectChooserBridge)this.getChooser().getChildChooser().getDelegate()).setSubDelegateProvider(prov);
        }
    }

    @Override
    protected boolean accept(DBObjectChooser chooser, DBObjectProvider prov) {
        boolean retval = true;
        DBObjectChooser choozer = chooser;
        while (choozer.getParentChooser() != null) {
            choozer = choozer.getParentChooser();
        }
        while (choozer != null) {
            if (this.acceptImpl(choozer, prov)) {
                return true;
            }
            choozer = choozer.getChildChooser();
        }
        return false;
    }

    protected abstract boolean acceptImpl(DBObjectChooser var1, DBObjectProvider var2);

    protected final DBObjectChooserDelegate getDefaultDelegate(DBObjectChooser chooser, DBObjectProvider prv, boolean editable) {
        ArrayList<Class<ChildObjectChooserDelegate>> delegateClzList = new ArrayList<Class<ChildObjectChooserDelegate>>();
        delegateClzList.add(SchemaObjectChooserDelegate.class);
        delegateClzList.add(SystemObjectChooserDelegate.class);
        delegateClzList.add(ChildObjectChooserDelegate.class);
        for (Class clazz : delegateClzList) {
            Constructor c = null;
            try {
                c = clazz.getConstructor(Boolean.TYPE);
                DBObjectChooserDelegate delegate = (DBObjectChooserDelegate)c.newInstance(editable);
                if (delegate == null || !delegate.accept(chooser, prv)) continue;
                return delegate;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        return null;
    }
}

