/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.ide.db.controls.DBObjectChooserDelegate;
import oracle.ideimpl.db.controls.ChildObjectChooserDelegate;
import oracle.ideimpl.db.controls.SchemaObjectChooserDelegate;
import oracle.ideimpl.db.controls.SystemObjectChooserDelegate;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Pair;

public final class DBObjectChooser
extends JPanel {
    private static List<Pair<Class<? extends DBObjectProvider>, Class<? extends DBObjectChooserDelegate>>> s_chooserList = null;
    private String[] m_types;
    private Boolean m_showIcon;
    private String m_nullText;
    private DBObjectChooserDelegate m_delegate;
    private DBObjectChooser m_child;
    private DBObjectChooser m_parent;
    private DBObjectID m_contextID;
    private DBObjectID m_id;
    private Boolean m_enabled;
    private Boolean m_editable;
    private List<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private boolean m_childObjects = false;
    private boolean m_schemaObjects = false;
    private boolean m_nonSchemaSystemObjects = false;
    private DBObjectFilter m_filter = null;

    public DBObjectChooser(String ... types) {
        this((DBObjectChooser)null, types);
    }

    public DBObjectChooser(DBObjectChooser parent, String ... types) {
        for (String type : types) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                this.m_childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                this.m_schemaObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            this.m_nonSchemaSystemObjects = true;
        }
        if ((this.m_childObjects ? 1 : 0) + (this.m_schemaObjects ? 1 : 0) + (this.m_nonSchemaSystemObjects ? 1 : 0) != 1) {
            throw new IllegalArgumentException("Incompatible list of types");
        }
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.m_child = this;
        }
        this.m_types = types;
        this.setLayout(new GridBagLayout());
    }

    public final void setShowIcon(boolean showIcon) {
        this.m_showIcon = showIcon;
    }

    public final void setNullText(String nullText) {
        this.m_nullText = nullText;
    }

    public final void setProvider(DBObjectProvider prov) {
        if (this.m_child != null) {
            this.m_child.setProvider(prov);
        }
        if (this.m_delegate == null) {
            if (this.m_showIcon == null) {
                this.m_showIcon = this.m_types.length > 1;
            }
            this.m_delegate = this.createDelegate(prov);
            this.m_delegate.setProvider(prov);
            this.m_delegate.initialiseUI();
            this.m_delegate.buildMaintainID();
            this.setDelegateName();
            if (this.m_enabled != null) {
                this.m_delegate.setEnabled(this.m_enabled);
            }
            if (this.m_editable != null) {
                this.m_delegate.setEditable(this.m_editable);
            }
        }
    }

    public final void setContextDBObjectID(DBObjectID id) {
        this.m_contextID = id;
        if (this.m_delegate != null) {
            this.m_delegate.contextChanged();
        }
    }

    public final DBObjectID getDBObjectID() {
        return this.m_delegate == null ? this.m_id : this.m_delegate.fixProvider(this.m_id);
    }

    public final void setDBObjectID(DBObjectID id) {
        this.updateID(id);
        if (this.m_delegate != null) {
            this.m_delegate.showID();
        }
    }

    public final DBObject getDBObject() {
        DBObject obj = null;
        DBObjectID id = this.getDBObjectID();
        if (id != null) {
            try {
                obj = id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return obj;
    }

    public final void setDBObject(DBObject obj) {
        DBObjectID id = null;
        if (obj != null && (id = obj.getID()) == null) {
            id = TemporaryObjectID.createID((DBObject)obj);
        }
        this.setDBObjectID(id);
    }

    public DBObjectCriteria getDBObjectCriteria() {
        if (this.m_delegate != null) {
            return this.m_delegate.getDBObjectCriteria();
        }
        return null;
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.setDelegateName();
    }

    private void setDelegateName() {
        if (this.m_delegate != null) {
            this.m_delegate.setName(this.getName() + "-delegate");
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (this.m_delegate != null) {
            this.m_delegate.setEnabled(enabled);
        } else {
            this.m_enabled = enabled;
        }
    }

    @Override
    public final boolean isEnabled() {
        if (this.m_delegate != null) {
            return this.m_delegate.isEnabled();
        }
        return this.m_enabled == null ? true : this.m_enabled;
    }

    public final void setEditable(boolean editable) {
        if (this.m_delegate != null) {
            this.m_delegate.setEditable(editable);
        } else {
            this.m_enabled = editable;
        }
    }

    public final boolean isEditable() {
        if (this.m_delegate != null) {
            return this.m_delegate.isEditable();
        }
        return this.m_editable == null ? true : this.m_editable;
    }

    public DBObject getOrCreateDBObject() {
        if (this.m_delegate != null) {
            return this.m_delegate.getOrCreateDBObject();
        }
        return null;
    }

    public final void addChangeListener(ChangeListener l) {
        this.m_listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.m_listeners.remove(l);
    }

    public final String[] getTypes() {
        return this.m_types;
    }

    final boolean getShowIcon() {
        return this.m_showIcon == null ? false : this.m_showIcon;
    }

    final String getNullText() {
        return this.m_nullText;
    }

    public final void addIDToList(DBObjectID id) {
        if (this.m_delegate != null) {
            this.m_delegate.addIDToList(id);
        }
    }

    public void setFilter(DBObjectFilter filter) {
        this.m_filter = filter;
    }

    public DBObjectFilter getFilter() {
        return this.m_filter;
    }

    final DBObjectID getContextDBObjectID() {
        return this.m_contextID;
    }

    final DBObjectChooser getParentChooser() {
        return this.m_parent;
    }

    final DBObjectChooser getChildChooser() {
        return this.m_child;
    }

    final void updateID(DBObjectID id) {
        if (id != null && !id.equals(this.m_id, false) || id == null && this.m_id != null) {
            this.m_id = id;
            for (ChangeListener cl : this.m_listeners) {
                cl.chooserChanged(this, this.m_id);
            }
            if (this.m_child != null) {
                this.m_child.setContextDBObjectID(id);
            }
        }
    }

    public static final void registerCustomChooser(Class<? extends DBObjectProvider> provClz, Class<? extends DBObjectChooserDelegate> delegateClz) {
        if (provClz == null || delegateClz == null) {
            throw new IllegalArgumentException("Null parameters not allowed");
        }
        Pair p = new Pair(provClz, delegateClz);
        s_chooserList.add(0, (Pair<Class<? extends DBObjectProvider>, Class<? extends DBObjectChooserDelegate>>)p);
    }

    private DBObjectChooserDelegate createDelegate(DBObjectProvider prov) {
        DBObjectChooserDelegate delegate = null;
        for (Pair<Class<? extends DBObjectProvider>, Class<? extends DBObjectChooserDelegate>> p : s_chooserList) {
            if (((Class)p.first).isAssignableFrom(prov.getClass())) {
                try {
                    delegate = (DBObjectChooserDelegate)((Class)p.second).newInstance();
                    if (!delegate.accept(this, prov)) {
                        delegate = null;
                    }
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (delegate == null) continue;
            break;
        }
        if (delegate == null) {
            throw new IllegalStateException("Cannot find a DBObjectChooserDelegate to use");
        }
        delegate.setChooser(this);
        return delegate;
    }

    DBObjectChooserDelegate getDelegate() {
        return this.m_delegate;
    }

    static {
        s_chooserList = new ArrayList<Pair<Class<? extends DBObjectProvider>, Class<? extends DBObjectChooserDelegate>>>();
        DBObjectChooser.registerCustomChooser(DBObjectProvider.class, ChildObjectChooserDelegate.class);
        DBObjectChooser.registerCustomChooser(DBObjectProvider.class, SchemaObjectChooserDelegate.class);
        DBObjectChooser.registerCustomChooser(DBObjectProvider.class, SystemObjectChooserDelegate.class);
    }

    public static interface ChangeListener {
        public void chooserChanged(DBObjectChooser var1, DBObjectID var2);
    }
}

