/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12CaptureObjectsOnlineCapturer;

public class Teradata12Provider
extends ThirdPartyDbProvider {
    protected OnlineCapturer m_capturer = null;
    protected String m_label = null;

    public Teradata12Provider(Connection connection) {
        super(connection);
    }

    public OnlineCapturer getCapturer(MigrationStorer migrationStorer) {
        if (this.m_capturer == null) {
            this.m_capturer = new Teradata12CaptureObjectsOnlineCapturer(migrationStorer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                String string;
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                try {
                    ResultSet resultSet = this.getConnection().createStatement().executeQuery("select database");
                    resultSet.next();
                    string = resultSet.getString(1);
                }
                catch (Throwable throwable) {
                    string = databaseMetaData.getUserName();
                }
                this.m_label = string.equals(databaseMetaData.getUserName()) ? "\\\\" + databaseMetaData.getUserName() + " (" + databaseMetaData.getDatabaseProductName() + ")" : "\\\\" + databaseMetaData.getUserName() + "\\" + string + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_label = null;
            }
        }
        return this.m_label;
    }
}

