/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.plugin.teradata.TeradataTranslationList;

public class Teradata12Converter
extends AbstractConverter {
    public ITranslator getPlaformTranslator() {
        return ParserFactory.getParser((String)"oracle.dbtools.migration.teradata.parser.TeradataParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "/oracle/dbtools/migration/workbench/plugin/teradata/Teradata12DefaultValuesMappingRules.xml";
    }

    public String[] getPropertyKeyList() {
        return new String[]{"TERADATA_CHECKCONSTRAINT", "TERADATA_CHECK_TIME_DEFAULT", "TERADATA_CHECK_TIMESTAMP_DEFAULT", "TERADATA_CHECK_DATE_DEFAULT"};
    }

    public ConvertResult convertObject(PersistableObject persistableObject, String string, PersistenceManager persistenceManager) throws ConvertException {
        MdColumn mdColumn;
        String string2;
        if (string.equals("TERADATA_CHECKCONSTRAINT") && persistableObject instanceof MdConstraint) {
            MdConstraint mdConstraint = (MdConstraint)persistableObject;
            String string3 = mdConstraint.getLanguage();
            mdConstraint.setLanguage("OracleSQL");
            TeraConvertResult teraConvertResult = new TeraConvertResult((PersistableObject)mdConstraint);
            return teraConvertResult;
        }
        if (string.equals("TERADATA_CHECK_TIME_DEFAULT") && persistableObject instanceof MdColumn && (string2 = (mdColumn = (MdColumn)persistableObject).getDefaultValue()) != null && string2.toLowerCase().matches("current time\\((\\p{Digit})+\\)")) {
            mdColumn.setDefaultValue("SYSTIMESTAMP");
            TeraConvertResult teraConvertResult = new TeraConvertResult((PersistableObject)mdColumn);
            return teraConvertResult;
        }
        if (string.equals("TERADATA_CHECK_TIMESTAMP_DEFAULT") && persistableObject instanceof MdColumn && (string2 = (mdColumn = (MdColumn)persistableObject).getDefaultValue()) != null && string2.toLowerCase().matches("current timestamp\\((\\p{Digit})+\\)")) {
            mdColumn.setDefaultValue("SYSTIMESTAMP");
            TeraConvertResult teraConvertResult = new TeraConvertResult((PersistableObject)mdColumn);
            return teraConvertResult;
        }
        if (string.equals("TERADATA_CHECK_DATE_DEFAULT") && persistableObject instanceof MdColumn && (string2 = (mdColumn = (MdColumn)persistableObject).getDefaultValue()) != null && string2.toLowerCase().matches("date")) {
            mdColumn.setDefaultValue("SYSDATE");
            TeraConvertResult teraConvertResult = new TeraConvertResult((PersistableObject)mdColumn);
            return teraConvertResult;
        }
        return null;
    }

    public String getEmulationPkgName() {
        return "teradata_utilities";
    }

    public ObjectTranslationList getSupportedTranslationObjects() {
        return new TeradataTranslationList();
    }

    protected static class TeraConvertResult
    implements ConvertResult {
        PersistableObject original;

        public TeraConvertResult(PersistableObject persistableObject) {
            this.original = persistableObject;
        }

        public PersistableObject getOriginal() {
            return this.original;
        }

        public PersistableObject[] getDerivedObjects() {
            return null;
        }

        public boolean maintainOrder() {
            return false;
        }
    }
}

