/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.plugin.Teradata12Plugin;
import oracle.dbtools.migration.workbench.plugin.Teradata13BTEQState;
import oracle.dbtools.migration.workbench.plugin.Teradata13FEXPState;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataStateInterface;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata13Converter;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata13Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata13OfflineCapturer;

public class Teradata13Plugin
extends Teradata12Plugin
implements TeradataMachine {
    public static final int PERIOD_LENGTH = 64;
    public static final int MBR_LENGTH = 256;

    public Teradata13Plugin() {
        this.m_converter = new Teradata13Converter();
    }

    @Override
    public String getPluginName() {
        return "Teradata 13";
    }

    @Override
    public String getVersionNumber() {
        return "13.0";
    }

    @Override
    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new Teradata13Converter();
        }
        return this.m_converter;
    }

    @Override
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 13) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public int getPlatformMask() {
        return 8192;
    }

    @Override
    public String getPublishedVersion() {
        return "13";
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new Teradata13OfflineCapturer();
    }

    @Override
    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/Teradata13DataTypesMap.xml";
    }

    @Override
    public Offline3rdPartyPrintStream getOffline3rdPartyPrintStream(String string, String string2) {
        return new Teradata13Offline3rdPartyPrintStream(string, string2);
    }

    @Override
    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        return this.state.formatSQLLoaderColumn(this, mdColumn, mdColumn2);
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnType();
        if (string.equals("ST_GEOMETRY")) {
            StringBuffer stringBuffer = new StringBuffer();
            if (mdColumn2.getNullableFlag()) {
                stringBuffer.append(this.trunk30("NL_" + mdColumn2.getColumnName()));
                stringBuffer.append(" FILLER CHAR(1),\n");
            }
            String string3 = this.trunk30("GEO_" + mdColumn2.getColumnName());
            stringBuffer.append(string3 + " BOUNDFILLER VARCHARC(6),\n");
            stringBuffer.append(mdColumn2.getColumnName());
            return stringBuffer.toString();
        }
        return super.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected TeradataStateInterface getBTEQState() {
        return new Teradata13BTEQState(this);
    }

    @Override
    protected TeradataStateInterface getFEXPState() {
        return new Teradata13FEXPState(this);
    }

    public DataMoveDrone getDataMoveDrone(String string, DataMoveMarshal dataMoveMarshal, Connection connection, Connection connection2, Quoter quoter, StatementProvider statementProvider, boolean bl, int n, DataMoveAudience dataMoveAudience, boolean bl2) {
        return new DataMoveDrone(string, dataMoveMarshal, connection, connection2, quoter, statementProvider, bl, n, dataMoveAudience, bl2){

            public void run() {
                super.run();
            }

            protected void doDataMove() {
                super.doDataMove();
            }

            protected PreparedStatement createInsertPreparedStatement(String[] stringArray) throws SQLException {
                StringBuffer stringBuffer = new StringBuffer();
                MdColumn[] mdColumnArray = this.m_descriptor.getTargetColumns();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer.append("INSERT INTO ");
                stringBuffer.append(this.m_descriptor.getTargetTableName(this.m_qualifyNames));
                stringBuffer.append('(');
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = mdColumnArray[i].getColumnType();
                    stringBuffer.append(stringArray[i]);
                    if (string.equalsIgnoreCase("SDO_GEOMETRY")) {
                        stringBuffer2.append("SDO_GEOMETRY(?)");
                    } else {
                        stringBuffer2.append('?');
                    }
                    if (i == stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                    stringBuffer2.append(", ");
                }
                stringBuffer.append(") VALUES (");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(')');
                PreparedStatement preparedStatement = this.m_targetConnection.prepareStatement(stringBuffer.toString());
                return preparedStatement;
            }
        };
    }
}

