/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.Teradata12BTEQState;
import oracle.dbtools.migration.workbench.plugin.Teradata12FEXPState;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataPreferencePanel;
import oracle.dbtools.migration.workbench.plugin.TeradataQuoter;
import oracle.dbtools.migration.workbench.plugin.TeradataStateInterface;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Converter;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Provider;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class Teradata12Plugin
extends AbstractMigrationPlugin
implements TeradataMachine {
    public static final String NULLIF_FILLER_PREFIX = "NL_";
    public static final String GEO_BOUNDFILLER_PREFIX = "GEO_";
    public static final String BTEQ_CMD_WIN = "bteq -e UTF8 -c UTF16 .logon %1/%2,%3 < unload_script.bteq";
    public static final String BTEQ_CMD_UNIX = "bteq -e UTF8 -c UTF16 .logon ${args[0]}/${args[1]},${args[2]} < unload_script.bteq";
    public static final String FEXP_CMD_WIN = "fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon %1/%2,%3 ;\" < unload_script.fexp";
    public static final String FEXP_CMD_UNIX = "fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon ${args[0]}/${args[1]},${args[2]} ;\" < unload_script.fexp";
    protected Converter m_converter = null;
    protected StringTemplateGroup m_templateGroup = null;
    public static final String DRIVER_CLASS = "com.teradata.jdbc.TeraDriver";
    protected static boolean s_driverLoaded = false;
    protected TeradataStateInterface bteqState = this.getBTEQState();
    protected TeradataStateInterface fexpState = this.getFEXPState();
    protected TeradataStateInterface state;

    public Teradata12Plugin() {
        this.initState();
    }

    public String getPlatformName() {
        return "Teradata";
    }

    public String getPluginName() {
        return "Teradata 12";
    }

    public String getVersionNumber() {
        return "12.0";
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.teradata");
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 12) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public String getPlatformNameforNavigator() {
        return "Teradata";
    }

    public String getPublishedVersion() {
        return "12";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) {
        return new Teradata12Provider(connection);
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new Teradata12Converter();
        }
        return this.m_converter;
    }

    private void loadTemplates() {
        if (this.m_templateGroup == null) {
            CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", null);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    public boolean getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        return this.state.getDataExportCommmand(this, string, mdColumnArray, string2, offline3rdPartyPrintStream);
    }

    @Override
    public String quote(String string) {
        String string2 = null;
        if (string != null) {
            if (string.contains("\"")) {
                string2 = string;
            } else if (string.contains(".")) {
                String[] stringArray = string.split("\\.");
                String string3 = "";
                string2 = "";
                for (String string4 : stringArray) {
                    string2 = string2 + string3 + "\"" + string4 + "\"";
                    string3 = ".";
                }
            } else {
                string2 = "\"" + string + "\"";
            }
        }
        return string2;
    }

    protected String getLobFileOption() {
        return "";
    }

    public String getDatafileExtension() {
        return "dat";
    }

    public String getBTEQExportExtension() {
        return "exp";
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(this.trunk30(NULLIF_FILLER_PREFIX + mdColumn2.getColumnName()));
            stringBuffer.append(" FILLER CHAR(1),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        String string = mdColumn.getColumnType();
        if (string.equals("BYTELARGEOBJECT") || string.equals("CHARLARGEOBJECTLATIN") || string.equals("CHARLARGEOBJECTGRAPHIC") || string.equals("CHARLARGEOBJECTUNICODE") || string.equals("CHARLARGEOBJECTKANJI1") || string.equals("CHARLARGEOBJECTKANJISJIS")) {
            stringBuffer.append("_FILE FILLER VARCHARC(6),\n");
            stringBuffer.append(mdColumn2.getColumnName());
        }
        return stringBuffer.toString();
    }

    @Override
    public String trunk30(String string) {
        if (string.length() > 30) {
            return string.substring(0, 30);
        }
        return string;
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        return this.state.formatSQLLoaderColumn(this, mdColumn, mdColumn2);
    }

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/Teradata12DataTypesMap.xml";
    }

    public void initialize() {
        super.initialize();
    }

    public OfflineCapturer getOfflineCapturer() {
        return new Teradata12OfflineCapturer();
    }

    public Offline3rdPartyPrintStream getOffline3rdPartyPrintStream(String string, String string2) {
        return new Teradata12Offline3rdPartyPrintStream(string, string2);
    }

    public StringTemplate getLoadCtlStatementTemplate() {
        this.loadTemplates();
        return this.m_templateGroup.getInstanceOf("LoadCtlStatement");
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public String getColumnSelectPattern(String string, MdColumn mdColumn) {
                String string2 = mdColumn.getColumnType();
                String string3 = mdColumn.getColumnName();
                String string4 = string;
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY" + (n != null ? "(" + n + ")" : "") + " TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
                    switch (n) {
                        case 4: {
                            n = 3;
                            break;
                        }
                        case 3: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY(" + n + ") TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY(1) TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) (NAMED " + string + ")";
                } else if (string2.equals("MONTH")) {
                    switch (n) {
                        case 4: {
                            n = 3;
                            break;
                        }
                        case 3: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) (NAMED " + string + ")";
                }
                return string4;
            }
        };
    }

    public String createDataFileName(String string, String string2) {
        return string.replaceAll("[ \\\\/$]", "_") + "." + this.getDatafileExtension();
    }

    public Quoter getQuoter() {
        return new TeradataQuoter();
    }

    public int getPlatformMask() {
        return 4096;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectStatement(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        String string = offline3rdPartyPrintStream.getFilePathAndName();
        string = string.substring(0, string.lastIndexOf(".")) + ".sh";
        String string2 = "";
        String string3 = string.substring(0, string.lastIndexOf(".")) + ".tmp";
        File file = new File(string);
        File file2 = new File(string3);
        String string4 = "args=(\"$@\")";
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (!file.exists()) {
                return;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains("#!/bin/bash")) {
                    string2 = string2 + '\n' + '\n' + string4;
                }
                if (string2.contains("bteq")) {
                    string2 = BTEQ_CMD_UNIX;
                }
                if (string2.contains("fexp")) {
                    string2 = FEXP_CMD_UNIX;
                }
                if (string2.contains("/\"")) {
                    String string5 = "\\\\\"";
                    string2 = string2.replaceAll("/\"", string5);
                }
                bufferedWriter.append(string2 + '\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    file.delete();
                    file2.renameTo(new File(string));
                }
            }
            catch (IOException iOException) {}
        }
        this.removeDirNameFromBteqFile(offline3rdPartyPrintStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDirNameFromBteqFile(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        String string = offline3rdPartyPrintStream.getDirectoryPath() + File.separator + "unload_script.bteq";
        String string2 = "";
        String string3 = string.substring(0, string.lastIndexOf(".")) + ".tmp";
        File file = new File(string);
        File file2 = new File(string3);
        String string4 = "mkdir data";
        String string5 = "mkdir log";
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (!file.exists()) {
                return;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains(string4) || string2.contains(string5)) continue;
                bufferedWriter.append(string2 + '\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    file.delete();
                    file2.renameTo(new File(string));
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected TeradataStateInterface initState() {
        this.state = TeradataPreferencePanel.isUseFExp() ? this.fexpState : this.bteqState;
        return this.state;
    }

    protected TeradataStateInterface getFEXPState() {
        return new Teradata12FEXPState(this);
    }

    protected TeradataStateInterface getBTEQState() {
        return new Teradata12BTEQState(this);
    }
}

