/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Offline3rdPartyPrintStream;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12BTEQState
extends TeradataState {
    protected TeradataMachine machine = null;
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12BTEQState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public boolean getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        try {
            Object object;
            this.loadTemplates();
            offline3rdPartyPrintStream.startTable(string);
            if (offline3rdPartyPrintStream instanceof Teradata12Offline3rdPartyPrintStream) {
                object = (Teradata12Offline3rdPartyPrintStream)offline3rdPartyPrintStream;
                this.generateCtl((Teradata12Offline3rdPartyPrintStream)((Object)object), string, mdColumnArray, string2, this.m_templateGroup.getTemplateDefinition("GenerateControlCSV"));
            }
            object = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".exp" : "data/" + string2 + ".exp";
            String string3 = migrationConfig.getEndColumnDelimiter();
            String string4 = "'" + string3 + "'";
            String string5 = migrationConfig.getEndRowDelimiter();
            String string6 = "'" + string5 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string7 = mdColumn.getColumnType();
                String string8 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string8, string7, n, n2);
            }
            StringTemplate stringTemplate = this.m_templateGroup.getTemplateDefinition("Unload");
            stringTemplate.reset();
            stringTemplate.setAttribute("outfile", object);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string4);
            stringTemplate.setAttribute("eord", (Object)string6);
            offline3rdPartyPrintStream.println(":#:BTEQ:" + stringTemplate.toString());
            offline3rdPartyPrintStream.endTable();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getColumnPattern(String string, String string2, int n, int n2) {
        String string3 = "";
        if (string2.equals("DECIMAL")) {
            string3 = "CAST(CAST(\"" + string + "\" AS DECIMAL(" + n + "," + n2 + ")) AS CHAR(" + (n + 2) + "))";
        } else if (string2.equals("DATE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DD') (CHAR(10))";
        } else if (string2.equals("ANSITIME")) {
            string3 = "\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (CHAR(15))";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (CHAR(21))";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DDbHH:MI:SS.S(6)') (CHAR(26))";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DD HH:MI:SS.S(6)Z') (CHAR(31))";
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + "))";
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + "))";
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + "))";
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH)";
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string3 = "CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH)";
        } else {
            string3 = "\"" + string + "\"";
        }
        return string3;
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        boolean bl = mdColumn.getNullableFlag();
        String string3 = mdColumn.getColumnType();
        Integer n = mdColumn.getPrecision();
        Integer n2 = mdColumn.getScale();
        String string4 = "";
        Integer n3 = mdColumn2.getPrecision();
        int n4 = 0;
        if (bl) {
            string4 = " NULLIF " + teradataMachine.trunk30("NL_" + string2) + "='Y'";
        }
        n4 = n3 == null ? 0 : n3;
        if (string3.equals("DECIMAL")) {
            string = "DECIMAL EXTERNAL(" + (n + 2) + ")" + string4;
        } else if (string3.equals("BYTEINT")) {
            string = "INTEGER(1)" + string4;
        } else if (string3.equals("SMALLINT")) {
            string = "INTEGER(2)" + string4;
        } else if (string3.equals("INTEGER")) {
            string = "INTEGER(4)" + string4;
        } else if (string3.equals("BIGINTEGER")) {
            string = "DECIMAL EXTERNAL(21)" + string4;
        } else if (string3.equals("REAL")) {
            string = "DOUBLE" + string4;
        } else if (string3.equals("DATE")) {
            string = "CHAR(10)" + string4 + " \"TO_DATE(:" + string2 + ",  'YYYY-MM-DD')\"";
        } else if (string3.equals("ANSITIME")) {
            string = "CHAR(15)" + string4 + " \"TO_TIMESTAMP(:" + string2 + ",  'HH24:MI:SS.FF6')\"";
        } else if (string3.equals("ANSITIMEWITHTIMEZONE")) {
            string = "CHAR(21)" + string4 + " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'HH24:MI:SS.FF6TZH:TZM')\"";
        } else if (string3.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string = "CHAR(26)" + string4 + " \"TO_TIMESTAMP(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6')\"";
        } else if (string3.equals("TIMESTAMPWITHTIMEZONE")) {
            string = "CHAR(31)" + string4 + " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM')\"";
        } else if (string3.equals("DAY") || string3.equals("DAYHOUR") || string3.equals("DAYMINUTE") || string3.equals("DAYSECOND")) {
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("HOUR") || string3.equals("HOURMINUTE") || string3.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("MINUTE") || string3.equals("MINUTETOSECOND") || string3.equals("SECOND")) {
            string = "CHAR(" + (11 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("YEAR") || string3.equals("YEARMONTH")) {
            string = "CHAR(" + (n + 4) + ")" + string4;
        } else if (string3.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 4) + ")" + string4;
        } else if (string3.equals("BYTELARGEOBJECT") || string3.equals("CHARLARGEOBJECTLATIN") || string3.equals("CHARLARGEOBJECTGRAPHIC") || string3.equals("CHARLARGEOBJECTUNICODE") || string3.equals("CHARLARGEOBJECTKANJI1") || string3.equals("CHARLARGEOBJECTKANJISJIS")) {
            string = "LOBFILE(" + string2 + "_FILE) TERMINATED BY EOF" + string4;
        } else if (string3.equals("BYTEFIXED")) {
            string = "RAW(" + n + ")" + string4;
        } else if (string3.equals("BYTEVARYING")) {
            string = "VARRAWC(10," + n + ")" + string4;
        } else if (string3.equals("CHARFIXEDLATIN")) {
            string = "CHAR(" + n + ")" + string4;
        } else if (string3.equals("CHARFIXEDGRAPHIC") || string3.equals("CHARFIXEDUNICODE")) {
            string = "CHAR(" + n / 2 + ")" + string4;
        } else if (string3.equals("CHARFIXEDKANJI1") || string3.equals("CHARFIXEDKANJISJIS")) {
            string = "CHAR(" + n + ")" + string4;
        } else if (string3.equals("CHARVARYINGLATIN")) {
            string = "VARCHARC(6)" + string4;
        } else if (string3.equals("CHARVARYINGGRAPHIC") || string3.equals("CHARVARYINGUNICODE") || string3.equals("CHARVARYINGKANJI1") || string3.equals("CHARVARYINGKANJISJIS")) {
            string = "VARCHARC(6)" + string4;
        } else {
            string = "XXX(" + string3 + ")XXX";
            System.out.println("UNHANDLED TYPE " + string3 + string4);
        }
        return string;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", null);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public void postProcessTableData(Teradata12Offline3rdPartyPrintStream teradata12Offline3rdPartyPrintStream, String string) throws Exception {
        String string2 = string.endsWith(".dat") ? string.substring(0, string.length() - 4).replaceAll("[ \\\\/$]", "_") : string.replaceAll("[ \\\\/$]", "_");
        teradata12Offline3rdPartyPrintStream.println(":#:SCRIPT:java -jar convertdata.jar data" + File.separator + string2 + ".csv " + "data" + File.separator + string2 + ".exp " + "data" + File.separator + string2 + ".dat");
    }
}

