/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.offline.converter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ConvertDataUTF16 {
    private Charset encoding;
    private static String encodingName = "UTF-16LE";
    private String lobFileName = null;
    private int charSize = 2;
    private int lobFileUnique = 0;
    private Map<String, Class<? extends TypeHandler>> typeHandlerMap = new Hashtable<String, Class<? extends TypeHandler>>(){
        {
            this.put("ANSITIME", TimeTypeHandler.class);
            this.put("BYTEFIXED", PrecisionLengthTypeHandler.class);
            this.put("BYTELARGEOBJECT", LOBOfflineLengthDataTypeHandler.class);
            this.put("BINARYSTRING", PrecisionLengthTypeHandler.class);
            this.put("BYTEVARYING", ByteVaryingLengthValueDataTypeHandler.class);
            this.put("CHARFIXEDLATIN", CharFixedSingleByteTypeHandler.class);
            this.put("CHARFIXEDGRAPHIC", CharFixedDoubleByteTypeHandler.class);
            this.put("CHARFIXEDUNICODE", CharFixedDoubleByteTypeHandler.class);
            this.put("CHARFIXEDKANJI1", CharFixedSingleByteTypeHandler.class);
            this.put("CHARFIXEDKANJISJIS", CharFixedSingleByteTypeHandler.class);
            this.put("CHARLARGEOBJECTLATIN", LOBOfflineLengthDataTypeHandler.class);
            this.put("CHARLARGEOBJECTGRAPHIC", LOBOfflineLengthDataTypeHandler.class);
            this.put("CHARLARGEOBJECTUNICODE", LOBOfflineLengthDataTypeHandler.class);
            this.put("CHARLARGEOBJECTKANJI1", LOBOfflineLengthDataTypeHandler.class);
            this.put("CHARLARGEOBJECTKANJISJIS", LOBOfflineLengthDataTypeHandler.class);
            this.put("CHARSTRING", PrecisionLengthTypeHandler.class);
            this.put("CHARVARYINGLATIN", CharVaryingTypeHandler.class);
            this.put("CHARVARYINGGRAPHIC", CharVaryingTypeHandler.class);
            this.put("CHARVARYINGUNICODE", CharVaryingTypeHandler.class);
            this.put("CHARVARYINGKANJI1", CharVaryingTypeHandler.class);
            this.put("CHARVARYINGKANJISJIS", CharVaryingTypeHandler.class);
            this.put("DECIMAL", DecimalTypeHandler.class);
            this.put("DATE", DateTypeHandler.class);
            this.put("DAYHOUR", IntervalTypeHandler.class);
            this.put("DAYINTERVAL", PrecisionLengthTypeHandler.class);
            this.put("DAYMINUTE", IntervalTypeHandler.class);
            this.put("DAYSECOND", IntervalTypeHandler.class);
            this.put("DATETAG", PrecisionLengthTypeHandler.class);
            this.put("DAY", IntervalTypeHandler.class);
            this.put("REAL", RealTypeHandler.class);
            this.put("HOURMINUTE", IntervalTypeHandler.class);
            this.put("HOUR", IntervalTypeHandler.class);
            this.put("HOURSECOND", IntervalTypeHandler.class);
            this.put("INTEGER", Integer4TypeHandler.class);
            this.put("BYTEINT", Integer1TypeHandler.class);
            this.put("SMALLINT", Integer2TypeHandler.class);
            this.put("BIGINTEGER", Integer8TypeHandler.class);
            this.put("MINUTE", IntervalTypeHandler.class);
            this.put("MONTH", IntervalTypeHandler.class);
            this.put("MINUTETOSECOND", IntervalTypeHandler.class);
            this.put("NUMBERTAG", PrecisionLengthTypeHandler.class);
            this.put("SECOND", IntervalTypeHandler.class);
            this.put("TIMESTAMPWITHTIMEZONE", TimestampWithTZTypeHandler.class);
            this.put("TIMETAG", PrecisionLengthTypeHandler.class);
            this.put("TIMESTAMPWITHOUTTIMEZONE", TimestampTypeHandler.class);
            this.put("ANSITIMEWITHTIMEZONE", TimeWithTZTypeHandler.class);
            this.put("USERDEFINEDTYPE", PrecisionLengthTypeHandler.class);
            this.put("YEARINTERVAL", PrecisionLengthTypeHandler.class);
            this.put("YEARMONTH", IntervalTypeHandler.class);
            this.put("YEAR", IntervalTypeHandler.class);
            this.put("PERIODDATE", PeriodTypeHandler.class);
            this.put("PERIODTIMESTAMPWITHTIMEZONE", PeriodTypeHandler.class);
            this.put("PERIODTIMESTAMP", PeriodTypeHandler.class);
            this.put("PERIODTIME", PeriodTypeHandler.class);
            this.put("PERIODTIMEWITHTIMEZONE", PeriodTypeHandler.class);
            this.put("MBR", CharVaryingTypeHandler.class);
            this.put("ST_GEOMETRY", CharVaryingTypeHandler.class);
        }
    };

    public ConvertDataUTF16() {
        try {
            this.encoding = Charset.forName(encodingName);
        }
        catch (Exception exception) {
            this.encoding = Charset.defaultCharset();
        }
        this.charSize = this.encoding.encode(" ").array().length;
    }

    public Metadata[] readMetaDataCSV(String string) throws Exception {
        FileReader fileReader = new FileReader(string);
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        Vector<Metadata> vector = new Vector<Metadata>();
        String string2 = lineNumberReader.readLine();
        while (string2 != null) {
            String[] stringArray = string2.split(",");
            if (stringArray != null && stringArray.length == 7) {
                long l = Long.valueOf(stringArray[3]);
                if (stringArray[1].equals("BYTELARGEOBJECT") || stringArray[1].equals("BYTEVARYING")) {
                    l <<= 8;
                }
                vector.add(new Metadata(stringArray[0], stringArray[1], Integer.valueOf(stringArray[2]), l, Integer.valueOf(stringArray[4]), stringArray[5], stringArray[6]));
            }
            string2 = lineNumberReader.readLine();
        }
        return vector.toArray(new Metadata[vector.size()]);
    }

    private String numToString(long l, int n, char c) {
        String string = String.valueOf(l);
        boolean bl = l < 0L;
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && c == '0') {
            string = string.substring(1);
            stringBuffer.append('-');
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private TypeHandler[] getTypeHandlers(Metadata[] metadataArray) throws Exception {
        TypeHandler[] typeHandlerArray = new TypeHandler[metadataArray.length];
        for (int i = 0; i < metadataArray.length; ++i) {
            Constructor<? extends TypeHandler> constructor;
            Class<? extends TypeHandler> clazz = this.typeHandlerMap.get(metadataArray[i].getType());
            if (clazz == null) {
                clazz = PrecisionLengthTypeHandler.class;
            }
            Object[] objectArray = null;
            try {
                constructor = clazz.getConstructor(ConvertDataUTF16.class, Metadata.class);
                objectArray = new Object[]{this, metadataArray[i]};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = clazz.getConstructor(ConvertDataUTF16.class);
                    objectArray = new Object[]{this};
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    constructor = null;
                }
            }
            typeHandlerArray[i] = constructor == null ? new PrecisionLengthTypeHandler(metadataArray[i]) : constructor.newInstance(objectArray);
        }
        return typeHandlerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(InputStream inputStream, Metadata[] metadataArray, String string) throws Exception {
        TypeHandler[] typeHandlerArray = this.getTypeHandlers(metadataArray);
        ByteArray byteArray = new ByteArray();
        int n = (metadataArray.length + 7) / 8;
        byte[] byArray = new byte[n];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        this.lobFileName = string;
        if (this.lobFileName.lastIndexOf(46) >= 0) {
            this.lobFileName = this.lobFileName.substring(0, this.lobFileName.lastIndexOf(46));
        }
        try {
            boolean[] blArray = new boolean[metadataArray.length];
            int n2 = 1;
            while (true) {
                int n3;
                byteArray.clear();
                int n4 = dataInputStream.readUnsignedByte();
                int n5 = dataInputStream.readUnsignedByte();
                if (n4 < 0) break;
                if (n5 < 0) {
                    break;
                }
                String string2 = null;
                dataInputStream.read(byArray);
                for (n3 = 0; n3 < metadataArray.length; ++n3) {
                    byte by = byArray[n3 / 8];
                    blArray[n3] = (by >> 7 - n3 % 8 & 1) == 1;
                }
                for (n3 = 0; n3 < typeHandlerArray.length; ++n3) {
                    Object object = typeHandlerArray[n3].getData(dataInputStream);
                    object = typeHandlerArray[n3].processData(object);
                    if (metadataArray[n3].getNullable()) {
                        byteArray.write(blArray[n3] ? "Y".getBytes(this.encoding) : "N".getBytes(this.encoding));
                    }
                    typeHandlerArray[n3].putData(byteArray, object);
                }
                n3 = dataInputStream.read();
                if (n3 != 10 && n3 != 13) {
                    System.out.println("End of record not correct - 0x" + Integer.toHexString(n3) + " Row " + n2);
                }
                string2 = this.numToString(byteArray.size(), 6, '0');
                dataOutputStream.write(string2.getBytes(this.encoding));
                byteArray.flush(dataOutputStream);
                ++n2;
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                dataInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected int readShort(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte() + dataInputStream.readUnsignedByte() * 256;
        return n;
    }

    protected long readLong(DataInputStream dataInputStream) throws IOException {
        int n;
        long l = 0L;
        int[] nArray = new int[8];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = dataInputStream.readUnsignedByte();
        }
        for (n = 7; n >= 0; --n) {
            l = l * 256L + (long)nArray[n];
        }
        return l;
    }

    protected int readInt(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = 0;
        int[] nArray = new int[4];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = dataInputStream.readUnsignedByte();
        }
        for (n = 3; n >= 0; --n) {
            n2 = n2 * 256 + nArray[n];
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Metadata[] metadataArray;
        ConvertDataUTF16 convertDataUTF16 = new ConvertDataUTF16();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 3) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
        } else {
            metadataArray = "C:/m/datamove/p2/2012-07-17_18-14-39/Teradata/tduser";
            object = "tduser.t_new_period";
            string = (String)metadataArray + "/data/" + (String)object + ".dat.csv";
            string2 = (String)metadataArray + "/data/" + (String)object + ".exp";
            string3 = (String)metadataArray + "/data/" + (String)object + ".dat";
        }
        metadataArray = convertDataUTF16.readMetaDataCSV(string);
        object = new FileInputStream(string2);
        convertDataUTF16.readData((InputStream)object, metadataArray, string3);
    }

    private class ByteVaryingLengthValueDataTypeHandler
    implements TypeHandler {
        int lenghtOfLength = 5;
        Metadata metadata;

        public ByteVaryingLengthValueDataTypeHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        public int getLength(DataInputStream dataInputStream) throws IOException {
            return ConvertDataUTF16.this.readShort(dataInputStream);
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            int n = this.getLength(dataInputStream);
            byte[] byArray = new byte[n];
            dataInputStream.read(byArray);
            return byArray;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(ConvertDataUTF16.this.numToString(byArray.length, this.lenghtOfLength, '0').getBytes(ConvertDataUTF16.this.encoding));
            byteArray.write(byArray);
        }
    }

    private class LOBOfflineLengthDataTypeHandler
    extends OfflineLengthDataTypeHandler {
        public LOBOfflineLengthDataTypeHandler(Metadata metadata) {
            super(metadata);
        }

        @Override
        public int getLength(DataInputStream dataInputStream) throws IOException {
            return (int)ConvertDataUTF16.this.readLong(dataInputStream);
        }
    }

    private abstract class OfflineLengthDataTypeHandler
    implements TypeHandler {
        Metadata metadata;

        public OfflineLengthDataTypeHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        public abstract int getLength(DataInputStream var1) throws IOException;

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            int n = this.getLength(dataInputStream);
            byte[] byArray = new byte[n];
            if (byArray.length > 0) {
                dataInputStream.read(byArray);
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object processData(Object object) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            if (n > 0) {
                ConvertDataUTF16.this.lobFileUnique++;
                String string = ConvertDataUTF16.this.lobFileName + "." + ConvertDataUTF16.this.numToString(ConvertDataUTF16.this.lobFileUnique, 16, '0');
                String string2 = string.lastIndexOf(47) < 0 ? string : string.substring(string.lastIndexOf(47) + 1);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    fileOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return string2;
            }
            return null;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            if (object != null) {
                String string = (String)object;
                byteArray.write(ConvertDataUTF16.this.numToString(string.length(), 6, '0').getBytes(ConvertDataUTF16.this.encoding));
                byteArray.write(string.getBytes(ConvertDataUTF16.this.encoding));
            } else {
                byteArray.write(ConvertDataUTF16.this.numToString(0L, 6, '0').getBytes(ConvertDataUTF16.this.encoding));
            }
        }
    }

    private class Integer4TypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;

        public Integer4TypeHandler(Metadata metadata) {
            this.metadata = metadata;
            this.buf = new byte[4];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            dataInputStream.read(this.buf);
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private class Integer8TypeHandler
    implements TypeHandler {
        Metadata metadata;

        public Integer8TypeHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            Long l = ConvertDataUTF16.this.readLong(dataInputStream);
            return l;
        }

        @Override
        public Object processData(Object object) {
            Long l = (Long)object;
            return ConvertDataUTF16.this.numToString(l, 21, '0');
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            String string = (String)object;
            byteArray.write(string.getBytes(ConvertDataUTF16.this.encoding));
        }
    }

    private class RealTypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;

        public RealTypeHandler(Metadata metadata) {
            this.metadata = metadata;
            this.buf = new byte[8];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            dataInputStream.read(this.buf);
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private class Integer2TypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;

        public Integer2TypeHandler(Metadata metadata) {
            this.metadata = metadata;
            this.buf = new byte[2];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            dataInputStream.read(this.buf);
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private class Integer1TypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;

        public Integer1TypeHandler(Metadata metadata) {
            this.metadata = metadata;
            this.buf = new byte[1];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            dataInputStream.read(this.buf);
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private class DecimalTypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;
        int bufLen;

        public DecimalTypeHandler(Metadata metadata) {
            this.metadata = metadata;
            int n = metadata.getPrecision();
            this.bufLen = (n + 2) * ConvertDataUTF16.this.charSize;
            this.buf = new byte[this.bufLen];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            if (this.buf.length > 0) {
                dataInputStream.read(this.buf);
            }
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private class IntervalTypeHandler
    extends FixedLengthTypeHandler {
        public IntervalTypeHandler(Metadata metadata) {
            this.setLen(this.getIntevalLength(metadata));
        }

        protected int getIntevalLength(Metadata metadata) {
            int n = metadata.getPrecision();
            int n2 = metadata.getScale();
            String string = metadata.getType();
            if (string.equals("DAY") || string.equals("DAYHOUR") || string.equals("DAYMINUTE") || string.equals("DAYSECOND")) {
                n += 10;
                if (n2 > 0) {
                    n += 1 + n2;
                }
            } else if (string.equals("HOUR") || string.equals("HOURMINUTE") || string.equals("HOURSECOND")) {
                switch (n) {
                    case 4: {
                        n = 3;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                n += 10;
                if (n2 > 0) {
                    n += 1 + n2;
                }
            } else if (string.equals("MINUTE") || string.equals("MINUTETOSECOND") || string.equals("SECOND")) {
                n = 11;
                if (n2 > 0) {
                    n += 1 + n2;
                }
            } else if (string.equals("YEAR") || string.equals("YEARMONTH")) {
                n += 4;
            } else if (string.equals("MONTH")) {
                switch (n) {
                    case 4: {
                        n = 3;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                n += 4;
            }
            return n * ConvertDataUTF16.this.charSize;
        }
    }

    private class TimestampWithTZTypeHandler
    extends FixedLengthTypeHandler {
        public TimestampWithTZTypeHandler(Metadata metadata) {
            super(31 * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class TimestampTypeHandler
    extends FixedLengthTypeHandler {
        public TimestampTypeHandler(Metadata metadata) {
            super(26 * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class TimeWithTZTypeHandler
    extends FixedLengthTypeHandler {
        public TimeWithTZTypeHandler(Metadata metadata) {
            super(21 * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class TimeTypeHandler
    extends FixedLengthTypeHandler {
        public TimeTypeHandler(Metadata metadata) {
            super(15 * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class DateTypeHandler
    extends FixedLengthTypeHandler {
        public DateTypeHandler(Metadata metadata) {
            super(10 * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class CharVaryingTypeHandler
    implements TypeHandler {
        int lenghtOfLength = 6;
        Metadata metadata;

        public CharVaryingTypeHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        public int getLength(DataInputStream dataInputStream) throws IOException {
            return ConvertDataUTF16.this.readShort(dataInputStream);
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            int n = this.getLength(dataInputStream);
            byte[] byArray = new byte[n];
            dataInputStream.read(byArray);
            return byArray;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(ConvertDataUTF16.this.numToString(byArray.length / ConvertDataUTF16.this.charSize, this.lenghtOfLength, '0').getBytes(ConvertDataUTF16.this.encoding));
            byteArray.write(byArray);
        }
    }

    private class PeriodTypeHandler
    extends FixedLengthTypeHandler {
        Metadata metadata;

        public PeriodTypeHandler(Metadata metadata) {
            super((int)metadata.getLencode() * 2);
            this.metadata = metadata;
        }
    }

    private class CharFixedSingleByteTypeHandler
    extends FixedLengthTypeHandler {
        Metadata metadata;

        public CharFixedSingleByteTypeHandler(Metadata metadata) {
            super((metadata.getLencode() > 32000L ? 32000 : (int)metadata.getLencode()) * ConvertDataUTF16.this.charSize);
            this.metadata = metadata;
        }
    }

    private class CharFixedDoubleByteTypeHandler
    extends FixedLengthTypeHandler {
        Metadata metadata;

        public CharFixedDoubleByteTypeHandler(Metadata metadata) {
            super((int)metadata.getLencode());
            this.metadata = metadata;
        }
    }

    private class PrecisionLengthTypeHandler
    extends FixedLengthTypeHandler {
        Metadata metadata;

        public PrecisionLengthTypeHandler(Metadata metadata) {
            super((int)metadata.getLencode());
            this.metadata = metadata;
        }
    }

    private class FixedLengthTypeHandler
    implements TypeHandler {
        Metadata metadata;
        byte[] buf;

        public FixedLengthTypeHandler(int n) {
            this.setLen(n);
        }

        protected FixedLengthTypeHandler() {
        }

        protected void setLen(int n) {
            this.buf = new byte[n];
        }

        @Override
        public Object getData(DataInputStream dataInputStream) throws IOException {
            if (this.buf != null && this.buf.length > 0) {
                dataInputStream.read(this.buf);
            }
            return this.buf;
        }

        @Override
        public Object processData(Object object) {
            return object;
        }

        @Override
        public void putData(ByteArray byteArray, Object object) {
            byte[] byArray = (byte[])object;
            byteArray.write(byArray);
        }
    }

    private static interface TypeHandler {
        public Object getData(DataInputStream var1) throws IOException;

        public Object processData(Object var1);

        public void putData(ByteArray var1, Object var2);
    }

    private class Metadata {
        String name;
        String type;
        int order;
        long lencode;
        int precision;
        int scale;
        boolean nullable;

        public Metadata(String string, String string2, int n, long l, int n2, String string3, String string4) {
            this.name = string;
            this.type = string2;
            this.order = n;
            this.lencode = l;
            this.precision = n2;
            this.scale = string3.equals("") ? 0 : Integer.valueOf(string3);
            this.nullable = string4.equals("Y");
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getOrder() {
            return this.order;
        }

        public long getLencode() {
            return this.lencode;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public boolean getNullable() {
            return this.nullable;
        }
    }

    private class ByteArray {
        private static final int BUFSIZE = 16384;
        ArrayList<byte[]> arrayBytes = new ArrayList();
        int count = 0;

        private ByteArray() {
        }

        void clear() {
            this.arrayBytes.clear();
            this.count = 0;
        }

        public byte get(int n) {
            if (n > this.count) {
                throw new IndexOutOfBoundsException(n + ">" + this.count);
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException(n + "<0");
            }
            int n2 = n / 16384;
            byte[] byArray = this.arrayBytes.get(n2);
            return byArray[n % 16384];
        }

        public byte set(int n, byte by) {
            if (n > this.count) {
                throw new IndexOutOfBoundsException(n + ">" + this.count);
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException(n + "<0");
            }
            int n2 = n / 16384;
            byte[] byArray = this.arrayBytes.get(n2);
            byte by2 = byArray[n % 16384];
            byArray[n % 16384] = by;
            return by2;
        }

        public boolean add(byte by) {
            int n = this.count++;
            int n2 = n / 16384;
            byte[] byArray = null;
            if (n2 < this.arrayBytes.size()) {
                byArray = this.arrayBytes.get(n2);
            } else {
                byArray = new byte[16384];
                for (int i = 0; i < 16384; ++i) {
                    byArray[i] = 0;
                }
                this.arrayBytes.add(byArray);
            }
            byArray[n % 16384] = by;
            return true;
        }

        public void write(byte[] byArray) {
            for (byte by : byArray) {
                this.add(by);
            }
        }

        public int size() {
            return this.count;
        }

        public boolean isEmpty() {
            return this.count == 0;
        }

        public void flush(OutputStream outputStream) throws IOException {
            int n = this.count;
            for (byte[] byArray : this.arrayBytes) {
                int n2 = n > byArray.length ? byArray.length : n;
                outputStream.write(byArray, 0, n2);
                n -= n2;
            }
        }
    }
}

