/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.awt.Component;
import java.util.Collection;
import javax.naming.Context;
import oracle.ide.Addin;
import oracle.javatools.jndi.Names;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitWorker;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;

public abstract class ALMCommitManager
implements Addin {
    private static final String ALM_COMMIT_MANAGER_NAME = "ide/alm-commit-manager";

    public static ALMCommitManager getALMCommitManager() {
        ALMCommitManager almCommitManager = (ALMCommitManager)Names.lookup((Context)Names.newInitialContext(), (String)ALM_COMMIT_MANAGER_NAME);
        return almCommitManager != null ? almCommitManager : NullALMCommitManager.getInstance();
    }

    public static void setALMCommitManager(ALMCommitManager almCommitManager) {
        Names.bind((Context)Names.newInitialContext(), (String)ALM_COMMIT_MANAGER_NAME, (Object)almCommitManager);
    }

    public abstract boolean isConnectedToALM();

    protected abstract Component createCommitUI(ALMCommitContext var1);

    public final void executeCommitWorker(XVCSCommandState commandState) {
        if (!this.isConnectedToALM()) {
            return;
        }
        ALMCommitContext almCommitContext = commandState.getALMCommitContext();
        Collection<ALMCommitFile> almCommitFiles = commandState.getALMCommitFiles();
        if (almCommitContext == null) {
            return;
        }
        if (almCommitFiles == null || almCommitFiles.isEmpty()) {
            return;
        }
        this.executeCommitWorker(new ALMCommitWorker(almCommitContext, almCommitFiles));
    }

    public final void executeCommitWorker(ALMCommitWorker worker) {
        worker.start();
    }

    protected abstract void commitToALM(ALMCommitContext var1, Collection<ALMCommitFile> var2) throws Exception;

    private static class NullALMCommitManager
    extends ALMCommitManager {
        private static final NullALMCommitManager _instance = new NullALMCommitManager();

        private NullALMCommitManager() {
        }

        public static NullALMCommitManager getInstance() {
            return _instance;
        }

        public void initialize() {
        }

        @Override
        public boolean isConnectedToALM() {
            return false;
        }

        @Override
        protected Component createCommitUI(ALMCommitContext context) {
            return null;
        }

        @Override
        protected void commitToALM(ALMCommitContext context, Collection<ALMCommitFile> files) {
        }
    }
}

