/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.util.search.SearchKey;
import oracle.jdevimpl.vcs.util.search.SearchList;
import oracle.jdevimpl.vcs.util.search.SearchSetup;

class SearchTableModel
extends DefaultTableModel
implements SearchList,
NiceTableModel {
    private final SearchSetup m_setup;
    private boolean m_dirty = false;

    SearchTableModel(SearchSetup setup) {
        this.m_setup = setup;
        this.columnIdentifiers = new Vector();
        this.columnIdentifiers.add(SearchKey.KEY_RESULT_FILE);
        if (this.m_setup == null) {
            return;
        }
        String[] keys = this.m_setup.getOptionalResultKeys();
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            this.columnIdentifiers.add(keys[i]);
        }
    }

    @Override
    public final String getColumnName(int index) {
        if (index == 0) {
            return ResourcePicker.getPicker(SearchTableModel.class).getString("NAME_KEY_RESULTS_FILE");
        }
        if (this.m_setup == null) {
            return null;
        }
        return this.m_setup.getResultName(this.columnIdentifiers.get(index));
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        return false;
    }

    final void markDirty() {
        this.m_dirty = true;
    }

    public void addResults(URL url) {
        try {
            this.addResults((Element)NodeFactory.findOrCreate((URL)url));
        }
        catch (IllegalAccessException ille) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    @Override
    public void addResults(Element element) {
        HashMap<Object, Element> results = new HashMap<Object, Element>();
        results.put(SearchKey.KEY_RESULT_FILE, element);
        this.addResults(results);
    }

    @Override
    public final void addResults(final Map results) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                SearchTableModel.this.addResultsImpl(new HashMap(results));
            }
        });
    }

    final void flushDirty() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                SearchTableModel.this.flushDirtyImpl();
            }
        });
    }

    private final void addResultsImpl(Map results) {
        this.flushDirtyImpl();
        int index = this.dataVector.size();
        Vector<String> row = new Vector<String>();
        if (!results.containsKey(SearchKey.KEY_RESULT_FILE)) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.columnIdentifiers.size(); ++i) {
            row.add("");
        }
        Object o = results.get(SearchKey.KEY_RESULT_FILE);
        URL u = null;
        Object e = null;
        if (o instanceof String) {
            u = URLFactory.newFileURL((String)((String)o));
        } else if (o instanceof URL) {
            u = (URL)o;
        } else if (o instanceof Element) {
            e = (Element)o;
        }
        if (u != null) {
            if (URLFileSystem.isDirectoryPath((URL)(u = URLFileSystem.canonicalize((URL)u)))) {
                e = new Node(u){

                    public Icon getIcon() {
                        return ResourcePicker.getPicker(SearchTableModel.class).getImage("ICON_FOLDER_NODE");
                    }
                };
            } else {
                try {
                    e = NodeFactory.findOrCreate((URL)u);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (e == null || this.contains(e)) {
            return;
        }
        row.set(0, (String)e);
        results.remove(SearchKey.KEY_RESULT_FILE);
        for (Object key : results.keySet()) {
            int i = this.columnIdentifiers.indexOf(key);
            if (i < 0) continue;
            row.set(i, (String)results.get(key));
        }
        this.dataVector.add(row);
        this.fireTableRowsInserted(index, index);
    }

    private final boolean contains(Object o) {
        for (int i = 0; i < this.dataVector.size(); ++i) {
            Vector row = (Vector)this.dataVector.get(i);
            if (row.size() <= 0 || !o.equals(row.get(0))) continue;
            return true;
        }
        return false;
    }

    private final void flushDirtyImpl() {
        if (this.m_dirty) {
            this.dataVector.clear();
            this.m_dirty = false;
            this.fireTableDataChanged();
        }
    }

    public int getColumnAlignment(int col) {
        return 2;
    }

    public int getSortColumn() {
        return 0;
    }

    public Comparator getColumnSortComparator(int col) {
        return null;
    }

    public boolean isColumnVisible(int col) {
        return true;
    }
}

