/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.vcs.util.search.SearchActions;
import oracle.jdevimpl.vcs.util.search.SearchControl;
import oracle.jdevimpl.vcs.util.search.SearchPanel;
import oracle.jdevimpl.vcs.util.search.SearchTable;
import oracle.jdevimpl.vcs.util.search.SearchWindow;

public class SearchController
implements Controller {
    private final SearchControl _control;

    public SearchController(SearchControl control) {
        this._control = control;
        SearchActions searchActions = this._control.getActions();
        searchActions.getRefreshAction().addController((Controller)this);
        this.chainMeTo(51);
        this.chainMeTo(22);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        SearchActions searchActions = this._control.getActions();
        if (context.getView() == null) {
            return false;
        }
        if (!(context.getView() instanceof SearchWindow)) {
            return false;
        }
        if (action.getCommandId() == 51) {
            this._control.refresh(this._control.getArguments());
            return true;
        }
        if (action.getCommandId() == 22) {
            SearchPanel panel = this._control.getPanel();
            SearchTable table = null;
            if (panel != null) {
                table = panel.getTable();
            }
            if (table != null) {
                table.selectAll();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        SearchActions searchActions = this._control.getActions();
        if (context.getView() == null) {
            return false;
        }
        if (!(context.getView() instanceof SearchWindow)) {
            return false;
        }
        if (action.getCommandId() == 51 || action.getCommandId() == 22) {
            action.setEnabled(!this._control.isBusy());
            return true;
        }
        return false;
    }

    private void chainMeTo(int cmdId) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action != null) {
            action.addController((Controller)this);
        }
    }
}

