/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

abstract class ColumnHideDecorator
extends AbstractTableModel
implements TableModelListener {
    private final TableModel m_baseModel;
    private Map m_modelListenerMap = new HashMap();
    private int[] m_columnMap;

    ColumnHideDecorator(TableModel baseModel) {
        this.m_baseModel = baseModel;
        this.m_baseModel.addTableModelListener(this);
    }

    TableModel getBaseModel() {
        return this.m_baseModel;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.m_baseModel.getValueAt(row, this.getBaseColumnIndex(column));
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.m_baseModel.setValueAt(value, row, this.getBaseColumnIndex(column));
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        this.allocate();
    }

    @Override
    public int getRowCount() {
        return this.m_baseModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.m_columnMap == null) {
            this.allocate();
        }
        return this.m_columnMap.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.m_baseModel.getColumnName(this.getBaseColumnIndex(column));
    }

    public Class getColumnClass(int column) {
        return this.m_baseModel.getColumnClass(this.getBaseColumnIndex(column));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.m_baseModel.isCellEditable(row, this.getBaseColumnIndex(column));
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        super.addTableModelListener(tml);
        this.m_baseModel.addTableModelListener(tml);
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        super.removeTableModelListener(tml);
        this.m_baseModel.removeTableModelListener(tml);
    }

    private void allocate() {
        int visibleCount = 0;
        for (int i = 0; i < this.m_baseModel.getColumnCount(); ++i) {
            if (!this.isColumnVisible(i)) continue;
            ++visibleCount;
        }
        this.m_columnMap = new int[visibleCount];
        int mapIndex = 0;
        for (int i = 0; i < this.m_baseModel.getColumnCount(); ++i) {
            if (!this.isColumnVisible(i)) continue;
            this.m_columnMap[mapIndex++] = i;
        }
    }

    private int getBaseColumnIndex(int visibleColumnIndex) {
        try {
            return this.m_columnMap[visibleColumnIndex];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return -1;
        }
    }

    protected abstract boolean isColumnVisible(int var1);

    protected void setColumnVisible(int columnIndex, boolean isVisible) {
        this.allocate();
        super.fireTableStructureChanged();
    }
}

