/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.browser;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.layout.Layout;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.javatools.editor.BasicEditorPane;

abstract class AbstractFlatEditorDecorator
extends Editor
implements FindableEditor {
    private Editor _editor;

    AbstractFlatEditorDecorator() {
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this._editor != null && this._editor instanceof FindableEditor ? ((FindableEditor)this._editor).getFocusedEditorPane() : null;
    }

    public void editorShown() {
        super.editorShown();
        this._editor.editorShown();
    }

    public void editorHidden() {
        super.editorHidden();
        this._editor.editorHidden();
    }

    public Component getDefaultFocusComponent() {
        return this._editor.getDefaultFocusComponent();
    }

    public Node[] getDependentNodes() {
        return this._editor.getDependentNodes();
    }

    public Controller getController() {
        return this._editor.getController();
    }

    public String getTabDescription() {
        return this._editor.getTabDescription();
    }

    public synchronized Icon getTabIcon() {
        return this._editor.getTabIcon();
    }

    public String getTabLabel() {
        return this._editor.getTabLabel();
    }

    public String getTitleLabel() {
        return this._editor.getTitleLabel();
    }

    public void open() {
        Node delegateNode = this.createDelegateNode();
        if (delegateNode == null) {
            throw new OpenAbortedException();
        }
        try {
            this._editor = this.createDelegateEditor(delegateNode);
            if (this._editor != null) {
                delegateNode.open();
                this._open(delegateNode);
                return;
            }
        }
        catch (Exception e) {
            this._editor = null;
        }
        if (this._editor == null) {
            this._editor = this.createTextEditor(delegateNode);
            this._open(delegateNode);
        }
    }

    private void _open(Node delegateNode) {
        if (this._editor.getContext() == null) {
            this._editor.setContext(new Context(delegateNode));
        }
        this.initializeDelegateEditor(this._editor);
        this._editor.open();
    }

    private Editor createTextEditor(Node delegateNode) {
        CodeEditor editor = new CodeEditor();
        editor.setContext(new Context((Node)new TextNode(delegateNode.getURL()){

            protected boolean isTrackedInNodeCache() {
                return false;
            }
        }));
        return editor;
    }

    public void close() {
        super.close();
        if (this._editor != null) {
            this.releaseDelegateData(this._editor);
            this._editor.close();
            this._editor = null;
        }
    }

    public URL getPreferredLayoutURL() {
        return this._editor.getPreferredLayoutURL();
    }

    public void setPreferredLayoutURL(URL param1) {
        this._editor.setPreferredLayoutURL(param1);
    }

    public void initializeLayout(Layout param1) {
        this._editor.initializeLayout(param1);
    }

    public void initializeActiveLayout() {
        this._editor.initializeActiveLayout();
    }

    public boolean isReady() {
        return this._editor.isReady();
    }

    public String getDisplayName() {
        return this._editor != null ? this._editor.getDisplayName() : "";
    }

    public String getType() {
        return this._editor.getType();
    }

    public void setType(String param1) {
        this._editor.setType(param1);
    }

    public String getPreferredLayoutBaseName() {
        return this._editor.getPreferredLayoutBaseName();
    }

    public void setPreferredLayoutBaseName(String param1) {
        this._editor.setPreferredLayoutBaseName(param1);
    }

    public void addPreferredLayoutListener(PreferredLayoutListener param1) {
        this._editor.addPreferredLayoutListener(param1);
    }

    public void removePreferredLayoutListener(PreferredLayoutListener param1) {
        this._editor.removePreferredLayoutListener(param1);
    }

    public void update(Object o, UpdateMessage update) {
        if (this._editor != null) {
            this._editor.update(o, update);
        }
    }

    public Component getGUI() {
        return this._editor.getGUI();
    }

    public Component getFixedLeftMargin() {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getFixedLeftMargin() : null;
    }

    public Component getFixedRightMargin() {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getFixedRightMargin() : null;
    }

    public Component getFixedTopMargin() {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getFixedTopMargin() : null;
    }

    public Component getScrollableLeftMargin() {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getScrollableLeftMargin() : null;
    }

    public Component getScrollableTopMargin() {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getScrollableTopMargin() : null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Editor editor = this.getFlatEditorDelegate();
        if (editor != null) {
            editor.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public Object getEditorAttribute(String attribute) {
        Editor editor = this.getFlatEditorDelegate();
        return editor != null ? editor.getEditorAttribute(attribute) : null;
    }

    public void loadSettings(StructuredPropertyAccess element) {
        Editor editor = this.getFlatEditorDelegate();
        if (editor != null) {
            editor.loadSettings(element);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Editor editor = this.getFlatEditorDelegate();
        if (editor != null) {
            editor.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void saveSettings(StructuredPropertyAccess element) {
        Editor editor = this.getFlatEditorDelegate();
        if (editor != null) {
            editor.saveSettings(element);
        }
    }

    protected abstract Node createDelegateNode();

    protected abstract Editor createDelegateEditor(Node var1);

    protected void initializeDelegateEditor(Editor delegateEditor) {
    }

    protected void releaseDelegateData(Editor delegateEditor) {
    }

    private Editor getFlatEditorDelegate() {
        if (this._editor != null && Boolean.TRUE != (Boolean)this._editor.getEditorAttribute("old_editor")) {
            return this._editor;
        }
        return null;
    }
}

