/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.util.RunnerTimeoutTask;

public class RunnerOutputTask
implements Runnable {
    private final RunProcess _process;
    private final Collection<VCSStreamMonitor> _monitors;
    private final InputStream _in;
    private StringBuilder _outputBuffer;
    private ByteArrayOutputStream _outputStreamBytes;
    private boolean _bufferBytes;
    private Exception _exception;
    private RunnerTimeoutTask _timeoutTask;
    private boolean _exit;

    public RunnerOutputTask(RunProcess process, Collection<VCSStreamMonitor> monitors, InputStream in) {
        this._process = process;
        this._monitors = new ArrayList<VCSStreamMonitor>(monitors);
        this._in = in;
    }

    public void setBufferBytes(boolean bufferBytes) {
        this._bufferBytes = bufferBytes;
    }

    @Override
    public void run() {
        if (this._bufferBytes) {
            this._outputStreamBytes = new ByteArrayOutputStream();
            this.runByteReader();
        } else {
            this._outputBuffer = new StringBuilder();
            this.runCharacterReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runByteReader() {
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(this._in);
            byte[] byteBuffer = new byte[(int)Math.pow(2.0, 10.0)];
            while (true) {
                int c;
                if ((c = pushbackInputStream.read()) < 0 || this._exit) {
                    if (this._timeoutTask == null) return;
                    this._timeoutTask.restart();
                    this._timeoutTask.setExitFlag();
                    return;
                }
                pushbackInputStream.unread(c);
                int n = pushbackInputStream.read(byteBuffer);
                if (n == 0) continue;
                if (this._timeoutTask != null) {
                    this._timeoutTask.restart();
                }
                this._outputStreamBytes.write(byteBuffer, 0, n);
                continue;
                break;
            }
        }
        catch (Exception e) {
            if (this._exit) {
                if (this._timeoutTask == null) return;
                this._timeoutTask.restart();
                this._timeoutTask.setExitFlag();
                return;
            }
            try {
                this._exception = e;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (this._timeoutTask != null) {
                    this._timeoutTask.restart();
                    this._timeoutTask.setExitFlag();
                }
            }
        }
        this.runExiting();
    }

    /*
     * Exception decompiling
     */
    private void runCharacterReader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection getMonitors() {
        return Collections.unmodifiableCollection(this._monitors);
    }

    protected void log(String message) {
    }

    protected void doLineUpdate(String s) throws Exception {
        if (this._monitors == null) {
            return;
        }
        Iterator<VCSStreamMonitor> itr = this._monitors.iterator();
        while (itr.hasNext()) {
            itr.next().dispatchEvent(2, s, this._process);
        }
    }

    protected void doPatternCheck(String s) throws Exception {
        if (this._monitors == null) {
            return;
        }
        for (VCSStreamMonitor monitor : this._monitors) {
            String pattern = monitor.getPattern();
            if (pattern == null || s.indexOf(pattern) < 0) continue;
            monitor.dispatchEvent(1, null, this._process);
        }
    }

    protected Integer getExitCode() {
        return this._process.getStarter().getExitCode();
    }

    protected void runExiting() {
        RunnerOutputTask.terminateRunProcess(this._process);
    }

    public void setTimeoutTask(RunnerTimeoutTask timeoutTask) {
        this._timeoutTask = timeoutTask;
    }

    public synchronized void setExitFlag() {
        this._exit = true;
    }

    public Exception getException() {
        return this._exception;
    }

    public String getOutput() {
        if (this._bufferBytes) {
            return this._outputStreamBytes != null ? new String(this._outputStreamBytes.toByteArray()) : null;
        }
        return this._outputBuffer != null ? this._outputBuffer.toString() : null;
    }

    public byte[] getOutputBytes() {
        if (this._bufferBytes) {
            return this._outputStreamBytes != null ? this._outputStreamBytes.toByteArray() : null;
        }
        return this._outputBuffer != null ? this._outputBuffer.toString().getBytes() : null;
    }

    public static final void terminateRunProcess(final RunProcess process) {
        Runnable r = new Runnable(){

            @Override
            public final void run() {
                process.terminate();
            }
        };
        new Thread(r, "RunnerOutputTask Terminate").start();
    }

    private static final class CharSequenceLineIterator
    implements Iterator {
        private final CharSequence _sequence;
        private int _i;

        CharSequenceLineIterator(CharSequence sequence) {
            this._sequence = sequence;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.seekNextNL() >= this._i;
        }

        public Object next() {
            int n = this.seekNextNL();
            String next = ((Object)this._sequence.subSequence(this._i, n)).toString();
            this._i = this.skipNL(n);
            return next;
        }

        public String remainder(int min) {
            int n = this._sequence.length();
            int i = Math.max(min, this._i);
            return i >= n ? null : ((Object)this._sequence.subSequence(i, n)).toString();
        }

        private int seekNextNL() {
            int n = this._sequence.length();
            for (int i = this._i; i < n; ++i) {
                char c = this._sequence.charAt(i);
                if (c != '\n' && c != '\r') continue;
                return i;
            }
            return -1;
        }

        private int skipNL(int i) {
            int n = this._sequence.length();
            if (i >= n) {
                return i;
            }
            char c = this._sequence.charAt(i);
            if (c == '\r') {
                if (++i >= n) {
                    return i;
                }
                c = this._sequence.charAt(i);
            }
            if (c == '\n') {
                ++i;
            }
            return i;
        }
    }
}

