/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.nav;

import java.awt.Component;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.vcs.VCSRegistry;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.ideri.navigator.NavigatorDockableFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;

public class VersioningNavigatorManager
extends DefaultNavigatorManager {
    public static final String NAVIGATOR_WINDOW_ID = "VersioningNavigatorWindow";
    private static final String NAVIGATOR_DEFAULT_NAME = "VersioningNavigator";
    private static final VersioningNavigatorManager _instance = new VersioningNavigatorManager();
    private JMenuItem _navigatorMenuItem;
    private final DefaultContainer _rootFolder = new DefaultContainer(){

        public String getShortLabel() {
            String label = VCSArb.getString(260);
            int mnemonic = StringUtils.getMnemonicKeyCode((String)label);
            label = StringUtils.stripMnemonic((String)label);
            if (mnemonic != 0) {
                label = StringUtil.removeMnemonic((String)label, (char)((char)mnemonic));
            }
            return label;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"navconnections.png");
        }
    };

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new DefaultNavigatorWindow(context, viewId.getId()){

            public String getTitleName() {
                String title = this.getTabName();
                AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)title, (boolean)false);
                return title;
            }
        };
    }

    public static final VersioningNavigatorManager getInstance() {
        return _instance;
    }

    public void initialize() {
        super.initialize();
        IdeAction showAction = this.getShowAction();
        Menubar menuMgr = Ide.getMenubar();
        this._navigatorMenuItem = menuMgr.createMenuItem((ToggleAction)showAction);
        JMenu teamSubmenu = VCSMenuUtils.getViewTeamSubmenu();
        menuMgr.add((Component)this._navigatorMenuItem, teamSubmenu, 100.0f);
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void addinsLoaded(IdeEvent idee) {
                for (String id : VCSRegistry.keySet()) {
                    ConnectionProvider provider = ConnectionProvider.lookupProvider(id);
                    if (provider == null) continue;
                    try {
                        Element element = provider.getConnectionListNode();
                        VersioningNavigatorManager.this._rootFolder.add(element, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }

    public String getViewCategory() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/jdevimpl/vcs/nav/accelerators.xml";
    }

    public String getDefaultName() {
        return NAVIGATOR_DEFAULT_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID, null, (String)StringUtils.stripMnemonic((String)VCSArb.getString(260)), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)VCSArb.getString(260))), (Icon)OracleIcons.getIcon((String)"navconnections.png"), null, (boolean)true);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = new DockingParam();
        param.setPosition(0);
        return param;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideversioningnavigator_html");
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)this._rootFolder, false, 0);
    }

    protected void configureNavigator(NavigatorWindow navigator) {
        navigator.setType(32);
    }

    protected DockableFactory createDockableFactory() {
        return new NavigatorDockableFactory((NavigatorManager)this){

            public void install() {
                super.install();
            }

            public Dockable getDockable(ViewId viewId) {
                return super.getDockable(viewId);
            }

            protected DockingParam createDockingParam() {
                return VersioningNavigatorManager.this.createNavigatorDockingParam();
            }
        };
    }
}

