/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSNewProjectPanel;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.util.FileHandler;
import oracle.jdevimpl.vcs.util.SimpleChoiceDialog;

public final class NewFilesHandler
extends FileHandler {
    private final VCSDirectoryWatcher _watcher;
    private final URLFilter _versionedFilter;
    private String _hintText = null;
    private URL _projectDirURL;

    public NewFilesHandler(VCSDirectoryWatcher watcher, String vcsId) {
        this._watcher = watcher;
        this._versionedFilter = VCSProfiles.getInstance().getProfile(vcsId).getURLFilter("oracle.jdeveloper.vcs.filters.url.CONTROL");
        assert (this._versionedFilter != null);
    }

    @Deprecated
    public NewFilesHandler(VCSDirectoryWatcher watcher, URLFilter versionedFilter) {
        this._watcher = watcher;
        this._versionedFilter = versionedFilter;
    }

    public void setNewProjectDirectory(URL url) {
        this._projectDirURL = url;
    }

    public void setDialogHintText(String text) {
        this._hintText = text;
    }

    public void handleNewFiles(final Context context, final String name) throws Exception {
        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    NewFilesHandler.this.handleNewFilesImpl(context, name);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
            }
        });
    }

    private void handleNewFilesImpl(Context context, String name) throws Exception {
        VCSFileEventSender.fireFileStructureChanged(this._watcher.getNewRegularURLs().toArray(new URL[0]));
        if (this._watcher.hasNewWorkspaces()) {
            NewFilesHandler.openWorkspaces(context, this._watcher.getNewWorkspaces());
            return;
        }
        Workspace activeWorkspace = this.getActiveWorkspace(context);
        if (this._watcher.hasNewProjects()) {
            if (activeWorkspace == null) {
                activeWorkspace = this.createNewWorkspace(context, name);
            }
            this.openProjectsInWorkspace(context, activeWorkspace, this._watcher);
            return;
        }
        if (this._watcher.hasNewRegularURLs()) {
            this.handleNoProjects(context, this._watcher, activeWorkspace, name);
            return;
        }
    }

    private final Workspace createNewWorkspace(Context context, String name) throws IllegalAccessException, InstantiationException {
        return NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)this.createWorkspaceURL(this._watcher.getWatchedDirectory(), name));
    }

    private URL createWorkspaceURL(URL baseDir, String name) {
        return URLFactory.newURL((URL)baseDir, (String)(NewFilesHandler.convertToFileName(name) + ".jws"));
    }

    private void openProjectsInWorkspace(Context context, Workspace workspace, VCSDirectoryWatcher watcher) throws IllegalAccessException, InstantiationException {
        if (!watcher.hasNewProjects()) {
            return;
        }
        for (URL url : watcher.getNewProjects()) {
            NodeFactory.uncache((URL)url);
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node == null || !(node instanceof Project) || workspace.containsChild((Element)node) || !NewFilesHandler.migrateSystemFile(node)) continue;
            workspace.add((Element)node, true);
            FileOpenHistory.getInstance().updateProjectHistory(node.getURL());
            NewFilesHandler.selectNavigatorTNode(context, (Element)node);
        }
    }

    private Workspace getActiveWorkspace(Context context) {
        Workspace contextWorkspace = context.getWorkspace();
        if (contextWorkspace == null) {
            contextWorkspace = Ide.getActiveWorkspace();
        }
        Iterator it = Ide.getWorkspaces().getChildren();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Workspace) || contextWorkspace != null && o != contextWorkspace) continue;
            return (Workspace)o;
        }
        return null;
    }

    private void handleNoProjects(Context context, VCSDirectoryWatcher watcher, Workspace activeWorkspace, String name) throws IOException, IllegalAccessException, InstantiationException {
        SimpleChoiceDialog dialog;
        ResourcePicker picker = ResourcePicker.getPicker(GenericClient.class);
        ArrayList<String> cText = new ArrayList<String>();
        cText.add(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"));
        cText.add(picker.getString("NEW_FILES_CHOICE_CREATE_NEW_PROJECT"));
        cText.add(picker.getString("NEW_FILES_CHOICE_EDIT_FILES"));
        cText.add(picker.getString("NEW_FILES_CHOICE_DO_NOT_OPEN"));
        Project activeProject = NewFilesHandler.determineActiveProject(context);
        Collection urls = watcher.getNewRegularURLs();
        if (activeProject != null) {
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            Assert.check((contentSet != null ? 1 : 0) != 0);
            URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
            Assert.check((newProjectDirectoryUrl != null ? 1 : 0) != 0);
            if (newProjectDirectoryUrl == null) {
                return;
            }
            if (contentSet.canHaveMember(newProjectDirectoryUrl)) {
                return;
            }
        }
        if (activeWorkspace == null || activeProject == null) {
            cText.remove(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"));
        }
        if ((dialog = new SimpleChoiceDialog(picker.getString("NEW_FILES_TITLE"), picker.getString("NEW_FILE_PROMPT"), cText.toArray(new String[0]), null)).show()) {
            int choice = dialog.getChoice();
            if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"))) {
                URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
                ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
                contentSet.getURLPath().add(newProjectDirectoryUrl);
                UpdateMessage.fireStructureChanged((Subject)activeProject);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_CREATE_NEW_PROJECT"))) {
                if (activeWorkspace == null) {
                    activeWorkspace = this.createNewWorkspace(context, name);
                }
                this.createNewProject(context, urls, activeWorkspace, name);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_EDIT_FILES"))) {
                this.openNewFiles(urls);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_DO_NOT_OPEN"))) {
                // empty if block
            }
        }
    }

    private void openNewFiles(final Collection<URL> urls) {
        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                for (URL url : urls) {
                    String suffix = URLFileSystem.getSuffix((URL)url);
                    if (suffix.equals(".jpr") || suffix.equals(".jws")) continue;
                    try {
                        EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                }
            }
        });
    }

    private void createNewProject(Context context, Collection<URL> urls, Workspace activeWorkspace, String name) throws IOException, IllegalAccessException, InstantiationException {
        ResourcePicker picker = ResourcePicker.getPicker(GenericClient.class);
        URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
        URL projectUrl = VCSNewProjectPanel.getProjectURL(newProjectDirectoryUrl, NewFilesHandler.convertToFileName(name), picker.getString("PROJECT_MSG_FILE_TYPE"), this._hintText != null ? this._hintText : picker.getString("PROJECT_TITLE_DIALOG"));
        if (projectUrl == null) {
            return;
        }
        Project project = NewEmptyProjectCommand.createProjectInWorkspace((URL)projectUrl, (Workspace)activeWorkspace);
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
        contentSet.getURLPath().setEntries(new URL[0]);
        contentSet.getURLPath().add(newProjectDirectoryUrl);
        project.save();
        UpdateMessage.fireStructureChanged((Subject)project);
        NewFilesHandler.selectNavigatorTNode(context, (Element)project);
    }

    private final URL getNewProjectDirectory(Collection urls) {
        if (this._projectDirURL != null) {
            return this._projectDirURL;
        }
        if (urls.size() <= 0) {
            return null;
        }
        URL url = (URL)urls.iterator().next();
        URL directoryUrl = null;
        while ((url = URLFileSystem.getParent((URL)url)) != null && this._versionedFilter.accept(url)) {
            directoryUrl = url;
        }
        return directoryUrl;
    }
}

