/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.ActionRequirement;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.generic.profile.AbstractActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionAffectsInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionRequiresInfo;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;

public class VCSActionInfoImpl
implements VCSActionInfo {
    private static final URLFilter sNullURLFilter = VCSURLFilters.createNullFilter();
    private static final VCSStatusFilter sNullStatusFilter = new VCSStatusFilter(){

        @Override
        public boolean accept(VCSStatus status) {
            return true;
        }
    };
    private final VCSProfile _profile;
    private final AbstractActionInfo _info;
    private Collection _changeListInfos;
    private Boolean _isChangeListAction;
    private Collection _requirements;
    private URLFilter _singleURLFilter;
    private VCSStatusFilter _singleStatusFilter;

    public VCSActionInfoImpl(VCSProfile profile, AbstractActionInfo info) {
        this._profile = profile;
        this._info = info;
        this._changeListInfos = Collections.EMPTY_LIST;
    }

    public VCSActionInfoImpl(VCSProfile profile, AbstractActionInfo info, Collection changeListInfo) {
        this(profile, info);
        this._changeListInfos = changeListInfo;
    }

    @Override
    public VCSCommandStyle getStyle() {
        return this._info.getStyle();
    }

    @Override
    public VCSCommandType getType() {
        return this._info.getType();
    }

    @Override
    public Boolean getToggleStatus() {
        return this._info.getToggleStatus();
    }

    @Override
    public String getDialogTitle() {
        return null;
    }

    @Override
    public String getDialogHint() {
        return null;
    }

    @Override
    public String getHelpTopicId() {
        return null;
    }

    @Override
    public boolean isChangeListAction() {
        if (this._isChangeListAction == null) {
            Iterator i = this._changeListInfos.iterator();
            this._isChangeListAction = Boolean.FALSE;
            block0: while (i.hasNext()) {
                Iterator k;
                ChangeListInfo clInfo = (ChangeListInfo)i.next();
                Iterator j = clInfo.getContextMenu().getSections().iterator();
                while (j.hasNext()) {
                    k = ((SectionInfo)j.next()).getActionRefs().iterator();
                    while (k.hasNext()) {
                        if (!this._info.getID().equals((String)k.next())) continue;
                        this._isChangeListAction = Boolean.TRUE;
                        break block0;
                    }
                }
                j = clInfo.getToolbar().getSections().iterator();
                while (j.hasNext()) {
                    k = ((SectionInfo)j.next()).getActionRefs().iterator();
                    while (k.hasNext()) {
                        if (!this._info.getID().equals((String)k.next())) continue;
                        this._isChangeListAction = Boolean.TRUE;
                        break block0;
                    }
                }
            }
        }
        return this._isChangeListAction;
    }

    @Override
    public boolean requirementsSatisfied(Context context) throws Exception {
        boolean satisfied = true;
        for (ActionRequirement requirement : this.getRequirements()) {
            satisfied = requirement.isSatisfied(this._profile, context, null);
        }
        return satisfied;
    }

    @Override
    public Collection getFilteredSelection(Context context) throws Exception {
        Locatable[] selection = VCSContextUtils.getContextLocatables(context, this._profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT"));
        if (selection == null || selection.length == 0) {
            return Collections.EMPTY_LIST;
        }
        VCSStatus[] statuses = this._profile.getStatusCache().get(VCSModelUtils.convertNodesToURLs(selection));
        HashSet<Locatable> union = new HashSet<Locatable>(selection.length);
        Collection affects = this._info.getAffects();
        if (affects != null && !affects.isEmpty()) {
            for (ActionAffectsInfo affectsInfo : affects) {
                URLFilter urlFilter = this.createIntersectionFilter(this.resolveURLFilterRefs(affectsInfo.getURLFilterRefs()));
                VCSStatusFilter statusFilter = this.createIntersectionFilter(this.resolveStatusFilterRefs(affectsInfo.getStatusFilterRefs()));
                for (int i = 0; i < selection.length; ++i) {
                    URL url = selection[i].getURL();
                    if (!urlFilter.accept(url) || statuses[i] == null || !statusFilter.accept(statuses[i])) continue;
                    union.add(selection[i]);
                }
            }
            return union;
        }
        return Arrays.asList(selection);
    }

    protected URLFilter getSingleURLFilter() {
        if (this._singleURLFilter == null) {
            ArrayList<URLFilter> filters = new ArrayList<URLFilter>(10);
            Collection affects = this._info.getAffects();
            if (affects != null && !affects.isEmpty()) {
                for (ActionAffectsInfo affectsInfo : affects) {
                    filters.add(this.createIntersectionFilter(this.resolveURLFilterRefs(affectsInfo.getURLFilterRefs())));
                }
            }
            this._singleURLFilter = this.createUnionFilter(filters.toArray(new URLFilter[filters.size()]));
        }
        return this._singleURLFilter;
    }

    protected VCSStatusFilter getSingleStatusFilter() {
        if (this._singleStatusFilter == null) {
            ArrayList<VCSStatusFilter> filters = new ArrayList<VCSStatusFilter>(10);
            Collection affects = this._info.getAffects();
            if (affects != null && !affects.isEmpty()) {
                for (ActionAffectsInfo affectsInfo : affects) {
                    filters.add(this.createIntersectionFilter(this.resolveStatusFilterRefs(affectsInfo.getStatusFilterRefs())));
                }
            }
            this._singleStatusFilter = this.createUnionFilter(filters.toArray(new VCSStatusFilter[filters.size()]));
        }
        return this._singleStatusFilter;
    }

    private URLFilter createIntersectionFilter(URLFilter[] filters) {
        if (filters == null) {
            return sNullURLFilter;
        }
        switch (filters.length) {
            case 0: {
                return sNullURLFilter;
            }
            case 1: {
                return filters[0];
            }
        }
        return VCSURLFilters.createChainedANDFilter(filters);
    }

    private URLFilter createUnionFilter(URLFilter[] filters) {
        if (filters == null) {
            return sNullURLFilter;
        }
        switch (filters.length) {
            case 0: {
                return sNullURLFilter;
            }
            case 1: {
                return filters[0];
            }
        }
        return VCSURLFilters.createChainedORFilter(filters);
    }

    private VCSStatusFilter createIntersectionFilter(VCSStatusFilter[] filters) {
        if (filters == null) {
            return sNullStatusFilter;
        }
        switch (filters.length) {
            case 0: {
                return sNullStatusFilter;
            }
            case 1: {
                return filters[0];
            }
        }
        return VCSStatusFilters.createChainedANDFilter(filters);
    }

    private VCSStatusFilter createUnionFilter(VCSStatusFilter[] filters) {
        if (filters == null) {
            return sNullStatusFilter;
        }
        switch (filters.length) {
            case 0: {
                return sNullStatusFilter;
            }
            case 1: {
                return filters[0];
            }
        }
        return VCSStatusFilters.createChainedORFilter(filters);
    }

    private URLFilter[] resolveURLFilterRefs(Collection refs) {
        if (refs == null || refs.isEmpty()) {
            return new URLFilter[0];
        }
        ArrayList<URLFilter> filters = new ArrayList<URLFilter>(refs.size());
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            URLFilter filter = this._profile.getURLFilter((String)it.next());
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters.toArray(new URLFilter[filters.size()]);
    }

    private VCSStatusFilter[] resolveStatusFilterRefs(Collection refs) {
        if (refs == null || refs.isEmpty()) {
            return new VCSStatusFilter[0];
        }
        ArrayList<VCSStatusFilter> filters = new ArrayList<VCSStatusFilter>(refs.size());
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            VCSStatusFilter filter = this._profile.getStatusFilter((String)it.next());
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters.toArray(new VCSStatusFilter[filters.size()]);
    }

    private Collection getRequirements() {
        if (this._requirements == null) {
            ActionRequiresInfo requiresInfo = this._info.getRequires();
            List c = requiresInfo != null ? requiresInfo.getRequirements() : Collections.EMPTY_LIST;
            this._requirements = c != null ? c : Collections.EMPTY_LIST;
        }
        return this._requirements;
    }
}

