/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ideri.util.BundlePropertyResolver;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;

final class GLazyIdeAction
extends BundlePropertyResolver {
    private static final Map sIconReferences = new HashMap(10);
    private final String _iconRef;

    protected GLazyIdeAction(String iconRef, String resourceClass, ClassLoader resourceClassLoader, Map map) {
        super(resourceClass, resourceClassLoader, map);
        this._iconRef = iconRef;
    }

    public static IdeAction getAction(int commandId, String commandClass, Class resourceClass, String resourcePrefix, String iconReference) {
        IdeAction action = IdeAction.find((int)commandId);
        if (action == null) {
            action = IdeAction.get((int)commandId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("SmallIcon", resourcePrefix + "_ICON");
            map.put("Name", resourcePrefix + "_NAME");
            map.put("NoCtxName", resourcePrefix + "_INDEPENDENT_NAME");
            map.put("MnemonicKey", resourcePrefix + "_MNEMONIC");
            map.put("ShortDescription", resourcePrefix + "_TOOLTIP");
            action.addPropertyResolver((PropertyResolver)new GLazyIdeAction(iconReference, resourceClass.getName(), resourceClass.getClassLoader(), map));
            action.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
            action.setCommand(commandClass);
            action.setEnabled(false);
        }
        return action;
    }

    public Object get(String key) {
        if (key == "SmallIcon" && this._iconRef != null) {
            return this.resolveIconReference(this._iconRef);
        }
        return super.get(key);
    }

    private Icon resolveIconReference(String iconRef) {
        int[] id = (int[])sIconReferences.get(iconRef);
        if (id != null) {
            return VCSIconArb.getInstance().getIconImpl(id[0]);
        }
        return null;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.ADD", new int[]{10});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.ADD_ALL", new int[]{11});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.UNDO_CHECKOUT", new int[]{12});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.COMPARE_PREVIOUS", new int[]{13});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.MERGE", new int[]{16});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.SYNCHRONIZE", new int[]{17});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.SYNCHRONIZE_ALL", new int[]{18});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.CHECK_IN", new int[]{19});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.CHECK_IN_ALL", new int[]{20});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.PENDING_CHANGES", new int[]{14});
    }
}

