/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.changeset;

import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.changeset.ChangeSetController;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.changeset.ChangeSetUpdate;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

class ChangeSetAddin
implements Addin,
VCSEBComponent {
    ChangeSetAddin() {
    }

    public void initialize() {
        IdeAction toggleChangeSetsAction = IdeAction.get((int)ChangeSetChangeList.TOGGLE_CHANGE_SETS_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.ToggleChangeSetsCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(92)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(92)), (Icon)OracleIcons.getIcon((String)"group.png"), null, (boolean)true);
        toggleChangeSetsAction.putValue("Check", (Object)Boolean.TRUE);
        ChangeSetController controller = new ChangeSetController();
        IdeAction commitChangeSetAction = IdeAction.get((int)ChangeSetChangeList.COMMIT_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.CommitChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(99)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(99)), null, null, (boolean)true);
        commitChangeSetAction.addController((Controller)controller);
        IdeAction editChangeSetAction = IdeAction.get((int)ChangeSetChangeList.EDIT_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.EditChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(93)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(93)), null, null, (boolean)true);
        editChangeSetAction.addController((Controller)controller);
        IdeAction makeDefaultChangeSetAction = IdeAction.get((int)ChangeSetChangeList.MAKE_DEFAULT_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.MakeDefaultChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(94)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(94)), null, null, (boolean)true);
        makeDefaultChangeSetAction.addController((Controller)controller);
        IdeAction unsetDefaultChangeSetAction = IdeAction.get((int)ChangeSetChangeList.UNSET_DEFAULT_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.UnsetDefaultChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(95)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(95)), null, null, (boolean)true);
        unsetDefaultChangeSetAction.addController((Controller)controller);
        IdeAction newChangeSetAction = IdeAction.get((int)ChangeSetChangeList.NEW_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.NewChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(96)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(96)), null, null, (boolean)true);
        newChangeSetAction.addController((Controller)controller);
        IdeAction removeChangeSetAction = IdeAction.get((int)ChangeSetChangeList.REMOVE_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.RemoveChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(97)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(97)), null, null, (boolean)true);
        removeChangeSetAction.addController((Controller)controller);
        IdeAction removeFromChangeSetAction = IdeAction.get((int)ChangeSetChangeList.REMOVE_FROM_CHANGE_SET_COMMAND_ID, (String)"oracle.jdeveloper.vcs.changeset.cmd.RemoveFromChangeSetCommand", (String)StringUtils.stripMnemonic((String)VCSArb.getString(98)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.getString(98)), null, null, (boolean)true);
        removeFromChangeSetAction.addController((Controller)controller);
        VCSEventBus.addToBus(this);
    }

    @Override
    public final void handleMessage(VCSEBMessage message) {
        VCSNodeUpdate update;
        if (message instanceof ChangeSetUpdate) {
            ChangeSetUpdate update2 = (ChangeSetUpdate)message;
            try {
                if (update2.getWhat() == ChangeSetUpdate.PENDING) {
                    ChangeSetRegistry.lookup(update2.getSystemId()).handlePending(update2.getURLs());
                }
                if (update2.getWhat() == ChangeSetUpdate.COMMITTED) {
                    ChangeSetRegistry.lookup(update2.getSystemId()).handleCommitted(update2.getURLs());
                }
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
            }
            return;
        }
        if (message instanceof VCSNodeUpdate && (update = (VCSNodeUpdate)message).getWhat() == VCSNodeUpdate.RENAMED) {
            VCSExtension extension = VCSExtensionUtils.getActiveExtension(update.getOldURL());
            if (extension == null) {
                return;
            }
            ChangeSetAdapter adapter = ChangeSetRegistry.lookup(extension.getId());
            if (adapter == null) {
                return;
            }
            try {
                adapter.handleRenamed(update.getOldURL(), update.getNode().getURL());
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
            }
            return;
        }
    }
}

