/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.merge;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.resource.MergeArb;

public class MergeCloseNodeCommand
extends CloseNodeCommand {
    private static String _delegateCommand;

    public static final void setDelegateCommand(String delegateCommand) {
        _delegateCommand = delegateCommand;
    }

    public int checkSave(Iterator targets, boolean canCancel) {
        if (canCancel) {
            ArrayList targets0 = new ArrayList();
            while (targets.hasNext()) {
                targets0.add(targets.next());
            }
            if (!MergeCloseNodeCommand.confirmCloseMerge(targets0.iterator())) {
                return 1;
            }
            targets = targets0.iterator();
        }
        return super.checkSave(targets, canCancel);
    }

    public int doit() throws Exception {
        Assert.check((_delegateCommand != null ? 1 : 0) != 0);
        return CommandProcessor.getInstance().invoke(CommandProcessor.createCommand((String)_delegateCommand, (Context)this.getContext()));
    }

    static final boolean confirmCloseMerge(Iterator itr) {
        LinkedHashSet<Node> openMergeEditorNodes = new LinkedHashSet<Node>();
        block0: while (itr.hasNext()) {
            Node node = (Node)itr.next();
            for (Object editor : EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)node))) {
                if (!(editor instanceof AbstractMergeEditor) || ((AbstractMergeEditor)((Object)editor)).isCompleteState()) continue;
                openMergeEditorNodes.add(node);
                continue block0;
            }
        }
        if (openMergeEditorNodes.isEmpty()) {
            return true;
        }
        CheckBoxListModel listModel = new CheckBoxListModel();
        for (Node node : openMergeEditorNodes) {
            listModel.addElement((Object)node, node.getIcon(), false, false, URLFileSystem.getPlatformPathName((URL)node.getURL()));
        }
        int result = SelectFilesPanel.showDialog((String)MergeArb.getString(17), (String)MergeArb.format(15, listModel.findTextForElement(0)), (String)MergeArb.getString(16), (CheckBoxListModel)listModel, (boolean)false, (int)2, null);
        return result == 0;
    }
}

