/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.Element;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.Category;
import oracle.jdeveloper.vcs.vop.VersionOperationCategorizer;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationTreeCellRenderer;
import oracle.jdeveloper.vcs.vop.VersionOperationTreeModel;

public class VersionOperationTreePanel
extends BaseVersionOperationPanel {
    private JTree _tree;
    private JScrollPane _scrollPane;
    private String _defaultCategory;

    @Override
    protected final void createComponents() {
        this._tree = new JTree();
        this._tree.setCellRenderer(new VersionOperationTreeCellRenderer(){

            @Override
            protected final String getDefaultCategory() {
                return VersionOperationTreePanel.this._defaultCategory;
            }
        });
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(4);
        this._scrollPane = new JScrollPane(this._tree);
    }

    @Override
    protected final JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    @Override
    protected final void initializePreferredSize() {
        VersionOperationTreeCellRenderer renderer = new VersionOperationTreeCellRenderer();
        renderer.setText("Dummy");
        Insets i = this.getScrollPane().getInsets();
        int width = this._tree.getPreferredSize().width;
        width += this.getScrollPane().getVerticalScrollBar().getPreferredSize().width;
        width += i.left;
        int height = 0;
        height += renderer.getPreferredSize().height * 5;
        height += i.top;
        this.getScrollPane().setPreferredSize(new Dimension(width += i.right, height += i.bottom));
    }

    @Override
    protected final void addMouseListenerImpl(MouseListener ml) {
        this._tree.addMouseListener(ml);
    }

    @Override
    protected final void removeMouseListenerImpl(MouseListener ml) {
        this._tree.removeMouseListener(ml);
    }

    @Override
    protected final void installModelImpl(VersionOperationModel model) {
        VersionOperationTreeModel treeModel = new VersionOperationTreeModel(model);
        this._tree.setModel(treeModel);
        treeModel.nodeStructureChanged((TreeNode)treeModel.getRoot());
        treeModel.getExpansionObservable().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                TreePath path = (TreePath)arg;
                if (!VersionOperationTreePanel.this._tree.isExpanded(path)) {
                    VersionOperationTreePanel.this._tree.expandPath(path);
                }
            }
        });
    }

    @Override
    protected void attachSelectionListener() {
        this._tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                VersionOperationTreePanel.this.fireSelectionChange();
            }
        });
    }

    @Override
    public final Element[] getSelection() {
        ArrayList<Element> selection = new ArrayList<Element>();
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof Element)) continue;
                selection.add((Element)node.getUserObject());
            }
        }
        return selection.toArray(new Element[selection.size()]);
    }

    public final String getSelectedCategory() {
        DefaultMutableTreeNode node;
        TreePath path = this._tree.getSelectionPath();
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof Category) {
            return ((Category)((Object)node.getUserObject())).getName();
        }
        return null;
    }

    @Override
    public final void selectAll() {
        this._tree.setSelectionInterval(0, this._tree.getRowCount() - 1);
    }

    @Override
    protected final void selectOnRightClick(MouseEvent me) {
        int row = this._tree.getRowForLocation(me.getX(), me.getY());
        if (row < 0 || row >= this._tree.getRowCount()) {
            return;
        }
        if (!this._tree.isRowSelected(row)) {
            this._tree.setSelectionRow(row);
        }
        this.requestFocus();
    }

    @Override
    protected final Component getInternalComponent() {
        return this._tree;
    }

    @Override
    public boolean isItemAtPosition(Point p) {
        return this._tree.getRowForLocation((int)p.getX(), (int)p.getY()) >= 0;
    }

    @Override
    public final void setCategorizer(VersionOperationCategorizer categorizer) {
        ((VersionOperationTreeModel)this._tree.getModel()).setCategorizer(categorizer);
    }

    @Override
    public void setCategoryCache(Map<VCSHashURL, String> categoryCache) {
        ((VersionOperationTreeModel)this._tree.getModel()).setCategoryCache(categoryCache);
    }

    @Override
    public final void fireCategoriesChanged() {
        ((VersionOperationTreeModel)this._tree.getModel()).fireCategoriesChanged();
    }

    @Override
    public void setDefaultCategory(String category) {
        this._defaultCategory = category;
        ((VersionOperationTreeModel)this._tree.getModel()).fireCategoryNodesChanged();
    }

    public final void setCategoryIcon(Icon categoryIcon) {
        ((VersionOperationTreeModel)this._tree.getModel()).setCategoryIcon(categoryIcon);
    }
}

